---
name: motion
version: 1.0.0
description: Complete Motion.dev documentation - modern animation library for React, JavaScript, and Vue (formerly Framer Motion)
author: Leonardo Balland
tags:
  - motion
  - animation
  - react
  - javascript
  - vue
  - framer-motion
  - transitions
  - gestures
  - scroll
  - spring
  - keyframes
read_when:
  - Working with Motion animations or Framer Motion
  - Implementing animations in React, Vue, or vanilla JavaScript
  - Creating scroll-linked or scroll-triggered animations
  - Building gesture-based interactions
  - Optimizing animation performance
  - Migrating from Framer Motion to Motion
---

# Motion.dev Documentation

Motion is a modern animation library for React, JavaScript, and Vue. It's the evolution of Framer Motion, offering:

- **Tiny size**: Just 2.3kb for the mini HTML/SVG version
- **High performance**: Hardware-accelerated animations
- **Flexible**: Animate HTML, SVG, WebGL, and JavaScript objects
- **Easy to use**: Intuitive API with smart defaults
- **Spring physics**: Natural, kinetic animations
- **Scroll animations**: Link values to scroll position
- **Gestures**: Drag, hover, tap, and more

## Quick Reference

### Installation

```bash
npm install motion
```

### Basic Animation

```javascript
import { animate } from "motion"

// Animate elements
animate(".box", { rotate: 360, scale: 1.2 })

// Spring animation
animate(element, { x: 100 }, { type: "spring", stiffness: 300 })

// Stagger multiple elements
animate("li", { opacity: 1 }, { delay: stagger(0.1) })
```

### React

```jsx
import { motion } from "motion/react"

<motion.div
  animate={{ rotate: 360 }}
  transition={{ duration: 2 }}
/>
```

### Scroll Animations

```javascript
import { scroll } from "motion"

scroll(animate(".box", { scale: [1, 2, 1] }))
```

## Documentation Structure

- `quick-start.md` - Installation and first animation
- More docs to be added...

## When to Use This Skill

Use this skill when:
- Implementing animations in web applications
- Optimizing animation performance
- Creating scroll-based effects
- Building interactive UI with gestures
- Migrating from Framer Motion to Motion

## External Resources

- Official site: https://motion.dev
- GitHub: https://github.com/motiondivision/motion
- Examples: https://motion.dev/examples
