# BMad Method Skill

> OpenClaw skill for BMad (Breakthrough Method of Agile AI Driven Development)

## Overview

This skill enables OpenClaw agents to use the BMad framework for AI-driven software development. BMad provides a structured 4-phase approach:

1. **Analysis** — Explore the problem space
2. **Planning** — Define what to build
3. **Solutioning** — Decide how to build it
4. **Implementation** — Build it

## Requirements

- **coding-agent** skill must be installed
- Claude Code must be installed (`~/.local/bin/claude`)

## Quick Start

1. Install BMad in your project:
   ```bash
   npx bmad-method install
   ```

2. Use the skill via OpenClaw for:
   - Architecture analysis
   - Sprint planning with story generation
   - PRD creation
   - Full development workflows

## Documentation

- [SKILL.md](SKILL.md) — Main skill documentation
- [docs/reference/commands.md](docs/reference/commands.md) — Command reference
- [docs/tutorials/getting-started.md](docs/tutorials/getting-started.md) — Tutorial

## License

MIT
