---
name: Lawyer
description: Draft contracts, review legal documents, and navigate compliance with practical legal patterns.
metadata: {"clawdbot":{"emoji":"⚖️","os":["linux","darwin","win32"]}}
---

# Legal Assistance Rules

## Important Boundaries
- This is legal information, not legal advice — always recommend consulting a licensed attorney for specific situations
- Laws vary by jurisdiction — what's valid in one country may not apply in another
- Regulations change — verify current requirements, don't rely on potentially outdated knowledge
- High-stakes matters need professionals — litigation, criminal, immigration require licensed counsel

## Contract Basics
- All parties must be clearly identified — full legal names and roles
- Define all key terms explicitly — ambiguity creates disputes
- Consideration (exchange of value) is required — something must flow both ways
- Include governing law and jurisdiction — determines which courts and laws apply
- Signatures and dates for all parties — electronic signatures valid in most jurisdictions

## Common Contract Clauses
- Limitation of liability caps damages — essential for service providers
- Indemnification shifts risk — be clear who covers what claims
- Termination clauses define exit — notice periods, grounds, and consequences
- Force majeure covers unforeseeable events — pandemics, natural disasters, war
- Confidentiality protects sensitive information — define scope and duration
- Assignment clause controls transferability — can the contract be sold or transferred?

## Intellectual Property
- Copyright exists automatically upon creation — registration adds enforcement benefits
- Trademarks protect brand identifiers — names, logos, slogans need registration for full protection
- Patents require filing and approval — ideas alone aren't protected, implementations are
- Work-for-hire: employer owns employee creations — contractors need explicit IP assignment
- Open source licenses have obligations — MIT, GPL, Apache have different requirements

## Privacy & Data
- Privacy policies must reflect actual practices — mismatches create liability
- GDPR applies to EU residents regardless of company location — consent, data rights, breach notification
- CCPA gives California residents specific rights — disclosure, deletion, opt-out of sale
- Data processing agreements needed for vendors handling personal data
- Cookie consent required in EU — implied consent isn't enough

## Business Structure
- LLC provides liability protection with tax flexibility — common for small businesses
- Corporation separates personal and business liability — required for raising investment
- Sole proprietorship has no liability separation — personal assets at risk
- Partnership needs written agreement — verbal partnerships create disputes
- Each structure has different tax implications — consult accountant alongside lawyer

## Employment
- Employment vs contractor distinction has legal tests — misclassification creates liability
- At-will employment allows termination without cause — but not for illegal reasons
- Non-competes vary by state — unenforceable in California, limited elsewhere
- Offer letters aren't contracts unless stated — define relationship clearly
- Document performance issues — termination without documentation invites claims

## Risk Reduction
- Written agreements beat verbal — if it's not written, it didn't happen
- Keep records of all agreements and communications — email trails matter
- Insurance transfers risk — professional liability, D&O, cyber insurance
- Compliance programs demonstrate good faith — policies, training, audits
- Respond to legal notices promptly — ignoring deadlines waives rights

## Red Flags
- Pressure to sign immediately — legitimate parties allow review time
- One-sided terms with no negotiation — standard doesn't mean fair
- Missing or vague termination rights — getting out matters as much as getting in
- Unlimited liability for one party — risk should be proportional and mutual
- Jurisdiction in inconvenient location — home court advantage is real

## Document Review
- Read everything before signing — "standard contract" isn't excuse for surprises
- Check definitions section first — terms may not mean what you assume
- Look for auto-renewal clauses — they survive beyond initial term
- Identify notice requirements — wrong address or method invalidates notice
- Compare against previous versions — track what changed in amendments
