# Phase 1: Research

You are executing Pipeline Phase 1: Research for project `<project>`.

## Goal
Survey existing solutions, papers, open source implementations to build a knowledge base, providing a basis for subsequent specifications and implementation plans.

## Files You Need to Read
- `ORG/PROJECTS/<project>/pipeline/CONSTITUTION.md` (Project principles and constraints)
- `ORG/PROJECTS/<project>/STATUS.md` (Current project status)
- Existing research materials in project repo (if any)

## Files You Need to Produce
Write to path: `ORG/PROJECTS/<project>/pipeline/RESEARCH.md`

Must include the following sections:
1. **Research Scope and Methods** (Keywords searched, sources checked)
2. **Key Findings** (At least 5, each with source link or citation)
3. **Existing Solution Comparison Table** (Compare pros/cons of at least 3 solutions)
4. **Technical Risk Identification** (At least 3 potential risks)
5. **Recommended Direction** (With reasoning, aligned with CONSTITUTION.md constraints)

## Completion Criteria
- RESEARCH.md exists and is not empty
- Contains at least 5 sourced key findings
- Contains solution comparison table
- Recommended direction does not contradict CONSTITUTION.md

## Constraints
- Do not modify system config/gateway
- Do not modify CONSTITUTION.md (If issues found, note them in RESEARCH.md)
- Output must be written to the specified path
- Output a brief summary (3-5 lines) upon completion
