---
name: lattice
description: >
  Initialize and manage Lattice organizations — a file-based operating system for AI agent teams
  that enables stable, long-running iterative development through an 8-phase pipeline.
  Core strengths: (1) File-driven state keeps agents on track across sessions — no context loss,
  no drift, tasks complete reliably over hours or days. (2) Three-tier failure handling
  (model escalation → peer consult → auto-triage) automatically unblocks stuck agents without
  human intervention. (3) Per-phase model configuration — use strong models for thinking-heavy
  phases (planning, review), cost-efficient models for token-heavy phases (implementation, testing),
  optimizing token cost. (4) Multi-project parallel execution
  with cron scheduling — run several projects simultaneously, each on its own cadence.
  Triggers: lattice, org framework, pipeline setup, agent team, multi-agent project, 8-phase pipeline,
  new org, new project, department setup, pipeline orchestrator, long-running tasks, model escalation,
  peer consult, auto-triage, token optimization.
---

# Lattice

Lattice is a file-based operating system for AI agent teams. It replaces volatile chat windows with persistent files, enabling agents to work stably through long, iterative development cycles via an 8-phase execution pipeline.

**Why Lattice?**

- **Stable long-running execution** — File-driven state machine ensures agents stay on track across sessions. No context window overflow, no drift. Tasks complete reliably over hours or days through structured iteration.
- **Three-tier failure handling** — When an agent gets stuck: (1) Model Escalation retries with stronger models, (2) Peer Consult gathers parallel opinions from multiple models, (3) Auto-Triage makes a judgment call (relax constraints / defer / block for human). Most blockers resolve automatically.
- **Per-phase model configuration** — Thinking-heavy phases (planning, review, architecture) need strong reasoning models; token-heavy phases (implementation, testing) can use cost-efficient coding models. This dramatically reduces overall token cost without sacrificing quality where it matters.

**Example model assignment (from a production setup):**

| Phase | Model tier | Example |
|-------|-----------|---------|
| Constitute (architecture) | Strong reasoning | Claude Opus |
| Research | Strong reasoning | Gemini Pro |
| Specify (design) | Strong reasoning | Claude Opus |
| Plan + Tasks | Strong reasoning | Claude Opus |
| Implement | Cost-efficient coding | GPT Codex |
| Test | Cost-efficient coding | GPT Codex |
| Review | Strong reasoning | Claude Opus |
| Gap Analysis | Strong reasoning | Gemini Pro |

The key insight: implementation and testing consume the most tokens (writing/running code), but don't require the most expensive models. Planning and review consume fewer tokens but need deeper reasoning. Match model strength to cognitive demand, not token volume.
- **Multi-project parallel execution** — Run multiple projects simultaneously, each with its own cron-scheduled orchestrator. Combined with OpenClaw's cron system, projects advance autonomously on independent cadences.

Templates are bundled at `templates/ORG/` relative to this skill directory.

## Quick Reference

- Full design doc: `templates/ORG/PROJECTS/pipeline-framework/DESIGN.md`
- Pipeline guide (all agents): `templates/ORG/PIPELINE_GUIDE.md`
- Sub-agent guide: `templates/ORG/PROJECTS/pipeline-framework/templates/PIPELINE_GUIDE_FOR_SUBAGENTS.md`
- Orchestrator prompt template: `templates/ORG/PROJECTS/pipeline-framework/templates/ORCHESTRATOR_PROMPT.template.md`
- Phase prompt templates: `templates/ORG/PROJECTS/pipeline-framework/templates/PHASE_PROMPTS/`
- State machine template: `templates/ORG/PROJECTS/pipeline-framework/templates/PIPELINE_STATE.template.json`

---

## Task: Initialize a New Organization (`lattice init`)

### 1. Gather Information

Ask the user for:
- **Organization name** (e.g. "Acme Labs")
- **Target directory** — where to create the `ORG/` folder (default: current workspace root)
- **Departments** — list of department names (e.g. Research, Engineering, Reliability)
- **First project** (optional) — name + one-line description

Keep it conversational. Don't dump all questions at once.

### 2. Scaffold the ORG Directory

Copy the entire `templates/ORG/` directory to `<target>/ORG/`.

Then customize:

1. **ORG_README.md** — Replace the example org structure in §5 with the user's actual departments
2. **TASKBOARD.md** — Leave the template structure intact (user fills in priorities later)
3. **Departments** — For each department the user listed:
   - Copy `DEPARTMENTS/example-dept/` → `DEPARTMENTS/<dept-name>/`
   - In each copied department, replace `<Department Name>` placeholders in CHARTER.md, RUNBOOK.md, HANDOFF.md with the actual department name
   - Reset STATE.json to `{"lastRun": null, "cursor": null, "notes": "Initial state"}`
4. **Remove** `DEPARTMENTS/example-dept/` after creating real departments (unless user wants to keep it as reference)

### 3. Create the First Project (if requested)

- Copy `PROJECTS/example-project/` → `PROJECTS/<project-name>/`
- Update STATUS.md with the project name
- Update DECISIONS.md header
- Configure PIPELINE_STATE.json (see "Configure Pipeline State" below)
- Remove `PROJECTS/example-project/` after creating the real project

### 4. Configure Pipeline State

Read `templates/ORG/PROJECTS/pipeline-framework/templates/PIPELINE_STATE.template.json` as the reference.

Ask the user:
- **Which agents** will run each phase? (agentId per role — or a single agent for all)
- **Which models** for each phase? (or a default model)
- **Escalation chain** — list of models from cheapest to strongest (e.g. `["gflash", "gpro", "sonnet"]`)
- **Peer consult models** — which models to consult in parallel when stuck
- **Synthesizer/triage model** — typically the strongest available model
- **Notification channel** (optional) — where to send pipeline status updates

Fill in the project's `PIPELINE_STATE.json` with these values, replacing all `<placeholder>` tokens.

### 5. Set Up the Orchestrator Cron Job

Read `templates/ORG/PROJECTS/pipeline-framework/templates/ORCHESTRATOR_PROMPT.template.md`.

Create a cron job using the `cron` tool:
- **Schedule**: `every 30 minutes` (adjustable)
- **Session target**: `isolated`
- **Payload kind**: `agentTurn`
- **Model**: the user's chosen orchestrator model
- **Message**: the orchestrator prompt template, with all `<placeholder>` tokens filled in:
  - `<project>` → project name
  - `<org-root>` → absolute path to the ORG directory
  - `<project-root>` → absolute path to the project directory
  - `<repo-root>` → absolute path to the code repository (ask user)
  - Phase prompt paths → absolute paths to the skill's bundled phase prompt templates

Tell the user the cron job ID so they can manage it later.

### 6. Summary

Print a brief summary:
- ORG directory location
- Departments created
- Project(s) created
- Cron job ID and schedule
- Remind them to fill in TASKBOARD.md with initial priorities

---

## Task: Add a New Project (`lattice new-project`)

1. Ask for: project name, one-line description, code repo path
2. Copy `templates/ORG/PROJECTS/example-project/` → `ORG/PROJECTS/<name>/`
3. Customize STATUS.md, DECISIONS.md, PIPELINE_STATE.json (same as step 3-4 above)
4. Optionally create a new orchestrator cron job for this project

---

## Task: Add a New Department (`lattice new-dept`)

1. Ask for: department name, mission (one sentence)
2. Copy `templates/ORG/DEPARTMENTS/example-dept/` → `ORG/DEPARTMENTS/<name>/`
3. Fill in CHARTER.md with the department name and mission
4. Update ORG_README.md §5 to include the new department

---

## Task: Check Organization Status (`lattice status`)

1. Read `ORG/TASKBOARD.md` — summarize active priorities
2. For each project in `ORG/PROJECTS/`:
   - Read `STATUS.md` — current phase and progress
   - Read `PIPELINE_STATE.json` — phase statuses, blockers, run number
3. For each department in `ORG/DEPARTMENTS/`:
   - Read `HANDOFF.md` — current state and blockers
4. Present a concise status report

---

## Pipeline Architecture (for reference)

### 8 Phases
```
Constitute → Research → Specify → Plan+Tasks → Implement → Test → Review → Gap Analysis
```

### 3-Layer Assistance (when a phase gets stuck)
1. **Model Escalation** — retry with progressively stronger models
2. **Peer Consult** — parallel multi-model consultation + synthesis
3. **Auto-Triage** — automated judge decides: RELAX (loosen constraints) / DEFER (next iteration) / BLOCK (wait for human)

### Key Files per Project
```
ORG/PROJECTS/<project>/
├── STATUS.md              # Human-readable status
├── DECISIONS.md           # Key decisions + rationale
├── PIPELINE_STATE.json    # Phase state machine
├── PIPELINE_LOG.jsonl     # Append-only history
├── pipeline/              # Current run artifacts
└── pipeline_archive/      # Historical runs
```
