---
name: LaTeX
description: Write LaTeX documents with correct syntax, packages, and compilation workflow.
metadata: {"clawdbot":{"emoji":"📐","os":["linux","darwin","win32"]}}
---

## Special Characters

- Reserved chars need escape: `\# \$ \% \& \_ \{ \} \textbackslash`
- Tilde as character: `\textasciitilde` not `\~` (that's an accent)
- Caret: `\textasciicircum` not `\^`
- Backslash in text: `\textbackslash` not `\\` (that's line break)

## Quotes & Dashes

- Opening quotes: ``` `` ``` not `"`; closing: `''`—never use straight `"` quotes
- Hyphen `-`, en-dash `--` (ranges: 1--10), em-dash `---` (punctuation)
- Minus in math mode: `$-1$` not `-1` in text

## Math Mode

- Inline: `$...$` or `\(...\)`; display: `\[...\]` or `equation` environment
- Text inside math: `$E = mc^2 \text{ where } m \text{ is mass}$`
- Multiline equations: `align` environment, not multiple `equation`s
- `\left( ... \right)` for auto-sizing delimiters—must be paired

## Spacing

- Command followed by text needs `{}` or `\ `: `\LaTeX{}` or `\LaTeX\ is`
- Non-breaking space: `~` between number and unit: `5~km`
- Force space in math: `\,` thin, `\:` medium, `\;` thick, `\quad` `\qquad`

## Packages

- `\usepackage` order matters—`hyperref` almost always last
- `inputenc` + `fontenc` for UTF-8: `\usepackage[utf8]{inputenc}` `\usepackage[T1]{fontenc}`
- `graphicx` for images, `booktabs` for professional tables, `amsmath` for advanced math
- `microtype` for better typography—load early, subtle but significant improvement

## Floats (Figures & Tables)

- `[htbp]` suggests placement: here, top, bottom, page—not commands
- LaTeX may move floats far from source—use `[H]` from `float` package to force
- Always use `\centering` inside float, not `center` environment
- Caption before `\label`—label references the last numbered element

## References

- Compile twice to resolve `\ref` and `\pageref`—first pass collects, second uses
- `\label` immediately after `\caption` or inside environment being labeled
- For bibliography: latex → bibtex → latex → latex (4 passes)
- `hyperref` makes refs clickable—but can break with some packages

## Tables

- `tabular` for inline, `table` float for numbered with caption
- Use `booktabs`: `\toprule`, `\midrule`, `\bottomrule`—no vertical lines
- `@{}` removes padding: `\begin{tabular}{@{}lll@{}}`
- Multicolumn: `\multicolumn{2}{c}{Header}`; multirow needs `multirow` package

## Images

- Path relative to main file or set with `\graphicspath{{./images/}}`
- Prefer PDF/EPS for pdflatex/latex; PNG/JPG for photos
- `\includegraphics[width=0.8\textwidth]{file}`—no extension often better

## Common Errors

- Overfull hbox: line too long—rephrase, add `\-` hyphenation hints, or allow `\sloppy`
- Missing `$`: math command used in text mode
- Undefined control sequence: typo or missing package
- `\include` adds page break, `\input` doesn't—use `\input` for fragments

## Document Structure

- Preamble before `\begin{document}`—all `\usepackage` and settings
- `\maketitle` after `\begin{document}` if using `\title`, `\author`, `\date`
- `article` for short docs, `report` for chapters without parts, `book` for full books
