#!/usr/bin/env bash
set -euo pipefail

# Usage:
#   lastpass.sh get "<name>" "<field>"
# field: password|username|notes|raw
cmd="${1:-}"
name="${2:-}"
field="${3:-password}"

if [[ "$cmd" != "get" || -z "$name" ]]; then
  echo "Usage: lastpass.sh get \"<name>\" [password|username|notes|raw]" >&2
  exit 1
fi

case "$field" in
  password)
    lpass show --password "$name"
    ;;
  username)
    lpass show --username "$name"
    ;;
  notes)
    lpass show --notes "$name"
    ;;
  raw)
    lpass show "$name"
    ;;
  *)
    echo "Unknown field: $field" >&2
    exit 1
    ;;
esac
