---
name: lastpass-cli
description: Securely fetch credentials from LastPass vault via lpass CLI.
version: 0.1.0
tags: [security, passwords, lastpass]
---

# LastPass CLI Skill

## Description

This skill lets the agent retrieve credentials from the local LastPass vault using the `lpass` CLI. It is intended for fetching secrets into automation flows, not for interactive vault management.

## Tools

- `lastpass_get_secret`: Retrieve a specific field (password, username, notes) for a named LastPass entry using the local `lpass` CLI.

## When to Use

- When you need a password, username, or notes for a specific account that is stored in LastPass.
- When orchestrating deployments, API calls, or logins that require secrets.

## Tool: lastpass_get_secret

### Invocation

Call this tool with a JSON object:

```json
{
  "name": "Exact LastPass entry name",
  "field": "password | username | notes | raw"
}
