# v2.1 Launch Copy (DRAFT — do not publish)

## Context

Bird CLI (@steipete/bird) has been deprecated on npm and the GitHub repo deleted. steipete was asked to take it down (likely by X). Nobody has forked and republished it. Our v2.1 vendors a search-only subset of Bird v0.8.0 (MIT licensed) so users don't need any external tools.

YouTube transcripts are the second headline feature. Inspired by Peter Steinberger's yt-dlp + summarize toolchain. We use yt-dlp directly (no summarize dependency) — search YouTube, grab transcripts, feed them into the synthesis. Zero API keys, zero cost.

---

## README: "New in V2.1" blurb

**New in V2.1 — two headline features:**

- **YouTube transcripts as a 4th source.** When yt-dlp is installed, /last30days automatically searches YouTube, grabs view counts, and extracts auto-generated transcripts from the top videos. A 20-minute review contains 10x the signal of a tweet — now the skill reads it. Inspired by @steipete's yt-dlp + summarize toolchain.
- **X search is fully bundled.** No external `bird` CLI or xAI API key needed. Just Node.js 22+ and your browser cookies. Uses a vendored subset of Bird's Twitter GraphQL client (MIT licensed, originally by @steipete).

---

## README: X Search Authentication section

### X Search Authentication

X search reads your existing browser cookies — no API keys or login commands needed.

**Safari (recommended on Mac):** Just be logged into x.com. No setup needed.

**Chrome:** Works, but macOS will prompt you to allow Keychain access the first time. Click "Allow" (or "Always Allow" to stop future prompts).

**Firefox:** Just be logged into x.com. No setup needed.

**Manual fallback:** If cookie auto-detection doesn't work, set these env vars (grab them from your browser's dev tools → Application → Cookies → x.com):
```bash
export AUTH_TOKEN=your_auth_token
export CT0=your_ct0_token
```

**Verify it's working:**
```bash
node ~/.claude/skills/last30days/scripts/lib/vendor/bird-search/bird-search.mjs --whoami
```

---

## README: Install block env line

```
XAI_API_KEY=xai-...       # optional — cookie auth is default for X search
```

---

## SKILL.md: Stats line

```
├─ 🔵 X: {N} posts │ {N} likes │ {N} reposts
```

---

## GitHub issue #19 response (post AFTER publishing)

> Thanks for reporting this. Bird CLI was deprecated and the GitHub repo was deleted — steipete was asked to take it down.
>
> The good news: you don't need Bird anymore. v2.1 (just shipped) bundles X search directly — no external CLI, no `npm install`, no brew. Just Node.js 22+ and your browser cookies.
>
> It also adds **YouTube as a 4th source** — when yt-dlp is installed, the skill automatically searches YouTube and extracts transcripts from the top videos. A 20-minute tutorial has 10x the signal of a tweet, and now the synthesis engine reads it.
>
> If you're on a Mac, Safari is the easiest path for X — just be logged into x.com. Chrome works too but macOS will prompt for Keychain access the first time.
>
> If cookie auto-detection doesn't work, you can set `AUTH_TOKEN` and `CT0` env vars manually (grab from browser dev tools → Application → Cookies → x.com).
>
> The xAI API (`XAI_API_KEY`) also still works as a fallback.

---

## X/Social launch post

### Short (280 chars)

/last30days v2.1 is out 🚀

Two new features:
→ YouTube transcripts as a 4th source (yt-dlp)
→ X search fully bundled (no bird CLI needed)

Research any topic across Reddit, X, YouTube & web in one command.

h/t @steipete for the inspiration on both.

github.com/mvanhorn/last30days-skill

### Thread version (post 1)

/last30days v2.1 just shipped — two headline features:

1️⃣ YouTube transcripts as a 4th source
When yt-dlp is installed, the skill searches YouTube, grabs view counts, and extracts auto-generated transcripts from top videos. A 20-min review has 10x the signal of a tweet — now the synthesis reads it.

### Thread version (post 2)

2️⃣ X search is fully bundled
Bird CLI was deprecated. Instead of requiring an external tool, v2.1 vendors a search-only subset. Just be logged into x.com in your browser. No npm install, no API keys.

Both features inspired by @steipete's tooling.

### Thread version (post 3)

YouTube goes through the same scoring pipeline as Reddit and X — relevance, recency, engagement. Transcripts get truncated to ~500 words per video and fed into the synthesis engine alongside social posts.

Zero API keys for YouTube. Zero cost. Just `brew install yt-dlp`.

### Thread version (post 4)

Try it:
```
/last30days [any topic]
```

Reddit + X + YouTube + Web. Four sources, one command, copy-paste prompts.

github.com/mvanhorn/last30days-skill
