# Slide Structure & Hook Writing

## The 6-Slide Formula (EXACTLY 6 — TikTok minimum)

| Slide | Purpose | Text Style |
|-------|---------|------------|
| 1 | HOOK — stop the scroll | Relatable problem, full hook text |
| 2 | PROBLEM — amplify pain | Build tension |
| 3 | DISCOVERY — turning point | "So I tried this" / "Then I found..." |
| 4 | TRANSFORMATION 1 — first result | Reaction: "Wait... this actually looks good?" |
| 5 | TRANSFORMATION 2 — escalate | Reaction: "Okay I'm obsessed" |
| 6 | CTA — call to action | App name + "link in bio" |

**SAME subject, SAME angle, DIFFERENT styles across all 6 slides.**

## Proven Hook Formulas

### Tier 1: Person + Conflict → AI → Changed Mind (BEST)
- "I showed my mum what AI thinks our [room] should look like" (161K views)
- "My landlord said I can't change anything so I showed her this" (124K views)
- "My boyfriend said our flat looks like [insult] so I showed him"
- "My flatmate wouldn't believe this is the same room"

### Tier 2: Relatable Budget Pain
- "POV: You have good taste but no budget"
- "IKEA budget, designer taste"
- "I can't afford an interior designer so I tried AI"

### Tier 3: Curiosity / Self-Discovery
- "I've always wondered what I'd look like with..."
- "I had to see if it would even suit me"
- "Everyone's getting [thing] but would it suit MY face?"

### What DOESN'T Work
- Self-focused complaints without conflict: "My flat is ugly" (low views)
- Fear/insecurity hooks for beauty: "Am I ugly without..." (people scroll past)
- Price comparison without story: "$500 vs $5000" (needs character)

## Hook Adaptation by Category

### Home/Interior Apps
Replace [room] and [style] with user's app focus:
- "My [person] said our [room] looks like [insult]"
- "I showed my [person] what AI thinks our [room] should look like"
- "[Person] wouldn't let me redecorate until I showed them this"

### Beauty Apps
- "My [person] got [treatment] and now I can't stop thinking about it"
- "I've always had [feature] and never known what [change] would look like"
- "Everyone keeps asking if I got [treatment] done"

### Fitness Apps
- "My trainer said I'd never look like [goal]"
- "I showed my gym buddy what AI thinks I could look like in 6 months"

### Productivity Apps
- "My boss said my workflow is a mess so I showed her this"
- "I was spending 4 hours on [task] until I found this"

## Image Prompt Template

Write ONE base description, reuse across all 6 slides:

```
[For AI image gen providers:]
iPhone photo of a [CONTEXT]. [DETAILED DESCRIPTION OF SUBJECT].
Shot from [CAMERA POSITION]. [SPECIFIC ARCHITECTURAL/PHYSICAL DETAILS].
Natural phone camera quality, realistic lighting. Portrait orientation.

[SLIDE-SPECIFIC STYLE CHANGES ONLY]
```

Adapt prompt style to your image gen provider — the key principles (same subject, same angle, different styles) apply regardless of which tool generates the images.

### What to Lock (same across all 6):
- Subject dimensions/features
- Camera angle/position
- Lighting direction
- Background elements
- Physical structure (windows, doors, body proportions)

### What Changes Per Slide (ONLY):
- Style/aesthetic
- Colors/textures
- Decor/accessories
- Expression (for faces)

## Caption Template

```
[hook matching slide 1] 😭 [2-3 sentences of relatable struggle].
So I found this app called [APP NAME] that [what it does in one sentence] -
you just [simple action] and it [result]. I tried [style 1] and [style 2]
and honestly?? [emotional reaction]. [funny/relatable closer] 
#[niche1] #[niche2] #[niche3] #[niche4] #fyp
```

Keep it conversational. Tell a mini-story. Mention the app naturally, not salesy.

## Music (CRITICAL — Do NOT Skip)

Posts are published as **drafts (SELF_ONLY)** to TikTok inbox. Before publishing:

1. Open the draft in TikTok
2. Tap "Add sound" and browse trending sounds in your niche
3. Pick something popular — trending audio gets algorithmic boost
4. Preview the slideshow with the sound, then publish

**Why drafts?** TikTok's algorithm massively favours posts with trending sounds. Silent slideshows look like ads and get buried. Adding the right music is the difference between 1K and 100K views. An API can't pick what's trending right now — you need to browse the sound library.

This takes 30 seconds per post. Don't skip it.
