#!/usr/bin/env node
/**
 * Delete a task
 * 
 * Usage:
 *   node delete-task.mjs --task-id "35fc5310-a1b1-49c7-be75-be631d3079ee"
 */

import { parseArgs } from 'util';
import { deleteTask } from '../lib/task.mjs';

const { values } = parseArgs({
  options: {
    'task-id': { type: 'string' },
    help: { type: 'boolean', short: 'h' }
  }
});

if (values.help) {
  console.log(`
Delete a Lark task

Options:
  --task-id    Task GUID to delete (required)
  -h, --help   Show this help

Examples:
  node delete-task.mjs --task-id "35fc5310-a1b1-49c7-be75-be631d3079ee"
`);
  process.exit(0);
}

if (!values['task-id']) {
  console.error('Error: --task-id is required');
  process.exit(1);
}

async function main() {
  try {
    console.log(`Deleting task: ${values['task-id']}`);
    
    await deleteTask(values['task-id']);
    
    console.log('✅ Task deleted successfully!');
    
  } catch (error) {
    console.error('❌ Failed to delete task:', error.message);
    if (error.larkResponse) {
      console.error('Lark response:', JSON.stringify(error.larkResponse, null, 2));
    }
    process.exit(1);
  }
}

main();
