# Landing Page Templates

## SaaS Product Page

### Structure
```
Hero (product demo + free trial CTA)
↓
Problem (pain they're trying to solve)
↓
Solution (3-step "how it works")
↓
Features/Benefits (3-4 key differentiators)
↓
Integrations (if applicable)
↓
Social Proof (testimonials + logos)
↓
Pricing (optional - or link to pricing page)
↓
CTA (free trial + demo option)
↓
FAQ (3-5 common questions)
```

### Hero Formula
```
[Product] helps [audience] [achieve outcome]
[Subheadline with mechanism]
[Start free trial] [Watch demo]
[Product screenshot or video]
```

### Example
```
Ship code without breaking things
AI-powered code review that catches bugs before your users do.
[Start free trial] [See how it works]
[Dashboard screenshot with key metric highlighted]
```

---

## Lead Generation Page

### Structure
```
Hero (value prop + form or CTA)
↓
What's Inside (bullet points of value)
↓
Social Proof (quick wins)
↓
About Author/Company (credibility)
↓
CTA (form with minimal fields)
```

### Hero Formula
```
Get [specific resource]
[What they'll learn/get in 2-3 bullets]
[Form: Name, Email] [Get free access]
```

### Form Rules
- Maximum 3 fields for cold traffic
- Name + Email minimum
- Consider email-only for max conversion
- Add phone only if sales will call

### Example
```
The Complete Guide to B2B Sales Emails

Inside this free guide:
• 12 proven email templates
• Subject lines that get 40%+ open rates  
• Follow-up sequence that closes deals

[Your email] [Send me the guide]
```

---

## Event/Webinar Page

### Structure
```
Hero (event name + date + register CTA)
↓
What You'll Learn (3-5 bullets)
↓
Speakers (headshots + credentials)
↓
Agenda/Outline (what happens when)
↓
Social Proof (past attendees, ratings)
↓
CTA (register + scarcity)
```

### Hero Formula
```
[Event name]
[Date] | [Time + timezone] | [Live/Recorded]
Learn how to [main outcome]
[Register now - X spots left]
```

### Urgency Elements
- "Limited to 100 attendees"
- Countdown timer to event
- "X people registered"
- "Recording available to registrants only"

---

## eCommerce Product Page

### Structure
```
Hero (product image + price + buy CTA)
↓
Key Benefits (why this product)
↓
Features/Specs (details)
↓
Social Proof (reviews + ratings)
↓
FAQ (shipping, returns, sizing)
↓
Related Products (cross-sell)
```

### Hero Elements
- High-quality product images (multiple angles)
- Price prominently displayed
- "Add to cart" above fold
- Stock status / scarcity
- Trust badges (secure checkout, guarantees)

### Review Display
- Star rating + count visible in hero
- Highlight 2-3 specific reviews
- Show mix of ratings (all 5-star looks fake)

---

## Coming Soon / Waitlist Page

### Structure
```
Hero (what's coming + email capture)
↓
Teaser (what it does, without full reveal)
↓
Timeline (when to expect it)
↓
Social (follow for updates)
```

### Hero Formula
```
[Product name] is coming
[One-sentence teaser of the main benefit]
Get early access when we launch
[Your email] [Join waitlist]
[X people already signed up]
```

### Engagement After Signup
- Immediate confirmation email
- Share for earlier access (referral program)
- Progress updates

---

## Agency/Services Page

### Structure
```
Hero (what you do + who for + CTA)
↓
Services (what you offer)
↓
Process (how you work)
↓
Case Studies (results you've delivered)
↓
About/Team (who they'll work with)
↓
CTA (book call / get quote)
```

### Hero Formula
```
[Service] for [audience]
We help [type of company] [achieve outcome]
[Book a call] [See our work]
```

### Trust Builders
- Client logos (recognizable names)
- Case studies with specific results
- Team photos and bios
- Industry certifications

---

## Comparison Page (vs Competitor)

### Structure
```
Hero (why you're better)
↓
Comparison Table (feature by feature)
↓
Where You Win (2-3 key differentiators)
↓
Migration/Switching (how easy it is)
↓
Social Proof (switchers testimonials)
↓
CTA (try us + migration help)
```

### Comparison Table Rules
- Be honest (admit where competitor wins)
- Lead with features where you win
- Use checkmarks and X marks
- Link to sources for competitor claims

### Tone
- Professional, not aggressive
- Acknowledge competitor strengths
- Focus on fit, not "we're better"
