# Landing Page Sections

## Hero Section

The hero has 3 seconds to hook. Every element must earn its place.

### Required Elements
- **Headline:** Clear outcome, no jargon. 6-12 words.
- **Subheadline:** How you deliver. 15-25 words max.
- **Primary CTA:** One button, action verb ("Start free trial", "Get started")
- **Visual:** Product screenshot, demo, or outcome image

### Optional Elements
- Secondary CTA (lower commitment: "See how it works")
- Social proof snippet ("Trusted by 10,000+ teams")
- Micro-copy under CTA ("No credit card required")

### Anti-patterns
- Logo sliders in hero (wasted prime real estate)
- Autoplay video (annoying, slows load)
- "Welcome to our website" headlines (says nothing)

---

## Problem Section

Agitate the pain they're trying to solve. Make them feel understood.

### Structure
1. **Name the problem** they're facing
2. **Show consequences** of not solving it
3. **Empathize** (we've been there / we talked to 100 people like you)

### Techniques
- List specific frustrations (bullet points)
- Use their exact words (from research/reviews)
- Before/after contrast

### Length
Short. 50-150 words. Don't dwell—move to solution.

---

## Solution Section

Your product as the answer. Bridge from problem to how you fix it.

### Structure
1. Introduce your solution (one sentence)
2. Show how it works (3 steps or features)
3. Visual of the product in action

### The 3-Step Pattern
Works for almost anything:
1. Sign up / Install / Connect
2. [Core action of your product]
3. Get [desired outcome]

---

## Benefits Section

Features tell, benefits sell. Translate what it does → what they get.

### Format Options
- **Icon + title + description** (3-4 items)
- **Two-column with visuals** (alternating)
- **Comparison table** (vs alternatives or vs without)

### Feature → Benefit Translation
| Feature | Benefit |
|---------|---------|
| AI-powered | Get results in seconds, not hours |
| 256-bit encryption | Your data stays private |
| Mobile app | Access from anywhere |

### Rules
- Lead with benefit, mention feature as support
- Quantify when possible ("Save 4 hours/week")
- Address objections implicitly

---

## Social Proof Section

Prove others trust you. Types by strength:

| Type | Strength | When to use |
|------|----------|-------------|
| Named testimonials with photo | Strongest | B2B, high-ticket |
| Video testimonials | Very strong | Any |
| Star ratings + review count | Strong | Consumer products |
| Logo wall | Medium | B2B |
| Numbers ("10,000 users") | Medium | Volume play |
| Press mentions | Situational | If recognizable outlets |

### Placement
- Snippet in hero (one strong line)
- Dedicated section after benefits
- Near CTA (reinforcement)

### Rules
- Real names > "John D."
- Specific results > generic praise
- 3-5 testimonials max (quality over quantity)

---

## CTA Section

The close. Remove all friction, reinforce value.

### Structure
1. Restate value prop (slightly different angle)
2. Handle final objection
3. CTA button (same as hero)
4. Risk reversal (guarantee, free trial, cancel anytime)

### CTA Button Copy
| Weak | Strong |
|------|--------|
| Submit | Get my free guide |
| Sign up | Start saving time |
| Learn more | See how it works |

### Micro-copy
Small text under button that reduces friction:
- "No credit card required"
- "Setup takes 2 minutes"
- "Cancel anytime"
- "Join 5,000+ marketers"

---

## Footer

Minimal. Don't distract from CTA.

- Links: Privacy, Terms, Contact
- Secondary nav if needed
- © and company info
- NO competing CTAs, NO newsletter signup
