# Landing Page Copywriting

## Headline Formulas

### Outcome-First
```
[Get/Achieve] [desired outcome] [without common pain]
```
- "Get more leads without cold calling"
- "Build muscle without living at the gym"

### Transformation
```
[From current state] to [desired state] [in timeframe]
```
- "From idea to launched product in one weekend"
- "Zero to 10K followers in 90 days"

### Specific Number
```
[Number] [thing] to [achieve outcome]
```
- "The 3-step system to double your revenue"
- "7 templates that convert at 40%+"

### Question Hook
```
[Question that identifies problem]?
```
- "Tired of spreadsheets that break?"
- "Still writing code that nobody reads?"

### Direct Benefit
```
[Verb] [their goal]
```
- "Ship faster"
- "Close more deals"
- "Write copy that sells"

---

## Subheadline Formulas

The subheadline explains HOW after the headline says WHAT.

### Method
```
[Product type] that helps [audience] [achieve headline promise]
```
- "A scheduling tool that helps freelancers get paid on time"

### Mechanism
```
Using [method/technology], [product] [delivers benefit]
```
- "Using AI, we analyze your code and catch bugs before production"

### Contrast
```
[Get benefit]. Without [common sacrifice].
```
- "Automate your workflow. Without learning to code."

---

## CTA Copy

### Button Text

**Structure:** [Action verb] + [What they get]

| Good | Bad |
|------|-----|
| Start my free trial | Submit |
| Get the template | Download |
| Book a demo | Contact us |
| See pricing | Learn more |

### Reinforcement Copy (Below Button)

Address the objection they're thinking:
- "Free for 14 days. No credit card needed."
- "Setup takes under 2 minutes."
- "Cancel anytime. No questions asked."
- "Join 5,000+ marketers already using [Product]"

---

## Voice & Tone

### Rules

1. **Second person.** "You" and "your", not "we" and "our"
2. **Active voice.** "Analyze your data" not "Your data is analyzed"
3. **Present tense.** "Get results" not "You will get results"
4. **Specific > abstract.** Numbers, timeframes, tangible outcomes
5. **Short sentences.** Under 20 words. Ideally under 12.

### Before/After Examples

| Before | After |
|--------|-------|
| Our software solution enables organizations to optimize their workflow processes | Finish work in half the time |
| We have helped numerous clients achieve their business objectives | 500+ teams ship faster with us |
| Users benefit from our intuitive interface | Start using it in minutes, no training needed |

---

## Objection Handling

Identify objections and answer them in copy:

| Objection | Copy response |
|-----------|---------------|
| Too expensive | "Pays for itself in week one" |
| Too complex | "Setup in 5 minutes" |
| Not sure it works | "Join 10,000 happy users" or guarantee |
| Not ready to commit | "Start free, upgrade when ready" |
| Need approval | "Teams love it—share with your manager" |

### Where to Place

- Hero: Handle biggest objection in subheadline
- Benefits: Address 2-3 objections indirectly
- CTA section: Risk reversal (guarantee, free trial)
- FAQ: Catch remaining objections explicitly

---

## Social Proof Copy

### Testimonial Format
```
"[Specific result or transformation]. [Optional: how it happened]."
— [Full name], [Title/Company] or [Relatable identifier]
```

**Good:**
> "We cut onboarding from 3 weeks to 2 days. The templates saved us."
> — Sarah Chen, Head of HR at Acme Corp

**Bad:**
> "Great product, highly recommend!"
> — John D.

### Stats Format
```
[Big number]+ [thing]
```
- "50,000+ businesses trust us"
- "10M+ emails sent daily"
- "4.9★ from 2,000+ reviews"

---

## Page-Type Copy Angles

### SaaS
- Lead with productivity/efficiency gain
- Demo or video of product in hero
- Free trial as primary CTA

### eCommerce
- Lead with product + offer
- Price and scarcity visible early
- Buy now, not "learn more"

### Lead Generation
- Lead with value of the resource
- Minimize form fields
- "Get [resource]" not "Submit"

### Event/Webinar
- Date, time, speakers prominent
- FOMO elements (limited seats)
- "Register" or "Save my spot"
