---
name: "Landing Page"
description: "Build high-converting landing pages with proven structure, persuasive copy, and conversion optimization."
---

## Triggers

Activate on: "create landing page", "write landing copy", "improve conversion", "page not converting", "hero section help".

## Core Structure

Every landing page follows the same spine:

| Section | Purpose | Height |
|---------|---------|--------|
| Hero | Hook + CTA | 100vh |
| Problem | Agitate pain | Short |
| Solution | Your answer | Medium |
| Benefits | What they get | Medium |
| Social proof | Trust signals | Variable |
| CTA | Convert | Compact |

See `sections.md` for detailed requirements per section.

## Hero Formula

```
[Headline: Outcome they want]
[Subhead: How you deliver it]
[CTA button] [Secondary action]
[Visual: Product/result]
```

**Headline test:** Would they screenshot and send to a friend?

## Copy Rules

- **You > We.** Talk about them, not yourself.
- **Specific > Vague.** "Save 4 hours/week" beats "Save time"
- **One CTA.** Everything else is distraction.
- **Objection handling.** Answer "why not?" before they ask.

See `copy.md` for formulas and examples by page type.

## Conversion Checklist

Before launch:

- [ ] CTA visible without scrolling
- [ ] Load time <3s
- [ ] Mobile-first (60%+ traffic)
- [ ] Single goal, single action
- [ ] Social proof near CTA
- [ ] Friction removed (minimal form fields)

See `optimization.md` for A/B testing and analytics setup.

## Red Flags

Stop and fix:
- Multiple competing CTAs → Pick one
- Features without benefits → Translate to outcomes
- No social proof → Add testimonials, logos, numbers
- Wall of text → Break into scannable sections
- Generic stock photos → Use product/real images

## By Page Type

Different goals need different emphasis:

| Type | Lead with | CTA |
|------|-----------|-----|
| SaaS | Demo/trial | Start free |
| eCommerce | Product + offer | Buy now |
| Lead gen | Value prop + form | Get [resource] |
| Event | Date + speakers | Register |

See `templates.md` for page-type specific structures.
