---
name: landing-page-roast
description: Audit a landing page for clarity, trust, offer strength, and conversion friction; return prioritized fixes and copy rewrites.
---

# Landing Page Roast

Use this skill to diagnose why a page is not converting and produce concrete fixes.

## Inputs
- Page URL or pasted page copy
- Target audience
- Primary conversion action
- Price point / offer details

## Audit dimensions
1. **Clarity above the fold**
   - Is the outcome obvious in 5 seconds?
2. **Audience fit**
   - Is it clear who this is for (and not for)?
3. **Offer strength**
   - Is the promise specific, measurable, believable?
4. **Trust layer**
   - social proof, proof artifacts, risk reversal
5. **Friction**
   - too many fields, weak CTA hierarchy, distractions
6. **Objection handling**
   - price/time/risk doubts addressed?

## Output
- Overall score (0–10)
- Top 5 blockers (ranked by impact)
- Quick wins (<30 min changes)
- Structural rewrites (headline, subhead, CTA block)
- 3 CTA variants
- Optional A/B test matrix (what to test first)

## Rewrite standards
- Plain language
- Specific outcomes over buzzwords
- Fewer claims, more proof
- Keep tone consistent with target audience

## Example request
"Roast this AI automation service page for SMB owners and rewrite the hero + first CTA section to increase booked calls."