---
name: landing-page-converter
description: Build high-converting landing pages and product sales pages using proven 10-section conversion frameworks. Includes Hero → Social Proof → Benefits → CTA flow for both lead capture and e-commerce pages.
metadata:
  openclaw:
    requires:
      bins: []
      env: []
  tags:
    - landing-page
    - sales-page
    - conversion
    - copywriting
    - marketing
    - ecommerce
    - funnel
  keywords:
    - "landing page template"
    - "product page"
    - "high converting page"
    - "sales page generator"
    - "conversion framework"
    - "ecommerce template"
    - "lead capture page"
  examples:
    - "Create a landing page for a webinar signup"
    - "Build a product sales page for Shopify"
    - "Design a lead magnet capture page"
    - "Generate a high-conversion squeeze page"
---

# Landing Page Converter Skill

Convert any offer into a high-converting landing page or product page using the proven templates from the Jovan Industries conversion framework.

## The Two Templates

### 1. LANDING PAGE Template
Used for: Lead magnets, email captures, webinar signups, free trials

```
┌─────────────────────────────────────────────────────────┐
│                     HERO SECTION                         │
│  ┌─────────────────────────────────────────────────┐   │
│  │ Main Headline (1 line, punchy, benefit-driven)   │   │
│  └─────────────────────────────────────────────────┘   │
│  ┌─────────────────────────────────────────────────┐   │
│  │ Sub-headline (explain the main benefit)         │   │
│  └─────────────────────────────────────────────────┘   │
│  ┌─────────────────────────────────────────────────┐   │
│  │ PRIMARY CTA BUTTON (big, contrasting color)     │   │
│  └─────────────────────────────────────────────────┘   │
│              [Product/hero image]                       │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                   SOCIAL PROOF BAR                      │
│    "TRUSTED BY 10,000+ [理想Customers]"                │
│         [Logo] [Logo] [Logo] [Logo] [Logo]            │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                   PROBLEM SECTION                       │
│         "Struggling with [PAIN POINT]?"                │
│    Describe the problem in customer's words            │
│         [Image: person looking frustrated]             │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                   AGITATION SECTION                    │
│    "Here's why [PAIN POINT] keeps getting worse..."    │
│    Make the problem feel more urgent/painful           │
│         [Image: problem escalation visuals]            │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                   SOLUTION SECTION                      │
│  ┌─────────────────────────────────────────────────┐   │
│  │  "Introducing [PRODUCT NAME]"                   │   │
│  │                                                 │   │
│  │  [Product image - large, clear]                 │   │
│  └─────────────────────────────────────────────────┘   │
│    List 3-5 key benefits (not features)                │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                   MECHANICS SECTION                    │
│    "How it works - 3 simple steps"                     │
│    Step 1 → Step 2 → Step 3 (with icons/images)       │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                 TESTIMONIALS SECTION                   │
│    [★ 5.0] "Changed my life..."                       │
│    - Name, Title                                       │
│    [★ 5.0] "Best investment..."                       │
│    - Name, Title                                       │
│    [★ 5.0] "Finally works..."                         │
│    - Name, Title                                       │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                    OFFER SECTION                       │
│    "Here's what you get:"                             │
│    ✓ [Benefit 1]                                      │
│    ✓ [Benefit 2]                                      │
│    ✓ [Benefit 3]                                      │
│    + [Bonuses]                                        │
│         [PRIMARY CTA BUTTON]                          │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                   RISK REVERSAL                        │
│    "Your protection:"                                  │
│    ✓ [Risk Reversal 1 - usually money-back]           │
│    ✓ [Risk Reversal 2]                                │
│    ✓ [Risk Reversal 3]                                │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                FINAL CTA SECTION                       │
│    "Start [DESIRED ACTION] Today"                     │
│    [Countdown timer if scarcity]                       │
│         [PRIMARY CTA BUTTON]                          │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│                       FOOTER                           │
│    [Links] [Privacy] [Terms] [Contact]                │
└─────────────────────────────────────────────────────────┘
```

### 2. PRODUCT PAGE Template
Used for: Direct product sales, e-commerce, digital products

Build product pages EXCLUSIVELY using this 10-section flow from top to bottom:

```
┌─────────────────────────────────────────────────────────┐
│ 1. NAV (Top Menu)                                      │
│  [Logo]  [Shop] [About] [Blog] [Contact]      [Cart 🛒] │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│ 2. BUYBOX (Hero Product Module)                        │
│  ┌─────────────────────┬───────────────────────────┐  │
│  │                     │  ★★★★★ (128 reviews)     │  │
│  │   [Product Image]   │  PRODUCT NAME              │  │
│  │                     │  $XX.XX                    │  │
│  │                     │  [Color: ▼] [Size: ▼]     │  │
│  │                     │  [ADD TO CART]            │  │
│  │                     │  [Buy Now]                │  │
│  └─────────────────────┴───────────────────────────┘  │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│ 3. SOCIAL PROOF #1 (Testimonials Row 1)               │
│  "⭐⭐⭐⭐⭐ Loved by 10,000+ customers"                 │
│  ┌─────────────┐ ┌─────────────┐ ┌─────────────┐     │
│  │ "Quote..."  │ │ "Quote..."  │ │ "Quote..."  │     │
│  │ - Name      │ │ - Name      │ │ - Name      │     │
│  │ [avatar]    │ │ [avatar]    │ │ [avatar]    │     │
│  └─────────────┘ └─────────────┘ └─────────────┘     │
│        ↗              ↗              ↗               │
│  [FB] [TW] [IG] [PI]  (share icons above)            │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│ 4. SOCIAL PROOF #2 (More Proof / UGC)                 │
│  "Here's what real customers are sharing..."          │
│  [Customer photo 1] [Customer photo 2]               │
│  [Customer photo 3] [Customer photo 4]               │
│  "Posted on Instagram/Twitter..."                      │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│ 5. BENEFITS (Icon-Bulleted List)                      │
│  ┌─────────────────────────────────────────────────┐   │
│  │  [icon] BENEFIT 1                              │   │
│  │        Short description of this benefit       │   │
│  ├─────────────────────────────────────────────────┤   │
│  │  [icon] BENEFIT 2                              │   │
│  │        Short description of this benefit       │   │
│  ├─────────────────────────────────────────────────┤   │
│  │  [icon] BENEFIT 3                              │   │
│  │        Short description of this benefit       │   │
│  ├─────────────────────────────────────────────────┤   │
│  │  [icon] BENEFIT 4                              │   │
│  │        Short description of this benefit       │   │
│  └─────────────────────────────────────────────────┘   │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│ 6. INGREDIENTS/MATERIALS (Specs Grid)                │
│  "What's Inside / Product Specifications"             │
│  ┌─────────────┬─────────────┬─────────────┐          │
│  │  [img]      │  [img]      │  [img]      │          │
│  │  Label 1   │  Label 2   │  Label 3   │          │
│  │  ✓ Check   │  ✓ Check   │  ✓ Check   │          │
│  └─────────────┴─────────────┴─────────────┘          │
│  [Full ingredient list + detailed specs]              │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│ 7. SOCIAL PROOF #3 (Video / Case Studies)             │
│  [▶ Play Video]  "See how it works"                   │
│  ┌─────────────────────────────────────────────────┐   │
│  │  "My Results After 30 Days"                    │   │
│  │  [Before] → [After]                           │   │
│  │  - Name, Location                             │   │
│  └─────────────────────────────────────────────────┘   │
│  [Influencer quote + handle]                           │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│ 8. COMPARISON (Table)                                 │
│                 ┌───────────┬───────────┬───────────┐  │
│                 │  OUR PRODUCT │ Competitor A │ Competitor B │
│  ├──────────────┼───────────┼───────────┼───────────┤  │
│  │ Feature 1    │     ✓     │     ✓     │     ✗     │
│  ├──────────────┼───────────┼───────────┼───────────┤  │
│  │ Feature 2    │     ✓     │     ✗     │     ✓     │
│  ├──────────────┼───────────┼───────────┼───────────┤  │
│  │ Price        │   $XX     │   $XX     │   $XX     │
│  ├──────────────┼───────────┼───────────┼───────────┤  │
│  │ Quality      │  ★★★★★   │   ★★★     │   ★★      │
│  └──────────────┴───────────┴───────────┴───────────┘  │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│ 9. FAQ (Accordion)                                     │
│  ▼ Question 1?                                         │
│    Answer text here...                                 │
│  ▶ Question 2?                                         │
│  ▶ Question 3?                                        │
│  ▶ Question 4?                                        │
└─────────────────────────────────────────────────────────┘
                         ↓
┌─────────────────────────────────────────────────────────┐
│ 10. CTA (Final Call-to-Action)                        │
│  ┌─────────────────────────────────────────────────┐   │
│  │  "Ready to experience [BENEFIT]?"               │   │
│  │                                                 │   │
│  │        [★ LARGE ADD TO CART BUTTON ★]          │   │
│  │                                                 │   │
│  │  🛡️ Money-back guarantee  │  🚚 Free shipping   │   │
│  │  🔒 Secure checkout      │  ⚡ Ships today     │   │
│  └─────────────────────────────────────────────────┘   │
│  ──────────────────────────────────────────────────    │
│  [Nav] [Shop] [About] [Contact] [Privacy] [Terms]     │
└─────────────────────────────────────────────────────────┘
```

### Section Breakdown

**1. NAV (Top Menu)**
- Horizontal navigation bar
- Logo on left
- Menu links center (Shop, About, Blog, Contact)
- Cart icon on right with item count badge

**2. BUYBOX (Hero Product Module)**
- Product image on left (large, clear)
- Product name prominently displayed
- Social proof callout ABOVE the product name (star rating + review count)
- Price clearly visible
- Variant selectors (color, size, quantity)
- Primary CTA: "Add to Cart"
- Secondary CTA: "Buy Now"

**3. SOCIAL PROOF #1 (Testimonials Row 1)**
- Trust headline ("Loved by X+ customers")
- 3 testimonial cards in a row
- Each: quote, star rating, customer name, avatar
- Social share icons above the testimonials

**4. SOCIAL PROOF #2 (More Proof / UGC)**
- User-generated content section
- Customer photos in grid layout
- "Posted on Instagram/Twitter" attribution
- More testimonials or social mentions

**5. BENEFITS (Icon-Bulleted List)**
- 4-6 benefits with icons
- Short description under each bullet
- Icons should match brand aesthetic

**6. INGREDIENTS/MATERIALS (Specs Grid)**
- Visual grid of key ingredients/materials
- Images for each ingredient
- Labels/checkmarks indicating what's included
- Full ingredient list or specs table below

**7. SOCIAL PROOF #3 (Video / Case Studies)**
- Video modal trigger button ("Watch how it works")
- Before/after case study with customer name + location
- Influencer quote with social handle

**8. COMPARISON (Table)**
- Product vs alternatives comparison
- Feature-by-feature with checkmarks/X marks
- Price comparison column
- Quality/rating comparison

**9. FAQ (Accordion)**
- Expandable/collapsible questions
- Address common objections
- 4-8 Q&A pairs with clear answers

**10. CTA (Final Call-to-Action)**
- Large, prominent "Add to Cart" button
- Urgency headline
- Trust badges (guarantee, shipping, security)
- Footer navigation below (same as nav but simplified)

## How to Use This Skill

### Step 1: Gather Content
Before building, collect:
- Product/offer name
- Target audience
- Primary pain point you're solving
- Key benefits (3-5)
- Product features/specs
- Price and offers
- Testimonials (or placeholders)
- Brand colors/fonts

### Step 2: Choose Template
- **Landing Page**: Lead capture, webinar, free trial, email signup
- **Product Page**: Direct product sale, e-commerce

### Step 3: Map Content to Template

**For Landing Pages:**
1. Hero → Headline, subhead, CTA, hero image
2. Social Proof → Customer count, logos
3. Problem → Pain point in customer's words
4. Agitation → Why problem gets worse
5. Solution → Product intro + benefits
6. Mechanics → How it works (3 steps)
7. Testimonials → Social proof
8. Offer → What's included + bonuses
9. Risk Reversal → Guarantees
10. Final CTA → Urgency + button

**For Product Pages (10-section flow):**
1. Nav → Top horizontal navigation bar with menu links, logo, cart icon
2. Buybox → Central product buy module: image left, title/pricing right, add-to-cart button, variant selectors. Ensure product name is clearly seen, with a social proof callout on top of it
3. Social Proof → First testimonials row: quotes, stars, avatars; social share icons above
4. Social Proof #2 → Second proof block: more testimonials or user-generated content feeds
5. Benefits → Icon-bulleted benefits list with short descriptions under each
6. Ingredients/Materials → Product ingredients or specs grid: images, labels, checkboxes
7. Social Proof #3 → Third proof area: video modal trigger, influencer quotes, or case studies
8. Comparison → Table comparing product vs alternatives: columns for features, pricing, checks
9. FAQ → Expandable questions list addressing common objections
10. CTA → Final urgent call-to-action: large button, guarantee badges, footer nav below

### Step 4: Output Format
Output as:
- **Figma-ready spec** - with exact copy, images needed, colors
- **HTML structure** - semantic HTML with placeholder content
- **Copy document** - just the text/headlines for your designer

## Conversion Principles

### Headline Formula
- [Emotion] + [Specific Result] + [Timeframe]
- Example: "Wake Up to Glowing Skin in 7 Days"

### CTA Button Rules
- Use contrasting color from brand
- Action verb + benefit: "Get My Free Guide"
- Above the fold AND at bottom
- Big, clickable (min 44px height)

### Social Proof Placement
1. Immediately after hero (logo bar)
2. Before offer section (testimonials)
3. Above the fold (star ratings)

### Risk Reversal Must-Haves
- Money-back guarantee (时长)
- "No questions asked"
- Free shipping (if applicable)
- "Secure checkout"

## Example: SoftEditSkin Product Page

**Product**: Ceramide Night Cream
**Price**: $48
**Pain Point**: Dry, irritated skin

```
HERO:
- Headline: "Wake Up to Soft, Calm Skin"
- Subhead: "The ceramide-rich cream that repairs your barrier overnight"
- CTA: "Add to Cart - $48"
- Image: Product shot with soft lighting

QUICK OVERVIEW:
- ✓ Repairs skin barrier
- ✓ Deep hydration
- ✓ Fragrance-free
- ✓ Ships free

BENEFITS:
- ✓ Ceramide Complex - Locks in moisture for 24hr hydration
- ✓ Shea Butter - Softens without greasiness  
- ✓ Niacinamide - Calms redness and irritation
- ✓ Vitamin E - Fights free radicals

HOW TO USE:
1. Apply to clean face nightly
2. Massage in upward strokes
3. Wake up with glowing skin

TESTIMONIALS:
- "My skin has never felt better" - Sarah M.
- "Worth every penny" - Jessica L.

FAQ:
- "How long until I see results?" → "Most see improvement in 7 days"
- "Is it for sensitive skin?" → "Yes, fragrance-free and hypoallergenic"
```

## File Structure
```
landing-page-converter/
├── SKILL.md                 # This file
├── templates/
│   ├── landing-page.html    # Landing page HTML template
│   └── product-page.html   # Product page HTML template
└── examples/
    ├── softedit-skin.md    # Example: product page
    └── tiny-edit.md        # Example: landing page
```
