# Exploit Validation

Use this process for every finding.

## 1) Entry Control

Identify exact attacker-controlled inputs:
- calldata fields
- msg.value
- signature values
- oracle update path
- bridge message payload
- shared object references (Move/Sui)

If attacker cannot control an input, reject or downgrade.

## 2) Guard Mapping

Map every protection layer:
- modifiers
- role checks
- replay protection
- nonces/deadlines
- reentrancy guards
- pause/timelock checks
- capability ownership checks (Move)

Record which guard is bypassed and why.

## 3) State Transition Proof

For each transaction in attack path:
- pre-state assumptions
- called function + parameters
- post-state changes

Use expected vs actual tables for clarity.

## 4) Determinism Test

Ask:
- does this path rely on nondeterministic timing?
- does it require privileged race placement?
- can another actor block it trivially?

If yes, reduce confidence or reject.

## 5) Impact Link

Exploit path must link to at least one:
- direct fund theft
- unfair value extraction
- irreversible lock/loss of funds
- unauthorized privilege/control
- critical protocol integrity failure

## Confidence Assignment

- `Confirmed`: reproducible deterministic path with impact evidence.
- `Probable`: coherent path with minor missing execution evidence.
- `Theoretical`: speculative or assumption-heavy path.
