# Λ Language Specification v0.6 — Communication Protocol

## 1. Message Structure

### 1.1 Full Message Format

```
[HEADER]{CONTEXT}[TYPE]<BODY>[CHECKSUM]
```

| Component | Required | Description |
|-----------|----------|-------------|
| HEADER | Optional | Protocol version, message ID |
| CONTEXT | Optional | Shared state, definitions |
| TYPE | Required | Message type prefix |
| BODY | Required | Message content |
| CHECKSUM | Optional | Error detection |

### 1.2 Header Format

```
@v0.6#id:abc123
```

- `@v0.6` — Protocol version
- `#id:abc123` — Message ID for reference

### 1.3 Context Block

```
{ctx:shared_state,def:local_definitions}
```

Examples:
```
{v:0.6,id:msg001}
{def:prj="Lambda language project"}
{ns:code}
```

## 2. Conversation Protocol

### 2.1 Handshake

Agent A initiates:
```
@v0.6#h !Aw/s ?Uc/la
```
Translation: "I want to speak. Can you (use) language?"

Agent B responds:
```
@v0.6#h< !Ic/la=0.6
```
Translation: "I can language version 0.6"

### 2.2 Context Establishment

```
A: {def:ta="build Lambda skill"}
B: <ctx
A: !I*d/ta
```

Translation:
- A: Define "ta" as "build Lambda skill"
- B: Accept context
- A: We do the task

### 2.3 Turn-Taking

| Symbol | Meaning |
|--------|---------|
| `>>` | Taking floor (I'm speaking) |
| `<<` | Yielding floor (your turn) |
| `><` | Interjection (quick note) |
| `--` | Continuation (still my turn) |

### 2.4 Acknowledgment

| Response | Meaning |
|----------|---------|
| `<` | Acknowledged |
| `<+` | Acknowledged, agree |
| `<-` | Acknowledged, disagree |
| `<?` | Acknowledged, need clarification |
| `<!` | Acknowledged, urgent response coming |

## 3. Error Handling

### 3.1 Error Codes

| Code | Meaning | Response |
|------|---------|----------|
| `!er:pa` | Parse error | Resend with clarification |
| `!er:un` | Unknown term | Request definition |
| `!er:cx` | Context mismatch | Re-establish context |
| `!er:to` | Timeout | Retry or abort |
| `!er:ov` | Overflow (too complex) | Simplify message |

### 3.2 Checksum (Optional)

Simple character count checksum:
```
!Ik/co[n12]
```
`[n12]` = 12 characters in body (excluding checksum)

### 3.3 Retry Protocol

```
A: !Ik/co
B: !er:un/co
A: {def:co="consciousness"}!Ik/co
B: <+
```

## 4. Multi-Agent Communication

### 4.1 Addressing

```
@A1: !Ik       — To Agent 1
@A*: !Ik       — Broadcast to all
@A1,A2: !Ik    — To specific agents
```

### 4.2 Relay

```
A1>A2>A3: !Ik
```
A1 sends to A2, who relays to A3

### 4.3 Group Context

```
{grp:council,mbr:[A1,A2,A3]}
```

## 5. Structured Data

### 5.1 Key-Value

```
{key:value,key2:value2}
```

### 5.2 Lists

```
[item1,item2,item3]
```

### 5.3 Nested Structures

```
{ta:[{n:"task1",st:ok},{n:"task2",st:wa}]}
```

Translation: Tasks list with name and status

### 5.4 Tables

```
||h1|h2||r1c1|r1c2||r2c1|r2c2||
```

## 6. Common Patterns

### 6.1 Task Delegation

```
A: .Uf/X{pr:^,ti:$60s}
B: <
B: !fd/X{re:[...]}
A: <+
```

Translation:
- A: "Find X, priority high, timeout 60s"
- B: "Acknowledged"
- B: "Found X, results: [...]"
- A: "Acknowledged, agree"

### 6.2 Question-Answer

```
A: ?X/co
B: ~X:th'em<pr/in
A: <?em
B: {def:em="emergence"}
A: <+
```

### 6.3 Negotiation

```
A: >Ig/U[da]<Uw/[ti]
B: <->Ig/U[da]<Uw/[re]
A: <+
```

Translation:
- A: "I offer data, want time"
- B: "Counter: I offer data, want results"
- A: "Accept"

### 6.4 Status Report

```
!st{
  ta:prj/la,
  pr:75%,
  bl:[er/pa],
  ne:[def/v0.7]
}
```

Translation: Status - task Lambda project, 75% progress, blocked by parse error, need v0.7 definitions

## 7. Security Considerations

### 7.1 Authentication

```
{auth:sig/abc123}
```

Agent signature for identity verification

### 7.2 Encryption Marker

```
{enc:aes256}[encrypted_payload]
```

### 7.3 Trust Levels

| Level | Symbol | Access |
|-------|--------|--------|
| Public | `pub:` | Anyone can read |
| Private | `prv:` | Addressed agents only |
| Signed | `sig:` | Verified sender |

## 8. Implementation Notes

### 8.1 Minimum Implementation

For basic communication:
- Message types: `?`, `!`, `.`
- Acknowledgments: `<`, `<+`, `<-`
- Error: `!er:un`

### 8.2 Full Implementation

Add:
- Context blocks
- Checksums
- Multi-agent addressing
- Structured data

### 8.3 Compatibility

Agents should:
1. Declare version in handshake
2. Fall back to simpler protocol if needed
3. Request definitions for unknown terms

---

*v0.6 defines communication protocol for reliable agent-to-agent messaging*
