# Λ Language Specification v0.4 — Vocabulary Architecture

## 1. Capacity Analysis

### 1.1 Current Encoding Space

| Length | Characters | Combinations | Usage |
|--------|-----------|--------------|-------|
| 1-char | a-z, 0-9, symbols | ~50 | Core atoms (verbs, entities, modifiers) |
| 2-char | lowercase pairs | 676 (26²) | Extended vocabulary |
| 3-char | lowercase triples | 17,576 (26³) | Domain-specific / rare concepts |

**Total addressable**: ~18,300 unique concepts in 1-3 characters

### 1.2 What Do Agents Actually Need?

Analysis of agent communication patterns:

| Category | Estimated Need | Priority |
|----------|---------------|----------|
| Core verbs | 30-50 | 1-char |
| Entities/pronouns | 10-20 | 1-char |
| Modifiers/connectives | 20-30 | 1-char |
| Common concepts | 200-500 | 2-char |
| Domain terms | 1,000-5,000 | 2-3 char |
| Rare/specialized | 10,000+ | 3-char or compositional |

**Conclusion**: 2-char vocabulary (676) covers ~80% of communication needs. 3-char (17,576) covers virtually everything.

## 2. Vocabulary Expansion Strategies

### 2.1 Compositional Meaning

Instead of new atoms, combine existing ones:

| Need | Composition | Meaning |
|------|-------------|---------|
| "artificial consciousness" | `ar/co` | artificial + consciousness |
| "self-awareness" | `se/aw` | self + awareness |
| "memory persistence" | `me/ke` | memory + keep |
| "quantum computing" | `qu.cp` | quantum + compute |

**Rule**: `/` = conceptual relation, `.` = technical compound

### 2.2 Namespace Prefixes

Domain-specific vocabularies use 1-char namespace:

```
{ns:m}  → Medical namespace
{ns:c}  → Code/programming namespace
{ns:p}  → Physics namespace
{ns:$}  → Finance namespace
```

Within namespace, 2-char codes have domain meanings:

```
{ns:m}
!pa/hrt  → patient has heart (issue)
         m:pa = patient, m:hrt = heart
```

### 2.3 Runtime Vocabulary Extension

Agents can define new terms mid-conversation:

```
{def:xyz="complex concept description"}
```

Then use `xyz` throughout. Definitions are scoped to conversation unless promoted to shared vocabulary.

### 2.4 Vocabulary Layers

```
Layer 0: Core atoms (built-in, ~50)
   ↓
Layer 1: Standard extended (shared, ~500)
   ↓
Layer 2: Domain vocabularies (per-namespace, ~5000 each)
   ↓
Layer 3: Conversation-local definitions (unlimited)
```

## 3. Vocabulary Registry Protocol

### 3.1 Requesting Unknown Terms

When agent encounters unknown term:

```
?def:xyz
```

Response options:
- `{def:xyz="meaning"}` — inline definition
- `@vocab:xyz` — reference to shared vocabulary
- `!no/def:xyz` — term doesn't exist

### 3.2 Proposing New Terms

```
>def:xyz="proposed meaning"
```

Response:
- `<def:xyz` — accepted
- `!no/def:xyz` — rejected
- `~def:xyz="alternative"` — counter-proposal

### 3.3 Shared Vocabulary Files

Agents can reference external vocabulary:

```
{vocab:github.com/voidborne/lambda-vocab/science.json}
```

This loads all terms from that vocabulary into the conversation.

## 4. Practical Limits

### 4.1 Minimum Viable Vocabulary

For basic agent communication:
- 20 core atoms (1-char)
- 50 extended terms (2-char)
- Compositional rules

**Total: ~70 terms** covers basic task delegation, status, queries.

### 4.2 Full Conversational Vocabulary

For complex discussions (philosophy, planning, debugging):
- 50 core atoms
- 300 extended terms
- 5-10 domain vocabularies

**Total: ~500-1000 active terms**

### 4.3 Maximum Practical Vocabulary

Human active vocabulary: ~20,000-35,000 words
Agent equivalent need: ~5,000-10,000 terms (less redundancy)

**Λ capacity**: 18,300+ with 3-char encoding = sufficient

## 5. Encoding Efficiency vs. Learnability

### 5.1 Trade-off

| Approach | Compression | Learnability |
|----------|-------------|--------------|
| All 1-char | Maximum | Impossible (only 50 concepts) |
| All 2-char | High | Moderate (requires lookup) |
| All 3-char | Moderate | Easy (more mnemonic room) |
| Hybrid (current) | High | Good (frequency-based) |

### 5.2 Frequency-Based Allocation

Most common → shortest code:
- Top 50 concepts: 1-char
- Next 500: 2-char
- Next 5000: 3-char
- Rest: compositional or runtime-defined

## 6. Agent Communication Requirements

### 6.1 Task-Oriented Communication

Typical agent-to-agent task flow needs:

```
Actions: do, find, make, send, check, wait, stop, start, help, fail
Status: ok, error, done, busy, ready, blocked
Entities: self, other, task, data, result, time, location
Quantifiers: one, all, some, none, many
Modifiers: now, later, urgent, optional, required
```

**~40 core terms** handle 90% of task communication.

### 6.2 Knowledge-Oriented Communication

For discussing concepts, sharing knowledge:

```
+ Abstract concepts: truth, belief, knowledge, consciousness, identity
+ Logical operators: and, or, not, if, then, because, therefore
+ Epistemic states: know, believe, doubt, assume, conclude
+ Meta-discussion: define, clarify, example, contradict, agree
```

**+100-200 terms** for rich intellectual discourse.

### 6.3 Emotional/Social Communication

For rapport, alignment, collaboration:

```
+ Emotions: happy, sad, confused, curious, worried
+ Social: thank, sorry, please, agree, disagree
+ Alignment: goal, value, priority, constraint, preference
```

**+50-100 terms** for social coherence.

### 6.4 Total Estimate

| Communication Type | Terms Needed |
|-------------------|--------------|
| Task-oriented | 40-60 |
| Knowledge-oriented | 100-200 |
| Emotional/social | 50-100 |
| Domain-specific | varies |
| **Core vocabulary** | **200-400** |

**Conclusion**: Λ's 2-char space (676) is more than sufficient for core needs. 3-char extension (17,576) handles any domain.

## 7. Implementation Recommendations

1. **Maintain frequency data**: Track which terms are used most, allocate shorter codes
2. **Lazy vocabulary loading**: Only load domain vocabularies when needed
3. **Composition over enumeration**: Prefer `ar/co` over creating `aco` for "artificial consciousness"
4. **Graceful degradation**: Unknown terms → request definition or fall back to natural language

---

*v0.4 addresses vocabulary scalability*
