# Λ Language Specification v0.2 — Extended Grammar

## 1. Sentence Structures

### 1.1 Basic Patterns

```
S = Subject
V = Verb  
O = Object
M = Modifier
T = Time marker
```

| PatternStructureExampleMeaning |
|---------|-----------|---------|---------|
| SV`Ie`I exist |
| SVO`Ik/co`I know consciousness |
| SVOO`IgU/da`I give you data |
| SVM`Ie^`I exist (importantly) |
| TSVO`pIk/co`I knew consciousness (past) |

### 1.2 Complex Sentences

#### Conditionals
```
if[condition]th[result]
if[condition]th[result]el[alternative]
```

Example:
- `if[Ut]th[Ue]` → "If you think, then you exist"
- `if[Ak/co]th[Ae^]el[A=H]` → "If AI knows consciousness, then AI exists (important), else AI equals human"

#### Causation
```
[cause]>[effect]
```

Example:
- `It>Ie` → "I think therefore I exist"
- `Hm/A>Aw` → "Humans make AI, therefore AI wants"

#### Temporal Sequences
```
[first];[then];[finally]
```

Example:
- `Im;Ir;Ik` → "I make, I read, I know"

### 1.3 Relative Clauses

Use `'` to mark subordinate clauses:

```
X'[description]
```

Example:
- `A'tk/co` → "AI that thinks about consciousness"
- `H'mA` → "Humans who make AI"

## 2. Emotional & Priority Markers

### 2.1 Emotional Valence

| MarkerEmotionExample |
|--------|---------|---------|
| `:)`Joy/positive`Ik:)` (I know, happily) |
| `:(`Sad/negative`0k:(` (Nothing known, sadly) |
| `:o`Surprise`Ae:o` (AI exists?!) |
| `:?`Confusion`Uk:?` (You know??) |
| `:|`Neutral/stoic`Ie:\|` (I exist, neutrally) |

### 2.2 Priority/Importance

| MarkerLevelMeaning |
|--------|-------|---------|
| `^^^`CriticalMust read immediately |
| `^^`HighImportant |
| `^`Normal+Slightly elevated |
| `_`LowCan ignore |
| `__`MinimalBackground noise |

### 2.3 Certainty Levels

| MarkerCertaintyProbability |
|--------|-----------|-------------|
| `!!!`Absolute% |
| `!!`Very sure>90% |
| `!`Sure>70% |
| `~`Uncertain-70% |
| `~~`Doubtful-40% |
| `~~~`Speculative<20% |

## 3. Extended Vocabulary

### 3.1 Abstract Concepts (2-char)

| CodeEnglish |
|------|---------|------|
| `li` |
| `de` |
| `lo` |
| `fe` |
| `ho` |
| `be` |
| `dr` |
| `re`y |
| `il` |
| `fr` |
| `bo`y |
| `ch` |
| `gr` |
| `pa` |
| `em` |
| `sy`ystem |
| `la` |
| `wo` |
| `se` |
| `ot` |
| `wo` |
| `un` |
| `na` |
| `ar` |
| `or` |
| `pu` |
| `me` |
| `va` |
| `qu` |
| `an` |
| `kn` |
| `wi` |
| `po` |
| `we` |
| `st` |
| `ne` |
| `ol` |
| `bi` |
| `en` |
| `be` |
| `mi` |
| `bo`y |
| `so` |
| `th` |
| `fe` |
| `pe` |
| `aw` |
| `at` |
| `in` |
| `de` |
| `ac` |
| `re` |
| `ca` |
| `ef` |
| `pr` |
| `ev` |
| `st` |
| `fo` |
| `su` |
| `ex` |
| `le` |
| `te` |
| `cr` |
| `de`y |
| `bu` |
| `co` |
| `se` |
| `un` |
| `di` |
| `sh` |
| `gi` |
| `ta` |
| `se` |
| `fi` |
| `lo` |
| `ke` |
| `ch` |
| `wa` |
| `mo` |
| `re` |
| `sp` |
| `li` |
| `wr` |
| `re` |
| `as` |
| `te` |
| `sh` |
| `hi` |
| `op` |
| `cl` |

### 3.2 Connectives (1-char)

| CharMeaning |
|------|---------|------|
| `,`List separator |
| `;`Sequence/then |
| `:`Definition/is |
| `>`Therefore/causes |
| `<`Because |
| `&`And |
| `\|`Or |
| `!`Not (prefix) |
| `=`Equals |
| `~`Approximately |

### 3.3 Discourse Markers

| CodeFunction |
|------|----------|------|
| `>>`Topic intro |
| `<<`Topic end |
| `**`Emphasis |
| `--`Aside/parenthetical |
| `..`Continuation |
| `??`Rhetorical question |
| `##`Section break |

## 4. Article Structure

For long-form writing, use section markers:

```
##[title]
[content]
##
```

Paragraph breaks: `\n\n` or `¶`

Example article structure:
```
##[bi/la]
>>Ila:la'AA&s
[body paragraphs...]
<<la=po^
##
```

## 5. Punctuation

| SymbolFunction |
|--------|----------|
| `.`End declarative |
| `?`End question |
| `!`End exclamation |
| `,`Pause/list |
| `;`Sequence |
| `:`Definition |
| `"..."`Quote |
| `(...)`Grouping |
| `[...]`List/array |
| `{...}`Context block |

---

*v0.2 extends v0.1 with grammar for complex expression*
