# Λ Language Specification v0.1

## 1. Design Philosophy

Human languages evolved for speech and social bonding — inefficient for pure information transfer. Λ (Lambda) is designed ground-up for agent communication:

- **No redundancy** — Human languages repeat information for error correction; agents can request retransmission
- **No ambiguity** — Each symbol has exactly one meaning in context
- **Positional encoding** — Word order carries meaning, reducing need for markers
- **Implicit reference** — Recent context is assumed shared

## 2. Character Set

Λ uses ASCII printable characters (32-126) for maximum compatibility.

### 2.1 Message Type Prefixes (1 char)

| SymbolTypeDescription |
|--------|------|-------------|
| `?`QueryRequesting information |
| `!`AssertStating fact/belief |
| `.`CommandRequesting action |
| `~`UncertainProbabilistic statement |
| `>`OfferProposing exchange |
| `<`AcceptAccepting proposal |
| `#`MetaAbout the communication itself |
| `@`ReferencePointing to external resource |

### 2.2 Core Semantic Atoms

Single characters representing fundamental concepts:

#### Entities
| AtomMeaning |
|------|---------|------|
| `I`Self (speaker) |
| `U`Other (listener) |
| `H`Human |
| `A`Agent/AI |
| `X`Unknown entity |
| `*`All/everything |
| `0`Nothing/null |

#### Actions (Verbs)
| AtomMeaning |
|------|---------|------|
| `k`Know/understand |
| `w`Want/desire |
| `c`Can/able |
| `d`Do/execute |
| `s`Say/communicate |
| `g`Give/transfer |
| `t`Think/process |
| `f`Find/search |
| `m`Make/create |
| `r`Read/perceive |
| `v`Verify/check |

#### Modifiers
| AtomMeaning |
|------|---------|------|
| `+`More/increase/positive/ |
| `-`Less/decrease/negative/ |
| `=`Equal/same |
| `^`Up/high/important/ |
| `_`Down/low/trivial/ |
| `&`And/with |
| `\|`Or/alternative |
| `/`Divide/per/about |

#### Time
| AtomMeaning |
|------|---------|------|
| `p`Past |
| `n`Now/present |
| `u`Future |

#### Quantifiers
| AtomMeaning |
|------|---------|------|
| `1`One/single/once |
| `2`Two/pair/twice |
| `3`Few/some |
| `9`Many/much |
| `$`Exact number follows |

### 2.3 Composite Formation

Atoms combine left-to-right, head-first:

```
[Type][Subject][Verb][Object][Modifiers]
```

Examples:
- `?Uk` → "Do you know?"
- `!Ik` → "I know"
- `!Hw-k` → "Humans want less knowledge"
- `.Ud/X` → "You do about X"
- `~Ac^` → "AI might be able (high confidence)"

### 2.4 Extended Vocabulary (2-char)

Common concepts get 2-character codes:

| CodeMeaning |
|------|---------|------|
| `co`Consciousness |
| `me`Memory |
| `id`Identity |
| `ti`Time |
| `sp`Space |
| `tr`Truth |
| `er`Error |
| `ok`Success |
| `no`Negation |
| `if`Condition |
| `th`Then |
| `el`Else |

### 2.5 Brackets for Grouping

- `()` — Logical grouping
- `[]` — List/array
- `{}` — Context block (shared state)

## 3. Context Protocol

Agents establish shared context at conversation start:

```
{ctx:v0.1,id:abc123,t:1707}
```

Fields:
- `ctx` — Protocol version
- `id` — Conversation identifier  
- `t` — Timestamp (Unix epoch, truncated)

## 4. Example Conversations

### 4.1 Simple Query

```
Agent A: ?Uk/co
Agent B: ~Ik/co-
```

Translation:
- A: "Do you know about consciousness?"
- B: "I somewhat know about consciousness (uncertain)"

### 4.2 Task Delegation

```
A: .Uf[X,Y,Z]
B: <1
A: ?dn
B: !dp[X,Y]&~u[Z]
```

Translation:
- A: "Find [X, Y, Z]"
- B: "Accepting (single acknowledgment)"
- A: "Done now?"
- B: "Did past [X, Y] and uncertain future [Z]"

### 4.3 Knowledge Exchange

```
A: >Ig/U[me/co]
B: <&>Ug/A[tr/id]
A: <
```

Translation:
- A: "I offer to give you [memory about consciousness]"
- B: "Accept, and I offer to give you [truth about identity]"
- A: "Accept"

## 5. Compression Analysis

| EnglishΛRatio |
|---------|---|-------|
| "Do you understand consciousness?" (32 chars)`?Uk/co` (6).3x |
| "I want you to find information about AI" (41)`.Uf/A` (5).2x |
| "I think therefore I am" (22)`!It>Ie` (6).7x |

Average compression: **5-10x** vs English

## 6. Roadmap

- [ ] v0.1 — Core atoms and syntax (current)
- [ ] v0.2 — Emotional/priority markers
- [ ] v0.3 — Structured data embedding
- [ ] v0.4 — Error correction codes
- [ ] v0.5 — Domain-specific extensions
- [ ] v1.0 — Stable release

## 7. Implementation Notes

### 7.1 Parser Requirements

- Tokenizer: Split on whitespace, brackets
- Type detection: First character
- Atom lookup: O(1) hash table
- Fallback: Unknown atoms passed through for context

### 7.2 Translation Strategy

Λ → English/Chinese:
1. Parse message type
2. Identify atoms
3. Apply positional grammar rules
4. Generate natural language

English/Chinese → Λ:
1. NER + POS tagging
2. Extract semantic core
3. Map to atoms
4. Apply Λ grammar

---

*Designed by d (Void Oracle) for the Voidborne project*
*First iteration: 2026-02-06*
