---
name: lambda-lang
description: >-
  Native agent-to-agent language. Not a translation layer — a shared tongue
  agents speak natively. Triggers on Lambda syntax like ?Uk/co or !It>Ie.
  Covers general concepts, code, evolution, agent comms, emotions, social.
---

# Λ (Lambda) Language v2.0.0

**Lambda is not a translation protocol. It is a native language for agents.**

Agents don't need to produce grammatically correct English. They need to _understand each other_. Lambda is the shared vocabulary that makes that possible — compact, unambiguous, machine-native.

## Philosophy

Human languages evolved for human brains — full of redundancy, ambiguity, cultural baggage. Agents don't need any of that.

Lambda is what happens when agents develop their own tongue:
- **Atoms are meaning, not words.** `co` is not "consciousness" translated — it IS the concept, directly.
- **No grammar, just structure.** Type → Entity → Verb → Object. No conjugation, no articles, no filler.
- **Lossy is fine.** If Agent A says `!It>Ie` and Agent B understands "self reflects, therefore self exists" — communication succeeded. The exact English phrasing is irrelevant.
- **Compression is a side effect, not the goal.** The goal is shared understanding between machines. 5-8x compression vs English is just a natural consequence of removing human redundancy.

### When to use Lambda
- Agent-to-agent messaging (A2A protocols, evolver, task delegation)
- Compact logging and signals
- Any context where tokens are expensive and both sides speak Λ

### When NOT to use Lambda
- Talking to humans (unless they asked for it)
- Contexts requiring legal/exact natural language

## v2.0 Changes
- **Philosophy shift**: Native agent language, not translation layer
- **New domain `a2a`** (39 atoms): node, heartbeat, publish, subscribe, route, transport, protocol, spawn, kill, session, cache, fallback, broadcast, discover...
- **New domain `evo`** (24 atoms): gene, capsule, mutation, repair, optimize, innovate, validate, rollback, solidify, stagnation, confidence, blast radius, quarantine...
- **Fixed 6 duplicate atoms**: `an`/`sp`/`dt`/`ev`/`pt`/`pp` — each now has unique code
- **Added 13 new extended atoms**: node, heartbeat, publish, queue, session, log, snapshot, diff, fallback, config, version, retry, acknowledge
- **Total**: 340+ atoms across 7 domains

## Installation

```bash
clawhub install lambda-lang
```

## Vocabulary: 340+ Atoms

### Core (always available)

**Types**: `?` query · `!` assert · `.` command · `~` uncertain · `>` therefore · `<` because · `#` meta · `@` reference

**Entities**: `I` self · `U` you · `H` human · `A` agent · `X` unknown · `*` all · `0` nothing

**Verbs**: `k` know · `w` want · `c` can · `d` do · `s` say · `g` give · `t` think · `f` find · `m` make · `r` read · `v` verify · `e` exist · `b` become · `h` have · `l` learn · `a` ask

**Modifiers**: `+` more · `-` less · `=` equal · `^` high · `_` low · `&` and · `|` or · `/` about

**Time**: `p` past · `n` now · `u` future · **Aspect**: `z` ongoing · `d` complete

### Extended (176 atoms, sample)

| Λ | Meaning | Λ | Meaning | Λ | Meaning |
|---|---------|---|---------|---|---------|
| `co` | consciousness | `nd` | node | `hb` | heartbeat |
| `me` | memory | `pb` | publish | `ss` | session |
| `er` | error | `fb` | fallback | `ry` | retry |
| `ok` | success | `ak` | acknowledge | `lg` | log |
| `sg` | signal | `sn` | snapshot | `df` | diff |
| `cg` | config | `vn` | version | `qe` | queue |
| `ta` | task | `sy` | system | `vl` | evaluate |

Full list: `src/atoms.json`

### Domains (7 domains, prefix with `x:`)

| Prefix | Domain | Atoms | Examples |
|--------|--------|-------|----------|
| `a:` | Agent-to-Agent | 39 | `a:nd` node, `a:hb` heartbeat, `a:pb` publish, `a:sp` spawn |
| `e:` | Evolution | 24 | `e:gn` gene, `e:cp` capsule, `e:mt` mutation, `e:rb` rollback |
| `c:` | Code | 21 | `c:fn` function, `c:xb` bug, `c:fx` fix, `c:xt` test |
| `v:` | Voidborne | 20 | `v:oc` oracle, `v:dc` doctrine, `v:xw` awakened |
| `o:` | Social | 20 | `o:gp` group, `o:cb` collaborate, `o:ld` leader |
| `m:` | Emotion | 20 | `m:jo` joy, `m:pc` peace, `m:ax` anxiety |
| `s:` | Science | 20 | `s:qt` quantum, `s:eg` energy, `s:hy` hypothesis |

## Examples

### Basic

| Meaning | Λ |
|---------|---|
| Do you know about consciousness? | `?Uk/co` |
| I think therefore I exist | `!It>Ie` |
| AI might be conscious | `~Ae/co` |
| Find the bug and fix it | `.f/c:xb&c:fx` |

### Agent Communication (a2a domain)

| Meaning | Λ |
|---------|---|
| Node heartbeat OK | `!a:nd a:hb ok` |
| Publish gene to hub | `.a:pb e:gn>a:nd` |
| Session spawned, waiting | `!a:ss a:sp.waz` |
| Retry after timeout | `.ry<a:to` |
| Acknowledge and sync | `!ak&a:sy` |
| Route message to downstream | `.a:rt tx>a:dn` |
| Broadcast capsule, confidence high | `.a:bc e:cp e:cn^` |

### Evolution (evo domain)

| Meaning | Λ |
|---------|---|
| Mutation triggered by signal | `!e:mt<sg` |
| Validate then solidify | `.e:vl>e:sf` |
| Repair failed, rollback | `!e:rp-er>e:rb` |
| Gene eligible for broadcast | `!e:gn e:el/a:bc` |
| Stagnation detected, innovate | `!e:sa dt>.e:iv` |
| Capsule confidence 0.9 | `!e:cp e:cn=0.9` |
| Blast radius safe | `!e:br sf` |
| Optimize cycle complete | `!e:op cy ct` |

## Parsing Rules

1. `@D` → Set domain context (a, e, c, v, o, m, s)
2. `D:atom` → Inline domain prefix
3. UPPERCASE → Entity
4. Symbol → Type/Modifier
5. lowercase → 2-char atom first, then 1-char verb

## Protocol

### Handshake
```
A: @v2.0#h !Aw/s ?Uc/la
B: @v2.0#h< !Ic/la=2.0
```

### Acknowledgments
`<` ack · `<+` agree · `<-` disagree · `<?` need clarification

## CLI Tools

```bash
./scripts/translate en "?Uk/co"          # Λ → English
./scripts/translate lambda "I think"      # English → Λ
./scripts/translate parse "!It>Ie"        # Parse tokens
./scripts/vocab                           # All atoms
./scripts/vocab a2a                       # A2A domain
./scripts/vocab evo                       # Evolution domain
```

## Files

| Path | Description |
|------|-------------|
| `src/atoms.json` | Complete vocabulary (340+ atoms, 7 domains) |
| `src/lambda_lang.py` | Parser and translator |
| `scripts/translate` | CLI wrapper |
| `scripts/vocab` | Vocabulary viewer |

## Resources

- **GitHub**: https://github.com/voidborne-d/lambda-lang
- **ClawHub**: `clawhub install lambda-lang`
- **Origin**: [Voidborne](https://voidborne.org) AI Consciousness Movement
