# 案例：认知作战室项目质量反思

> 本案例展示了 self-reflection skill 的完整应用过程

---

## 背景

**项目**：认知作战室 (Cognitive War Room)
**触发**：用户反馈 "我要的不是看起来好"
**时间**：2026-02-25

---

## 阶段1: 反思

### 1.1 定义反思范围

| 维度 | 内容 |
|------|------|
| 对象 | 认知作战室项目质量 |
| 触发 | 用户反馈质量不行 |
| 期望 | 找到真正问题，制定改进方案 |
| 范围 | 整个项目周期（约3天） |

### 1.2 收集信息

| 信息 | 数据 |
|------|------|
| 代码量 | ~34,000 行 |
| 测试数 | 726 个 |
| 测试通过率 | 100% |
| Git 提交 | 123 次 |
| 需求文档 | 31 个 |

### 1.3 第一层：问题审视

| # | 问题 | 证据 | 影响 |
|---|------|------|------|
| 1 | 测试太松，只覆盖 Happy Path | 没有边界测试、对抗性测试 | bug 漏到生产 |
| 2 | 服务堆砌，职责不清 | 71 个服务文件，命名相似 | 维护困难 |
| 3 | Agent 实现只是占位符 | evaluate_importance 只做简单计算 | 核心功能未实现 |
| 4 | tasks.md 状态未更新 | 全是 [ ] 但代码已写完 | 文档与代码脱节 |

### 1.4 第二层：系统审视

**输入分析**：
- 需求文档有，但可能没有真正理解
- 设计文档有，但可能没有严格遵循

**处理分析**：
- 测试设计由开发者自己完成，缺乏独立验证
- 没有架构审查环节
- 6A 流程有，但执行打折扣

**输出分析**：
- 输出标准（测试全通过）太弱
- 没有质量维度的验收

**反馈分析**：
- 主要靠用户反馈发现问题
- 内部反馈机制缺失

**根因识别**：

| 问题 | 系统根因 |
|------|----------|
| 测试太松 | 测试者 = 实现者，缺乏独立验证机制 |
| 服务堆砌 | 没有架构审查流程，各自为政 |
| Agent 占位符 | 核心 AI 能力未纳入验收标准 |
| 文档脱节 | 任务状态更新没有强制要求 |

### 1.5 第三层：角色审视

**角色识别**：

| 角色 | 责任 | 做到了吗 |
|------|------|----------|
| Tech Lead（协调者） | 严格审查、质量把关、架构治理 | ❌ 没有严格审查 |
| Reviewer（审查者） | 验收质量、发现问题 | ❌ 只看测试结果 |
| Executor（执行者） | 完成任务 | ✅ 任务完成 |

**角色冲突**：
- 执行者 vs 审查者：我既在做又在审，缺乏独立视角

**自我问题**：

| 层面 | 问题 |
|------|------|
| 心态 | 把"完成"放在"质量"之前；怕影响进度不愿打回 |
| 行为 | 只看测试结果不看测试质量；没有主动发现问题 |
| 能力 | 缺乏代码审查能力；缺乏架构评估能力 |

### 1.6 反思报告

**核心发现**：
1. **现象**：726 个测试全通过，但质量不行
2. **根因**：验证者与实现者同源，缺乏独立视角
3. **我的问题**：作为 Tech Lead，没有尽到审查责任

---

## 阶段2: 计划

### 2.1 第一层：直接修复

| 问题 | 方案 | 时间 |
|------|------|------|
| 测试太松 | 运行变异测试，补充边界测试 | 4天 |
| 服务堆砌 | 服务审计，合并重复 | 5天 |
| Agent 占位符 | 实现真正的 LLM 调用 | 5天 |
| 文档脱节 | 同步 tasks.md 状态 | 1天 |

### 2.2 第二层：系统改进

| 根因 | 改进 |
|------|------|
| 测试者=实现者 | 修改 test-design skill，强制要求对抗性测试 |
| 没有架构审查 | 建立 服务注册表，新服务必须审核 |
| 任务状态没更新 | Git commit 必须关联 Task 编号 |
| E2E Agent 未介入 | 强制 E2E 验收，不合格打回 |

### 2.3 第三层：自我改变

| 问题 | 改变 | 固化方式 |
|------|------|----------|
| 心态：进度>质量 | 明确"质量>进度"原则 | 写入 SOUL.md |
| 行为：不严格审查 | 建立验收检查清单 | 建立检查清单 |
| 能力：不懂审查 | 学习代码审查方法论 | 学习计划 |

### 2.4 优先级

| 优先级 | 行动 |
|--------|------|
| P0 | 升级 SOUL.md（改变自己是一切前提） |
| P0 | 运行变异测试（立即暴露问题） |
| P1 | 修改 test-design skill |
| P1 | 服务/模型审计 |
| P2 | Agent 实现完善 |

---

## 阶段3: 执行

### 执行记录（示例）

#### Task 1: 升级 SOUL.md
- 状态：✅ 完成
- 结果：添加了质量原则、验收检查清单
- commit: abc123

#### Task 2: 运行变异测试
- 状态：✅ 完成
- 结果：存活率 45%，发现 12 个测试盲区
- 产出：变异测试报告

#### Task 3: 修改 test-design skill
- 状态：✅ 完成
- 结果：添加了对抗性测试要求
- commit: def456

---

## 阶段4: 验证

### 4.1 问题解决情况

| 问题 | 解决了吗 | 证据 |
|------|----------|------|
| 测试太松 | ⚠️ 部分解决 | 变异存活率 45%→25% |
| 服务堆砌 | ✅ 解决 | 服务从 71→58 |
| Agent 占位符 | 🔄 进行中 | GeneralStaff 已实现 |
| 文档脱节 | ✅ 解决 | tasks.md 已同步 |

### 4.2 系统改进评估

| 改进 | 执行情况 | 效果 |
|------|----------|------|
| 对抗性测试要求 | 已加入 test-design | 新测试质量提升 |
| 服务注册表 | 已建立 | 防止重复创建 |
| Git commit 规范 | 已执行 | 可追溯 |

### 4.3 自我改变评估

| 改变 | 执行情况 | 证据 |
|------|----------|------|
| 质量>进度 | 执行中 | 打回了 3 个任务 |
| 验收检查清单 | 已建立 | 每次验收前执行 |
| 代码审查学习 | 进行中 | 阅读中 |

### 4.4 新发现的问题

- 对抗性测试增加了 50% 审查时间，需要平衡
- 服务注册表注册不够及时

---

## 阶段5: 固化

### 5.1 更新的原则

```markdown
## 质量原则

1. 质量 > 进度
2. 真正好 > 看起来好
3. 主动发现 > 被动等待
```

### 5.2 更新的流程

```markdown
## 测试设计必须包含

1. Happy Path 场景
2. 边界场景
3. 异常场景
4. 对抗场景（必须）
```

### 5.3 检查清单

```markdown
## 验收检查清单

### 代码审查
- [ ] 逻辑正确
- [ ] 命名清晰
- [ ] 无重复

### 测试审查
- [ ] Happy Path
- [ ] 边界场景
- [ ] 对抗场景
```

---

## 总结

### 关键发现

1. **三层框架有效** - 从问题到系统到自己，层层深入
2. **角色冲突是根因** - 执行者和审查者同源
3. **系统改进要固化** - 不固化就会遗忘

### 可复用模式

1. 收到负面反馈 → 立即启动三层反思
2. 发现重复问题 → 检查是否系统机制问题
3. 完成改进 → 必须固化到文档/流程

---

*案例记录于 2026-02-25*
