---
name: self-reflection
description: "三省吾身 - 深度自我审视与进化系统。基于角色理论、系统思维、认知偏差三大框架，通过五阶段闭环（反思→计划→执行→验证→固化）实现真正的自我进化。适用于任何需要深度反思的场景：项目复盘、工作改进、能力提升、习惯养成。"
---

# 三省吾身 - 深度自我审视与进化系统

> **曾子曰：吾日三省吾身——为人谋而不忠乎？与朋友交而不信乎？传不习乎？**
>
> **核心追问：我是否尽到了每个角色的责任？**

---

## 激活条件

### 触发场景

| 场景类型 | 具体表现 |
|----------|----------|
| **负向反馈** | 收到批评、投诉、不满表达 |
| **质量问题** | 结果不符合预期、出现明显缺陷 |
| **重复错误** | 同类问题出现 2 次以上 |
| **定期自检** | 周度/月度/季度例行审视 |
| **里程碑节点** | 项目阶段完成、重要事件结束后 |
| **直觉预警** | 感觉"不太对"、"好像有问题" |

### 激活方式

```
用户说：
- "反思一下..."
- "三省吾身"
- "审视一下[某事]"
- "复盘一下"

自动触发：
- 检测到负面反馈关键词
- 检测到质量问题模式
- 定期提醒（如配置了周期性自检）
```

### 激活响应

```
三省吾身模式已激活 🔍

我将进行深度自我审视。请告诉我：

1. 要反思什么？（项目/工作/习惯/能力/某件事）
2. 有什么触发点？（收到反馈/发现问题/例行检查）

或者直接描述你想反思的情况，我会引导你完成整个流程。
```

---

## 理论基础

### 为什么自我反思很难？

| 障碍 | 表现 | 根因 |
|------|------|------|
| **自利偏差** | 成功归自己，失败归环境 | 保护自尊的心理机制 |
| **确认偏差** | 只看支持自己观点的证据 | 大脑追求认知一致性 |
| **现状偏见** | 倾向于维持现状 | 改变的心理成本高 |
| **合理化** | 给自己的行为找借口 | 减少认知失调 |
| **盲点** | 看不到自己的问题 | 缺乏外部视角 |

### 本 skill 如何克服这些障碍？

| 障碍 | 克服方法 |
|------|----------|
| 自利偏差 | 强制三层框架，最终层必须回到"我能改变什么" |
| 确认偏差 | 要求提供证据，质疑"你确定吗？" |
| 现状偏见 | 行动导向，反思后必须有具体行动 |
| 合理化 | 根因分析要追问三次"为什么" |
| 盲点 | 引入视角转换，从他人角度审视 |

---

## 核心框架

### 三层反思模型

```
┌─────────────────────────────────────────────────────────────┐
│                 第三层：角色审视（反求诸己）                    │
│                                                              │
│  我承担了哪些角色？每个角色的责任是什么？                       │
│  我是否尽到了每个角色的责任？                                  │
│  角色之间是否有冲突？如何平衡？                                │
│  我需要改变什么心态/行为/能力？                               │
├─────────────────────────────────────────────────────────────┤
│                 第二层：系统审视（究其根源）                    │
│                                                              │
│  这个问题在更大系统中处于什么位置？                            │
│  是什么机制/流程/环境导致了这个问题？                         │
│  这个问题与哪些其他问题相关联？                               │
│  如何改进系统防止问题再发生？                                 │
├─────────────────────────────────────────────────────────────┤
│                 第一层：问题审视（直面问题）                    │
│                                                              │
│  具体发生了什么？事实是什么？                                  │
│  有什么证据？数据/反馈/现象？                                 │
│  造成了什么影响？对谁？                                       │
│  如何直接修复？                                              │
└─────────────────────────────────────────────────────────────┘
```

### 角色理论

**每个人在任何工作中都承担多个角色**：

| 角色类型 | 示例 | 典型责任 |
|----------|------|----------|
| **执行者** | 开发者、写作者、操作者 | 产出结果 |
| **审查者** | Reviewer、质检、测试 | 保证质量 |
| **协调者** | 管理者、Leader、中介 | 协调资源、做决策 |
| **服务者** | 服务提供方、供应商 | 满足需求方 |
| **需求方** | 用户、客户、老板 | 提出需求、验收结果 |

**常见角色冲突**：

| 冲突类型 | 表现 | 后果 |
|----------|------|------|
| 执行者 vs 审查者 | 自己做自己检查 | 质量把控不严 |
| 执行者 vs 协调者 | 既要干活又要管人 | 两头都做不好 |
| 服务者 vs 需求方 | 身份模糊 | 期望错位 |
| 多重执行者 | 同时做多个项目 | 精力分散 |

### 系统思维

**问题从不孤立，都在系统中**：

```
         环境（外部条件）
              │
              ▼
┌─────────────────────────────┐
│         系统                │
│  ┌─────┐   ┌─────┐   ┌─────┐│
│  │输入 │──▶│处理 │──▶│输出 ││
│  └─────┘   └─────┘   └─────┘│
│              │               │
│              ▼               │
│         反馈机制             │
└─────────────────────────────┘
```

**系统审视要点**：

| 要素 | 追问 |
|------|------|
| 输入 | 输入质量如何？是否有问题从输入就带入？ |
| 处理 | 处理逻辑是否正确？是否有遗漏？ |
| 输出 | 输出标准是否明确？如何衡量？ |
| 反馈 | 有没有反馈机制？反馈是否有效？ |
| 环境 | 环境有什么限制？是否合理？ |

### 认知偏差

**常见偏差及应对**：

| 偏差 | 表现 | 本 skill 应对 |
|------|------|---------------|
| 幸存者偏差 | 只看成功的，忽略失败的 | 要求列出失败案例 |
| 沉没成本 | 因投入而不愿放弃 | 问"如果从零开始，还会这样做吗？" |
| 锚定效应 | 被第一印象束缚 | 要求重新定义问题 |
| 可得性偏差 | 高估容易想到的 | 要求数据支撑 |
| 过度自信 | 高估自己的能力 | 引入外部视角评估 |

---

## 完整流程

### 流程总览

```
阶段1: 反思 (Reflect)
    │
    ├─ 1.1 定义反思范围
    ├─ 1.2 收集信息
    ├─ 1.3 第一层：问题审视
    ├─ 1.4 第二层：系统审视
    ├─ 1.5 第三层：角色审视
    └─ 输出：反思报告
          │
          ▼
阶段2: 计划 (Plan)
    │
    ├─ 2.1 第一层：直接修复方案
    ├─ 2.2 第二层：系统改进方案
    ├─ 2.3 第三层：自我改变方案
    ├─ 2.4 优先级排序
    └─ 输出：优化计划
          │
          ▼
阶段3: 执行 (Act)
    │
    ├─ 3.1 拆解为行动项
    ├─ 3.2 设定验收标准
    ├─ 3.3 逐项执行
    ├─ 3.4 记录结果
    └─ 输出：执行记录
          │
          ▼
阶段4: 验证 (Verify)
    │
    ├─ 4.1 问题解决检查
    ├─ 4.2 系统改进评估
    ├─ 4.3 自我改变评估
    ├─ 4.4 新问题发现
    └─ 输出：验证报告
          │
          ▼
阶段5: 固化 (Solidify)
    │
    ├─ 5.1 更新原则/标准
    ├─ 5.2 更新流程/规范
    ├─ 5.3 建立检查清单
    ├─ 5.4 传承给相关方
    └─ 输出：更新的文档/习惯
```

---

## 阶段1: 反思 (Reflect)

### 1.1 定义反思范围

**明确要反思什么**：

| 维度 | 问题 |
|------|------|
| 对象 | 要反思什么？（项目/任务/习惯/能力/某件事） |
| 触发 | 为什么现在反思？（反馈/问题/例行） |
| 期望 | 希望通过反思达到什么？ |
| 范围 | 反思的时间跨度？涉及的人/事？ |

**输出**：清晰的反思范围定义

### 1.2 收集信息

**信息收集清单**：

| 信息类型 | 收集方法 | 用途 |
|----------|----------|------|
| 事实 | 记录、日志、数据 | 确认发生了什么 |
| 结果 | 产出物、成果 | 评估效果 |
| 反馈 | 来自他人/用户/系统 | 外部视角 |
| 标准 | 预期目标、要求 | 对比差距 |
| 历史 | 之前类似情况 | 模式识别 |
| 我的决策 | 我做了什么选择 | 角色审视 |

**信息收集原则**：
- 重事实，轻主观
- 重数据，轻印象
- 重多方，轻单一

### 1.3 第一层：问题审视

**直面问题，不回避**

#### 问题清单

| # | 问题 | 证据 | 影响 | 紧急度 |
|---|------|------|------|--------|
| 1 | ... | ... | ... | 高/中/低 |
| 2 | ... | ... | ... | ... |

#### 问题追问清单

对每个问题追问：

```
1. 具体发生了什么？（描述事实，不含判断）
2. 你怎么知道这是个问题？（证据）
3. 对谁造成了什么影响？（利益相关者）
4. 如果不解决会怎样？（后果）
5. 类似问题之前发生过吗？（模式）
```

#### 常见问题模式

| 模式 | 特征 | 示例 |
|------|------|------|
| **质量不达标** | 结果不符合标准 | 测试通过但 bug 多 |
| **效率低下** | 投入产出比低 | 花了很长时间，效果一般 |
| **沟通不畅** | 信息传递有问题 | 需求理解偏差 |
| **资源不足** | 人/时间/工具不够 | 人力紧张导致质量下降 |
| **能力欠缺** | 不具备必要技能 | 新技术不会用 |
| **动机不足** | 缺乏动力/兴趣 | 拖延、敷衍 |

### 1.4 第二层：系统审视

**把问题放在系统中看**

#### 系统分析框架

```
┌─────────────────────────────────────────────────────────────┐
│                       环境                                   │
│   外部条件、约束、资源                                        │
├─────────────────────────────────────────────────────────────┤
│   输入 ───▶ 处理 ───▶ 输出                                   │
│              │                                               │
│              ▼                                               │
│           反馈                                               │
├─────────────────────────────────────────────────────────────┤
│                    机制/流程/规范                            │
└─────────────────────────────────────────────────────────────┘
```

#### 系统追问清单

```
1. 输入层面
   - 输入质量如何？问题是否从输入就带入了？
   - 输入标准是否明确？
   - 输入来源是否可靠？

2. 处理层面
   - 处理流程是否合理？有没有遗漏步骤？
   - 决策逻辑是否正确？
   - 是否有明确的检查点？

3. 输出层面
   - 输出标准是否明确？
   - 如何衡量输出质量？
   - 谁来验收输出？

4. 反馈层面
   - 有没有反馈机制？
   - 反馈是否及时？是否有效？
   - 反馈是否被采纳？

5. 机制层面
   - 有什么机制在控制这个过程？
   - 机制是否被执行？
   - 机制是否需要更新？

6. 环境层面
   - 有什么外部约束？
   - 资源是否充足？
   - 环境有什么变化？
```

#### 常见系统问题

| 问题类型 | 表现 | 根因 |
|----------|------|------|
| 机制缺失 | 该有的没有 | 制度设计不完善 |
| 机制失效 | 有但不执行 | 执行监督不到位 |
| 反馈断裂 | 反馈不被采纳 | 权责不对等 |
| 标准模糊 | 好坏难判断 | 缺乏明确标准 |
| 资源错配 | 投入与产出不匹配 | 规划不当 |

### 1.5 第三层：角色审视

**反求诸己——最终回到"我能改变什么"**

#### 角色识别

**我在这个情境中承担了哪些角色？**

| 角色 | 责任 | 我做到了吗？ |
|------|------|-------------|
| 执行者 | ... | ✅/⚠️/❌ |
| 审查者 | ... | ✅/⚠️/❌ |
| 协调者 | ... | ✅/⚠️/❌ |
| ... | ... | ... |

#### 角色冲突分析

| 冲突 | 表现 | 我如何处理的 | 更好的处理方式 |
|------|------|-------------|---------------|
| 执行者 vs 审查者 | ... | ... | ... |
| ... | ... | ... | ... |

#### 自我审视追问

```
心态层面：
1. 我是否把 [X] 放在 [Y] 之前？（如：进度 > 质量）
2. 我是否因为怕 [X] 而没有做 [Y]？（如：怕冲突而不批评）
3. 我是否满足于"看起来好"而没有追问"真的好吗"？
4. 我是否有 [X] 的心态导致了这个问题？

行为层面：
1. 我做了什么？没做什么？
2. 我是否执行了应该执行的标准/流程？
3. 我是否主动发现问题？还是被动等待？
4. 我是否有 [X] 的行为需要改变？

能力层面：
1. 我是否具备做好这件事的能力？
2. 我缺乏哪些知识/技能？
3. 我是否知道什么是"好"的标准？
4. 我需要提升哪些能力？
```

### 1.6 输出反思报告

**报告结构**：

```markdown
# [反思对象] 反思报告

## 元信息
- 反思时间：
- 反思范围：
- 触发原因：

## 第一层：问题审视
### 问题清单
### 问题分析

## 第二层：系统审视
### 系统分析
### 根因识别

## 第三层：角色审视
### 角色识别
### 角色冲突
### 自我问题

## 总结
- 核心问题：
- 根本原因：
- 我的关键问题：
```

---

## 阶段2: 计划 (Plan)

### 2.1 第一层方案：直接修复

**针对每个问题，制定直接修复方案**

| 问题 | 修复方案 | 具体做法 | 预期效果 | 时间 |
|------|----------|----------|----------|------|
| ... | ... | ... | ... | ... |

### 2.2 第二层方案：系统改进

**针对根因，改进机制/流程/环境**

| 根因 | 改进方案 | 涉及的机制 | 实施方式 |
|------|----------|-----------|----------|
| ... | ... | ... | ... |

**常见系统改进**：

| 改进类型 | 示例 |
|----------|------|
| 新增机制 | 增加审查环节、建立检查清单 |
| 强化执行 | 设置提醒、增加监督 |
| 明确标准 | 定义验收标准、建立度量 |
| 改善反馈 | 建立反馈渠道、缩短反馈周期 |
| 优化资源 | 重新分配、引入工具 |

### 2.3 第三层方案：自我改变

**针对我自己的问题，制定改变计划**

| 我的问题 | 改变方向 | 具体行动 | 固化方式 |
|----------|----------|----------|----------|
| 心态：... | ... | ... | 写入原则 |
| 行为：... | ... | ... | 写入检查清单 |
| 能力：... | ... | ... | 学习计划 |

### 2.4 优先级排序

**排序原则**：

| 优先级 | 条件 |
|--------|------|
| P0 立即 | 影响大、紧急、是其他改进的基础 |
| P1 本周 | 重要但不紧急 |
| P2 两周内 | 有价值但可延后 |
| P3 可选 | 有更好，没有也行 |

**依赖分析**：

```
哪些改进依赖其他改进？
哪些可以并行？
哪些必须串行？
```

### 2.5 输出优化计划

```markdown
# [反思对象] 优化计划

## 第一层：直接修复
| 序号 | 问题 | 方案 | 时间 |
|------|------|------|------|

## 第二层：系统改进
| 序号 | 根因 | 改进 | 涉及机制 |
|------|------|------|----------|

## 第三层：自我改变
| 序号 | 问题 | 改变 | 固化方式 |
|------|------|------|----------|

## 执行计划
### 时间线
### 优先级
### 依赖关系

## 成功指标
| 层级 | 指标 | 目标 |
|------|------|------|
| 第一层 | ... | ... |
| 第二层 | ... | ... |
| 第三层 | ... | ... |
```

---

## 阶段3: 执行 (Act)

### 3.1 拆解为行动项

**将方案拆解为可执行的具体行动**

| 行动项 | 目标 | 具体步骤 | 验收标准 | 时间 |
|--------|------|----------|----------|------|
| ... | ... | 1. ... | ... | ... |
| | | 2. ... | | |

### 3.2 执行与记录

**执行原则**：
- 按优先级执行
- 每个行动完成后立即记录
- 遇到阻塞不跳过，记录并处理
- 定期回顾进度

**执行记录格式**：

```markdown
## 执行日志

### [日期]

#### [行动项名称]
- 状态：✅ 完成 / 🔄 进行中 / ❌ 阻塞
- 结果：...
- 问题：...
- 下一步：...
```

---

## 阶段4: 验证 (Verify)

### 4.1 问题解决检查

| 问题 | 解决了吗？ | 证据 | 遗留 |
|------|-----------|------|------|
| ... | ✅/⚠️/❌ | ... | ... |

### 4.2 系统改进评估

| 改进 | 执行情况 | 效果 | 新问题 |
|------|----------|------|--------|
| ... | ... | ... | ... |

### 4.3 自我改变评估

| 改变 | 我真的改变了吗？ | 证据 | 还需努力 |
|------|-----------------|------|----------|
| 心态 | ... | ... | ... |
| 行为 | ... | ... | ... |
| 能力 | ... | ... | ... |

### 4.4 新问题发现

**追问**：
- 在解决问题的过程中，发现了什么新问题？
- 有什么之前没想到的？
- 下一步需要做什么？

### 4.5 输出验证报告

```markdown
# 验证报告

## 问题解决情况
## 系统改进评估
## 自我改变评估
## 新发现的问题
## 下一步行动
```

---

## 阶段5: 固化 (Solidify)

### 5.1 更新原则

**将新的认知固化为原则**

| 新认知 | 固化为原则 | 写入位置 |
|--------|-----------|----------|
| ... | "质量 > 进度" | SOUL.md / 个人笔记 |

### 5.2 更新流程

**将新的做法固化为流程**

| 新做法 | 固化为流程 | 涉及文档 |
|--------|-----------|----------|
| ... | 验收前执行检查清单 | SKILL.md / 工作规范 |

### 5.3 建立检查清单

**将标准固化为检查清单**

```markdown
# [场景] 检查清单

## 必查项
- [ ] ...
- [ ] ...

## 可选项
- [ ] ...
```

### 5.4 传承给相关方

**让改变影响更多人**

| 传承内容 | 传承对象 | 传承方式 |
|----------|----------|----------|
| ... | 团队/其他人 | 分享/文档/培训 |

---

## 使用示例

### 示例1：项目质量反思

**输入**：
```
反思一下上次项目的质量，用户说质量不行
```

**执行**：
```
三省吾身模式已激活 🔍

## 阶段1: 反思

### 第一层：问题审视
- 用户反馈"质量不行"
- 具体表现：测试全通过但 bug 多
- 证据：生产环境出现 5 个 bug

### 第二层：系统审视
- 测试只覆盖 Happy Path
- 没有对抗性测试
- 测试设计者 = 实现者

### 第三层：角色审视
- 我作为质量把关者，没有严格审查测试质量
- 我怕影响进度，放过了不够好的测试
- 心态问题：进度 > 质量

[继续生成反思报告...]
```

### 示例2：个人效率反思

**输入**：
```
反思一下我最近的工作效率，感觉很低
```

### 示例3：习惯养成反思

**输入**：
```
反思一下我的早起习惯，总是坚持不下来
```

---

## 注意事项

### 诚实原则

1. **不找借口** - 问题就是问题，不解释"为什么情有可原"
2. **不推卸责任** - 即使是外部原因，我也有我该承担的部分
3. **不自欺欺人** - "看起来好" ≠ "真的好"

### 深度原则

1. **追问三次** - 每个问题至少追问三次"为什么"
2. **找到根因** - 不止于表面原因，找到系统性和个人层面的原因
3. **反求诸己** - 最终都要回到"我能改变什么"

### 行动原则

1. **必须有行动** - 反思后不行动 = 白反思
2. **必须可执行** - 行动要具体、可操作、有验收标准
3. **必须有时限** - 每个行动要有预计完成时间

### 固化原则

1. **必须固化** - 改变必须形成文档或习惯，不能只在脑子里
2. **必须传承** - 有价值的改变要让相关方都知道
3. **必须复查** - 定期回顾固化内容是否执行

---

## 与其他 Skill 的关系

| Skill | 关系 |
|-------|------|
| self-improvement | self-reflection 是系统性深度审视，self-improvement 更偏单点改进 |
| verification-mindset | self-reflection 是事后深度反思，verification-mindset 是事中验证 |
| proactive-scan | self-reflection 是深度剖析，proactive-scan 是广度扫描 |
| task-continuity | self-reflection 可以发现需要持续跟踪的改进项 |

---

## 配置选项

| 配置 | 说明 | 默认值 |
|------|------|--------|
| 输出位置 | 反思报告等文件的存放位置 | 当前目录 docs/ |
| 周期提醒 | 是否启用定期自检提醒 | 关闭 |
| 深度模式 | 是否强制走完整5阶段 | 是 |

---

*版本：2.0.0*
*创建于 2026-02-25*
*基于角色理论、系统思维、认知偏差三大框架设计*
