# 三省吾身 (Self-Reflection)

> 深度自我审视与进化系统

## 核心价值

**不是简单的"想想哪里做得不好"，而是系统性的深度剖析**：

| 维度 | 普通反思 | 三省吾身 |
|------|----------|----------|
| 深度 | 停在表面 | 三层挖掘（问题→系统→自己） |
| 结构 | 零散 | 五阶段闭环 |
| 理论 | 无 | 角色理论 + 系统思维 + 认知偏差 |
| 行动 | 可能没有 | 必须有行动 + 固化 |

## 三层框架

```
第三层：角色审视（反求诸己）
  └─ 我承担了哪些角色？是否尽到责任？角色冲突？

第二层：系统审视（究其根源）
  └─ 什么机制/流程/环境导致了问题？

第一层：问题审视（直面问题）
  └─ 具体发生了什么？证据？影响？
```

## 五阶段闭环

```
反思 → 计划 → 执行 → 验证 → 固化
  ↑                         │
  └─────────────────────────┘
```

## 适用场景

| 场景 | 示例 |
|------|------|
| 项目复盘 | 项目结束后反思质量/效率/协作 |
| 负面反馈 | 收到批评后深度分析 |
| 重复错误 | 同类问题再次出现 |
| 能力提升 | 审视自己的短板 |
| 习惯养成 | 为什么坚持不下来 |
| 工作改进 | 效率低/质量差/沟通不畅 |

## 快速使用

```
反思一下 [某事]
三省吾身
审视一下 [某事]
复盘一下 [某事]
```

## 理论基础

### 角色理论
每个人在工作中都承担多个角色（执行者/审查者/协调者...），角色冲突是问题的常见根源。

### 系统思维
问题从不孤立，都在系统中有连锁反应。要改进系统，不只是修复表面问题。

### 认知偏差
自利偏差、确认偏差、现状偏见...这些心理机制让我们难以客观审视自己。本 skill 通过结构化流程克服这些障碍。

---

详见 [SKILL.md](./SKILL.md)
