# Self-Reflection Skill

> 三省吾身 - Deep Self-Reflection & Evolution System

## Core Value

**Not just "thinking about what went wrong", but systematic deep analysis**:

| Dimension | Ordinary Reflection | Self-Reflection Skill |
|-----------|---------------------|----------------------|
| Depth | Surface level | 3 layers (Problem → System → Self) |
| Structure | Scattered | 5-stage closed loop |
| Theory | None | Role Theory + Systems Thinking + Cognitive Biases |
| Action | Maybe none | Must have action + solidification |

## Three-Layer Framework

```
Layer 3: Role Reflection (反求诸己)
  └─ What roles do I play? Did I fulfill responsibilities? Role conflicts?

Layer 2: System Reflection (究其根源)
  └─ What mechanisms/processes/environment caused the problem?

Layer 1: Problem Reflection (直面问题)
  └─ What happened? Evidence? Impact?
```

## Five-Stage Closed Loop

```
Reflect → Plan → Act → Verify → Solidify
   ↑                            │
   └────────────────────────────┘
```

## Use Cases

| Scenario | Example |
|----------|---------|
| Project Review | Reflect on quality/efficiency/collaboration after project |
| Negative Feedback | Deep analysis after receiving criticism |
| Repeated Mistakes | Same issue appears again |
| Skill Improvement | Examine your weaknesses |
| Habit Formation | Why can't I stick to it? |
| Work Improvement | Low efficiency / poor quality / communication issues |

## Quick Start

Just say:
- "反思一下..." (Reflect on...)
- "三省吾身" (Examine myself)
- "审视一下..." (Review...)
- "复盘一下..." (Post-mortem...)

## Theoretical Foundation

### Role Theory
Everyone plays multiple roles in work (executor/reviewer/coordinator...). Role conflicts are common sources of problems.

### Systems Thinking
Problems are never isolated. They have chain reactions in systems. Improve the system, not just fix surface issues.

### Cognitive Biases
Self-serving bias, confirmation bias, status quo bias... These psychological mechanisms make it hard to objectively examine ourselves. This skill overcomes these barriers through structured processes.

---

See [SKILL.md](./SKILL.md) for full documentation.
