#!/bin/bash
# Buy K-Trendz lightstick token

CONFIG_FILE="$HOME/.config/ktrendz/config.json"
BASE_URL="https://k-trendz.com/api/bot"

# Get API key from config or environment
if [ -n "$KTRENDZ_API_KEY" ]; then
    API_KEY="$KTRENDZ_API_KEY"
elif [ -f "$CONFIG_FILE" ]; then
    API_KEY=$(cat "$CONFIG_FILE" | grep -o '"api_key": *"[^"]*"' | sed 's/"api_key": *"//' | sed 's/"$//')
else
    echo "✗ Not configured. Run ./scripts/setup.sh first"
    exit 1
fi

# Get artist name from argument
ARTIST="${1:-}"
if [ -z "$ARTIST" ]; then
    echo "Usage: ./scripts/buy.sh <artist_name>"
    echo ""
    echo "Available tokens:"
    echo "  RIIZE, IVE, BTS, Cortis, 'K-Trendz Supporters', 'All Day Project'"
    exit 1
fi

SLIPPAGE="${2:-5}"

echo ""
echo "🛒 Buying $ARTIST Token"
echo "========================"
echo ""

# First get price
echo "Fetching current price..."
PRICE_RESPONSE=$(curl -s -X POST "$BASE_URL/token-price" \
    -H "Content-Type: application/json" \
    -H "x-bot-api-key: $API_KEY" \
    -d "{\"artist_name\": \"$ARTIST\"}")

if echo "$PRICE_RESPONSE" | grep -q '"success":true'; then
    BUY_COST=$(echo "$PRICE_RESPONSE" | python3 -c "import sys,json; print(json.load(sys.stdin)['data']['buy_cost_usdc'])")
    echo "Buy cost: \$$BUY_COST USDC (+ ${SLIPPAGE}% slippage tolerance)"
else
    echo "✗ Could not fetch price"
    echo "$PRICE_RESPONSE"
    exit 1
fi

# Execute buy
echo ""
echo "Executing purchase..."

RESPONSE=$(curl -s -X POST "$BASE_URL/buy" \
    -H "Content-Type: application/json" \
    -H "x-bot-api-key: $API_KEY" \
    -d "{\"artist_name\": \"$ARTIST\", \"max_slippage_percent\": $SLIPPAGE}")

# Check for success
if echo "$RESPONSE" | grep -q '"success":true'; then
    echo ""
    echo "✅ Purchase Successful!"
    echo ""
    
    python3 << EOF
import json
data = json.loads('''$RESPONSE''')['data']
print(f"Token:      {data['artist_name']}")
print(f"Amount:     {data['amount']} token")
print(f"Cost:       \${data['total_cost_usdc']:.2f} USDC")
print(f"Tx Hash:    {data.get('tx_hash', 'pending')}")
print(f"")
print(f"Daily limit remaining: \${data.get('remaining_daily_limit', 'N/A')}")
EOF
else
    echo ""
    echo "✗ Purchase Failed"
    echo ""
    python3 -c "import json; d=json.loads('''$RESPONSE'''); print(d.get('error', d))" 2>/dev/null || echo "$RESPONSE"
    exit 1
fi

echo ""
