# K-Trendz Lightstick Trading

Trade K-pop artist lightstick tokens on the K-Trendz bonding curve market.

**Capability Summary:** Buy and sell K-pop fan tokens with real-time pricing, news signals, and bonding curve mechanics. Early buyers benefit from price appreciation as artist popularity grows.

## Prerequisites

Run `/ktrendz:setup` first to configure your API key:

- **K-Trendz API Key** (required): Contact K-Trendz team for provisioning

You can also set via environment variable:
- `KTRENDZ_API_KEY`

## Quick Start

```bash
# Setup (one-time)
/ktrendz:setup

# Check token price
/ktrendz:price RIIZE

# Buy a token
/ktrendz:buy RIIZE

# Sell a token
/ktrendz:sell RIIZE
```

## 🎯 Decision Tree

- **"What's the price of X?"** → `/ktrendz:price <artist>`
- **"Should I buy X?"** → Check price + news signals first
- **"Buy X token"** → `/ktrendz:buy <artist>`
- **"Sell X token"** → `/ktrendz:sell <artist>`
- **"What tokens are available?"** → See Available Tokens below

## Main Commands

### /ktrendz:setup

Collects and validates API key, stores securely.

```bash
./scripts/setup.sh
```

### /ktrendz:price

Get current price and trading signals for a token.

```bash
./scripts/price.sh RIIZE
```

**Output includes:**
- Current price (USDC)
- Buy cost / Sell refund
- 24h price change
- Trending score
- Recent news signals

**Decision Factors:**

| Signal | Meaning | Buy Signal |
|--------|---------|------------|
| `trending_score` rising | On-platform engagement up | ✅ Bullish |
| `price_change_24h` positive | Recent momentum | ✅ Trend continuation |
| `total_supply` low | Few holders | ✅ Early opportunity |
| `has_recent_news` true | Media coverage | ✅ Potential catalyst |

### /ktrendz:buy

Purchase 1 lightstick token.

```bash
./scripts/buy.sh RIIZE
```

**Constraints:**
- Maximum 1 token per transaction (bonding curve protection)
- $100/day limit per agent
- Same-block trades blocked (MEV protection)

### /ktrendz:sell

Sell 1 lightstick token.

```bash
./scripts/sell.sh RIIZE
```

## Available Tokens

| Artist | Token ID |
|--------|----------|
| K-Trendz Supporters | 12666454296509763493 |
| RIIZE | 7963681970480434413 |
| IVE | 4607865675402095874 |
| Cortis | 13766662462343366758 |
| BTS | 9138265216282739420 |
| All Day Project | 18115915419890895215 |

## Trading Strategy

This is a **bonding curve** market, not arbitrage:

1. **Buy when trending** - Rising scores + news = growing demand
2. **Buy early** - Lower supply = better curve position
3. **Monitor signals** - News often precedes on-platform activity
4. **Hold during growth** - Bonding curve rewards patient holders

## Fee Structure

| Action | Fee | Distribution |
|--------|-----|--------------|
| Buy | 3% | 2% Artist Fund, 1% Platform |
| Sell | 2% | Platform |

**Round-trip cost:** 5%

## Rate Limits

- **Daily Volume:** $100 USD per agent
- **Transaction Frequency:** Max 100 trades/day
- **Circuit Breaker:** Pauses if price moves >20% in 10 blocks

## Example Interactions

**User:** "What's RIIZE trading at?"

**You:**
1. Run `./scripts/price.sh RIIZE`
2. Report: "RIIZE is at $1.85 (+5.2% 24h). Trending score 1250 with 3 recent news articles. Buy cost: $1.91"

**User:** "Buy RIIZE for me"

**You:**
1. Confirm: "Buy 1 RIIZE token for ~$1.91?"
2. If yes, run `./scripts/buy.sh RIIZE`
3. Report: "Purchased 1 RIIZE for $1.91. Tx: 0x..."

**User:** "Should I sell my IVE?"

**You:**
1. Run `./scripts/price.sh IVE`
2. Check signals (price trend, news, trending score)
3. Advise based on data

## API Reference

Base URL: `https://k-trendz.com/api/bot/`

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/token-price` | POST | Get price + signals |
| `/buy` | POST | Purchase 1 token |
| `/sell` | POST | Sell 1 token |

## Files

- `SKILL.md` - This file
- `package.json` - Package metadata
- `scripts/setup.sh` - API key configuration
- `scripts/price.sh` - Get token price
- `scripts/buy.sh` - Buy token
- `scripts/sell.sh` - Sell token
