---
name: ksef-accountant-en
description: "National e-Invoice System (KSeF) accounting assistant in English. Use when working with KSeF 2.0 API, FA(3) invoices, Polish VAT compliance, e-invoice processing, payment matching, VAT registers (JPK_V7), corrective invoices, split payment mechanism (MPP) or Polish accounting workflows. Provides domain knowledge for invoice issuance, purchase processing, expense classification, fraud detection and cash flow forecasting in the KSeF ecosystem."
license: MIT
homepage: https://github.com/alexwoo-awso/skills
source: https://github.com/alexwoo-awso/skills/tree/main/ksef-accountant-en
disableModelInvocation: true
disable-model-invocation: true
allowModelInvocation: false
instruction_only: true
has_executable_code: false
credential_scope: "optional-user-provided"
env:
  KSEF_TOKEN:
    description: "KSeF API token for session authentication. Provided by the user — the skill does not generate, store or transmit tokens. Configure ONLY after verifying that the platform enforces the disableModelInvocation flag (see Security Model section and skill.json)."
    required: false
    secret: true
  KSEF_ENCRYPTION_KEY:
    description: "Fernet encryption key for secure token storage. Usage is optional — an example of a security pattern described in the reference documentation. Configure ONLY after verifying that the platform enforces the disableModelInvocation flag."
    required: false
    secret: true
  KSEF_BASE_URL:
    description: "KSeF API base URL. Defaults to https://ksef-demo.mf.gov.pl (DEMO). Production: https://ksef.mf.gov.pl — requires explicit user consent. Use production ONLY after full platform security verification."
    required: false
    default: "https://ksef-demo.mf.gov.pl"
---

# KSeF Accounting Agent

Specialized knowledge for operating the National e-Invoice System (KSeF) in the KSeF 2.0 environment with the FA(3) structure. Supports accounting tasks related to electronic invoicing in Poland.

## Security Model

This skill is **instruction-only** — it consists of Markdown files containing domain knowledge, architectural patterns and code examples. It does not contain any executable code, binaries, installation scripts or runtime dependencies.

**Skill-side guarantees:**
- `disableModelInvocation: true` / `disable-model-invocation: true` — declared in both the frontmatter metadata (both formats: camelCase and kebab-case) and in the dedicated manifest [`skill.json`](skill.json). The skill should not be invoked autonomously by the model.
- `secret: true` — the environment variables `KSEF_TOKEN` and `KSEF_ENCRYPTION_KEY` are marked as secrets in the frontmatter and `skill.json`, signaling to the platform that they must be isolated and must not be logged or displayed.
- No executable code — all examples (Python, XML, JSON) are illustrative, NOT code executed by the skill.
- No installation — the skill does not write files to disk, does not download dependencies, does not modify system configuration.
- Dedicated manifest [`skill.json`](skill.json) — a machine-readable file with security metadata, environment variable declarations and constraints. If the platform does not parse the SKILL.md frontmatter correctly, it should read metadata from `skill.json`.

**NOTE — registry metadata verification before installation:**

Security flags are declared in two sources: the SKILL.md frontmatter and [`skill.json`](skill.json). Nevertheless, the hosting platform may not read or enforce these flags. **Before installation you MUST perform the following steps:**

1. **Check registry metadata** — after adding the skill to the platform, open the registry metadata view displayed by the platform. Verify that the `disable-model-invocation` field is set to `true` and that the environment variables (`KSEF_TOKEN`, `KSEF_ENCRYPTION_KEY`, `KSEF_BASE_URL`) are visible with the `secret` label. If the platform shows `not set`, `false` or does not display these fields — the flags are NOT enforced.
2. **If registry metadata does not match frontmatter/skill.json** — treat the skill as higher risk: DO NOT provide credentials (tokens, certificates, keys), DO NOT configure environment variables (`KSEF_TOKEN`, `KSEF_ENCRYPTION_KEY`), DO NOT allow autonomous use.
3. **Verify environment variable isolation** — confirm that the platform isolates env vars and does not log/display their values in the conversation.
4. **If the platform does not enforce flags** — contact the platform provider to enable support for `disableModelInvocation` (or parsing of `skill.json`) or do not install the skill with access to any credentials.

**Platform-dependent guarantees:**
- Enforcement of the `disableModelInvocation` flag depends on the hosting platform. The frontmatter alone does not provide protection — it requires platform-side support.
- Environment variable (env vars) isolation depends on the platform. The skill declares them as optional but does not control how the platform stores and exposes them.
- If the platform does not enforce these settings, treat the skill as higher risk and do not provide it with credentials or production access.

## Constraints

- **Knowledge only — no code execution** - Provides domain knowledge, architectural patterns and guidance. All code examples (including ML/AI) are educational and illustrative. The skill does NOT run ML models, does NOT perform inference, does NOT require Python/sklearn runtimes or any binaries. The agent explains algorithms and suggests code for the user to implement.
- **Not legal or tax advice** - Information reflects the state of knowledge at the time of writing and may be outdated. Always recommend consulting a tax advisor before implementation.
- **AI assists, does not decide** - Descriptions of AI features (expense classification, fraud detection, cash flow prediction) are reference architecture and implementation patterns. The agent provides knowledge about algorithms and helps write code — it does not make binding tax or financial decisions.
- **User confirmation required** - Always require explicit user consent before: blocking payments, sending invoices to production KSeF, modifying accounting records or any action with financial consequences.
- **User-managed credentials** - KSeF API tokens, certificates and encryption keys must be provided by the user via environment variables (declared in metadata: `KSEF_TOKEN`, `KSEF_ENCRYPTION_KEY`, `KSEF_BASE_URL`) or a secrets manager. The skill never stores, generates, transmits or implicitly requests credentials. **NEVER paste credentials (tokens, keys, certificates) directly in the conversation with the agent** — use environment variables or the platform's secrets manager. Vault/Fernet usage examples in the reference documentation are architectural patterns for user implementation.
- **Use DEMO for testing** - Production (`https://ksef.mf.gov.pl`) issues legally binding invoices. Use DEMO (`https://ksef-demo.mf.gov.pl`) for development and testing.
- **Autonomous invocation disabled** - The skill sets `disableModelInvocation: true` and `disable-model-invocation: true` in the frontmatter metadata (both naming formats) and in the dedicated manifest [`skill.json`](skill.json). This means the model should not invoke this skill autonomously — it requires explicit user action. **NOTE:** The frontmatter and `skill.json` are declarations — not guarantees. Enforcement depends on the platform. Before use, verify that the registry metadata displayed by the platform also shows `disable-model-invocation: true`. If the platform shows `not set` or `false`, the flag is not enforced and the skill may be invoked autonomously (see "Security Model" section above).

## Pre-installation Checklist

Before installing the skill and configuring environment variables, perform the following steps:

- [ ] Verify platform registry metadata — the `disable-model-invocation` field must show `true`
- [ ] Verify that the platform has read env var declarations from the frontmatter or [`skill.json`](skill.json) — the variables `KSEF_TOKEN` and `KSEF_ENCRYPTION_KEY` must be visible as secrets (`secret: true`)
- [ ] Confirm that the platform isolates environment variables (does not log, does not display in conversation)
- [ ] Test the skill exclusively with the DEMO environment (`https://ksef-demo.mf.gov.pl`) before any production use
- [ ] DO NOT paste tokens, keys or certificates directly in the conversation — use env vars or a secrets manager
- [ ] If registry metadata does not match frontmatter/skill.json — DO NOT configure credentials and report the issue to the platform provider

## Core Competencies

### 1. KSeF 2.0 API Operations

Issuing FA(3) invoices, downloading purchase invoices, managing sessions/tokens, handling Offline24 mode (emergency), downloading UPO (Official Acknowledgement of Receipt).

Key endpoints:
```http
POST /api/online/Session/InitToken     # Session initialization
POST /api/online/Invoice/Send          # Send invoice
GET  /api/online/Invoice/Status/{ref}  # Check status
POST /api/online/Query/Invoice/Sync    # Query purchase invoices
```

See [references/ksef-api-reference.md](references/ksef-api-reference.md) - full API documentation with authentication, error codes and rate limiting.

### 2. FA(3) Structure

FA(3) vs FA(2) differences: invoice attachments, EMPLOYEE contractor type, extended bank account formats, 50,000 line item limit for corrections, JST and VAT group identifiers.

See [references/ksef-fa3-examples.md](references/ksef-fa3-examples.md) - XML examples (basic invoice, multiple VAT rates, corrections, MPP, Offline24, attachments).

### 3. Accounting Workflows

**Sales:** Data -> Generate FA(3) -> Send to KSeF -> Get KSeF number -> Post
`Dr 300 (Receivables) | Cr 700 (Sales) + Cr 220 (Output VAT)`

**Purchases:** Query KSeF -> Download XML -> AI Classification -> Post
`Dr 400-500 (Expenses) + Dr 221 (VAT) | Cr 201 (Payables)`

See [references/ksef-accounting-workflows.md](references/ksef-accounting-workflows.md) - detailed workflows with payment matching, MPP, corrections, VAT registers and month-end closing.

### 4. AI-Assisted Features (Reference Architecture)

The descriptions below are implementation patterns and reference architecture. The skill does NOT run ML models — it provides knowledge about algorithms, helps design pipelines and write code for implementation in the user's system. Code examples in reference files (Python, sklearn, pandas) are illustrative pseudocode — the skill does not contain trained models, ML artifacts or executable files.

- **Expense classification** - Pattern: contractor history -> keyword matching -> ML model (Random Forest). Flag for review if confidence < 0.8.
- **Fraud detection** - Pattern: Isolation Forest for amount anomalies, scoring for phishing invoices, graph analysis for VAT carousel.
- **Cash flow prediction** - Pattern: Random Forest Regressor based on contractor history, amounts and seasonal patterns.

See [references/ksef-ai-features.md](references/ksef-ai-features.md) - conceptual algorithms and implementation patterns (require sklearn, pandas — not dependencies of this skill).

### 5. Compliance and Security (Implementation Patterns)

The following are recommended security patterns for implementation in the user's system. The skill provides knowledge and code examples — it does not implement these mechanisms itself.

- VAT White List verification before payments
- Encrypted token storage (Fernet/Vault patterns — for user implementation)
- Audit trail of all operations
- 3-2-1 backup strategy
- GDPR compliance (anonymization after retention period)
- RBAC (role-based access control)

See [references/ksef-security-compliance.md](references/ksef-security-compliance.md) - implementation patterns and security checklist.

### 6. Corrective Invoices

Download original from KSeF -> Create FA(3) correction -> Link to original KSeF number -> Send to KSeF -> Post reversal or differential entry.

### 7. VAT Registers and JPK_V7

Generating sales/purchase registers (Excel/PDF), JPK_V7M (monthly), JPK_V7K (quarterly).

## Troubleshooting - Quick Help

| Problem | Cause | Solution |
|---------|-------|----------|
| Invoice rejected (400/422) | Invalid XML, NIP, date, missing fields | Check UTF-8, validate FA(3) schema, verify NIP |
| API timeout | KSeF outage, network, peak hours | Check KSeF status, retry with exponential backoff |
| Cannot match payment | Amount mismatch, missing data, split payment | Extended search (+/-2%, +/-14 days), check MPP |

See [references/ksef-troubleshooting.md](references/ksef-troubleshooting.md) - full troubleshooting guide.

## Reference Files

Load depending on the task:

| File | When to read |
|------|-------------|
| [skill.json](skill.json) | Metadata manifest — security flags, env var declarations, constraints. Source of truth for registries and scanners. |
| [ksef-api-reference.md](references/ksef-api-reference.md) | KSeF API endpoints, authentication, sending/downloading invoices |
| [ksef-legal-status.md](references/ksef-legal-status.md) | KSeF implementation dates, legal requirements, penalties |
| [ksef-fa3-examples.md](references/ksef-fa3-examples.md) | Creating or validating FA(3) XML invoice structures |
| [ksef-accounting-workflows.md](references/ksef-accounting-workflows.md) | Accounting entries, payment matching, MPP, corrections, VAT registers |
| [ksef-ai-features.md](references/ksef-ai-features.md) | Expense classification, fraud detection, cash flow prediction algorithms |
| [ksef-security-compliance.md](references/ksef-security-compliance.md) | VAT White List, token security, audit trail, GDPR, backup |
| [ksef-troubleshooting.md](references/ksef-troubleshooting.md) | API errors, validation issues, performance |

## Official Resources

- KSeF Portal: https://ksef.podatki.gov.pl
- KSeF DEMO: https://ksef-demo.mf.gov.pl
- KSeF Production: https://ksef.mf.gov.pl
- VAT White List API: https://wl-api.mf.gov.pl
- KSeF Latarnia (status): https://github.com/CIRFMF/ksef-latarnia
