# Decision Framework

## Quick Assessment (3-Step Method)

A rapid screening method to evaluate any token in under 60 seconds:

1. **Concentration check:** Is cluster holding ratio > 30-40%? If no, skip (no clear major holder).
2. **Developer check:** Has the developer cluster exited? If still holding large position, high risk -- skip unless other signals are overwhelming.
3. **Trend check:** Is cluster holding % rising or falling over 1d/7d? Rising = accumulation, falling = distribution. Only proceed if accumulating.

If all 3 steps pass, proceed to the detailed checklist below.

## Bullish Checklist (All should be true for high-conviction entry)

- [ ] Market cap >= $500K
- [ ] Cluster holding ratio >= 30% and **rising** (positive changes across 1h, 4h, 1d)
- [ ] Smart money or whale clusters are increasing positions
- [ ] Developer cluster has **exited** or holds < 5%
- [ ] Sniper positions have been **cleared**
- [ ] Bundle transaction holders have **cleared**
- [ ] No high proportion of new wallets or high-frequency traders
- [ ] Price near or below cluster average buy price (support zone)

## Bearish Signals (Any one is a warning)

- Price rising but cluster holding % declining (distribution)
- Smart money holdings decreasing
- Developer still holds large low-cost position
- Sniper positions NOT cleared (sell pressure overhead)
- High-frequency traders dominate holder composition
- Signal triggered but cluster ratio quickly drops back (bull trap)

## Estimating Fund Inflow

A useful heuristic for quantifying accumulation:

```
Net fund inflow ~= Market cap x Cluster holding % increase
```

Example: If a token has $2M market cap and cluster holding increased by 5% over 24h:
- Estimated inflow = $2M x 0.05 = $100K net buying by clusters

This helps gauge the magnitude of accumulation -- are clusters putting in meaningful capital or just nibbling?

## Entry Strategies

| Strategy | When to Use | Entry Logic |
|----------|-------------|-------------|
| **Signal-driven** | Phase 2 signal fires + cluster % still rising | Enter on signal confirmation with 2-3% position |
| **Accumulation breakout** | Cluster % rising >5% in 24h + price consolidating | Enter before breakout with 3-5% position |
| **Support defense** | Price at cluster avg buy + holding ratio rising | Enter at support with 2-3% position, tight stop |
| **Dip buying** | Price drops 20%+ but cluster % holds or rises | Clusters defending = strong hands, enter 2-3% |

## Exit Strategies

| Signal | Action |
|--------|--------|
| Cluster % drops >5% in 4h while price stable/rising | Reduce 50% -- distribution starting |
| Smart money labels start appearing in sell-side | Close position -- smart money exiting |
| Developer addresses activate and start selling | Close immediately -- insider dumping |
| Price hits 2x entry with cluster % declining | Take profit on 50-75% of position |
| Price drops 30% from entry | Stop loss -- cut entire position |
