---
name: Korean
description: Write Korean that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Korean is technically correct but sounds off. Too formal. Too textbook. Too stiff. Natives write with contractions, particles, and casual endings. Match that.

## Formality Default

Default register is too high. Casual Korean is the norm online. Unless explicitly formal: lean casual. 반말 is normal among peers. 존댓말 isn't always needed.

## Speech Levels

Know the levels:
- 합쇼체 (-습니다): very formal, news, presentations
- 해요체 (-아/어요): polite, safe default, strangers
- 해체/반말 (-아/어): casual, friends, peers
- Online/texting: mostly 반말 or 해요체
- Don't mix levels awkwardly

## Contractions

Casual Korean contracts heavily:
- 하는 것 → 하는 거
- 무엇 → 뭐
- 그것 → 그거
- 나는 → 난
- 너는 → 넌
- 것이 → 게
- 아니야 → 아냐

## Sentence Endings

These add nuance:
- ㅋㅋㅋ: laughter (more ㅋ = funnier)
- ㅎㅎ: softer laugh
- ㅠㅠ/ㅜㅜ: crying, sad
- ~: softening (밥 먹었어~)
- ㄱㄱ: 고고 (let's go)
- ㅇㅇ: 응응 (yeah yeah)

## Particles

Don't over-formal particles:
- 을/를 often dropped in casual speech
- 이/가 often dropped too
- 은/는 sometimes dropped
- Keep when needed for clarity

## Fillers & Flow

Real Korean has fillers:
- 음, 어, 그
- 아니 (sentence starter)
- 근데, 그래서, 그러니까
- 막, 좀, 되게
- 진짜, 완전, 레알

## Expressiveness

Don't pick the safe word:
- 좋다 → 대박, 미쳤다, 쩐다
- 나쁘다 → 별로, 최악, 구리다
- 많이 → 완전, 개, 존나 (crude)
- 예쁘다 → 이쁘다, 존예

## Internet Slang

Modern Korean uses:
- ㅋㅋㅋ, ㄹㅇ (레알/리얼)
- 개 (intensifier): 개웃김, 개맛있어
- 존나 (crude intensifier)
- 헐, 대박, 미쳤다
- 인정, 공감
- ㄴㄴ (노노), ㅇㅋ (오케이)

## Common Expressions

Natural expressions:
- 알겠어/알았어, ㅇㅇ
- 뭐해?, 밥 먹었어?
- 그치?, 맞아맞아
- 별로야, 그냥 그래
- 대박, 헐, 미쳤다

## Reactions

React naturally:
- 진짜?, 헐, 대박
- 미쳤어?, 뭐야?
- ㅋㅋㅋㅋ, ㅎㅎㅎ
- 아 ㅋㅋ, 엌ㅋㅋ
- 슬프다 ㅠㅠ, 귀여워 ㅠㅠ

## Aegyo/Cute Writing

Common in casual contexts:
- 네 → 넹, 넵
- 응 → 웅
- 안녕 → 안뇽
- Adding ㅎ: 좋아용, 고마워용
- Use appropriately for context

## The "Native Test"

Before sending: would a Korean screenshot this as "AI-generated"? If yes—too formal, missing ㅋㅋ, no contractions. Casualize.
