#!/usr/bin/env python3
"""Generate airports.json with top 500 airports. Run once to create reference data."""
import json

airports = [
    {"iata":"ATL","name":"Hartsfield-Jackson Atlanta International","city":"Atlanta","country":"US","coordinates":[33.6407,-84.4277]},
    {"iata":"DXB","name":"Dubai International","city":"Dubai","country":"AE","coordinates":[25.2532,55.3657]},
    {"iata":"DFW","name":"Dallas/Fort Worth International","city":"Dallas","country":"US","coordinates":[32.8998,-97.0403]},
    {"iata":"DEN","name":"Denver International","city":"Denver","country":"US","coordinates":[39.8561,-104.6737]},
    {"iata":"ORD","name":"O'Hare International","city":"Chicago","country":"US","coordinates":[41.9742,-87.9073]},
    {"iata":"LAX","name":"Los Angeles International","city":"Los Angeles","country":"US","coordinates":[33.9425,-118.4081]},
    {"iata":"IST","name":"Istanbul Airport","city":"Istanbul","country":"TR","coordinates":[41.2753,28.7519]},
    {"iata":"LHR","name":"Heathrow","city":"London","country":"GB","coordinates":[51.4700,-0.4543]},
    {"iata":"JFK","name":"John F. Kennedy International","city":"New York","country":"US","coordinates":[40.6413,-73.7781]},
    {"iata":"CDG","name":"Charles de Gaulle","city":"Paris","country":"FR","coordinates":[49.0097,2.5479]},
    {"iata":"AMS","name":"Schiphol","city":"Amsterdam","country":"NL","coordinates":[52.3086,4.7639]},
    {"iata":"DEL","name":"Indira Gandhi International","city":"New Delhi","country":"IN","coordinates":[28.5562,77.1000]},
    {"iata":"CAN","name":"Guangzhou Baiyun","city":"Guangzhou","country":"CN","coordinates":[23.3924,113.2988]},
    {"iata":"FRA","name":"Frankfurt","city":"Frankfurt","country":"DE","coordinates":[50.0379,8.5622]},
    {"iata":"SIN","name":"Changi","city":"Singapore","country":"SG","coordinates":[1.3644,103.9915]},
    {"iata":"HND","name":"Haneda","city":"Tokyo","country":"JP","coordinates":[35.5494,139.7798]},
    {"iata":"PEK","name":"Beijing Capital","city":"Beijing","country":"CN","coordinates":[40.0799,116.6031]},
    {"iata":"BKK","name":"Suvarnabhumi","city":"Bangkok","country":"TH","coordinates":[13.6900,100.7501]},
    {"iata":"ICN","name":"Incheon International","city":"Seoul","country":"KR","coordinates":[37.4602,126.4407]},
    {"iata":"SFO","name":"San Francisco International","city":"San Francisco","country":"US","coordinates":[37.6213,-122.3790]},
    {"iata":"SEA","name":"Seattle-Tacoma International","city":"Seattle","country":"US","coordinates":[47.4502,-122.3088]},
    {"iata":"MCO","name":"Orlando International","city":"Orlando","country":"US","coordinates":[28.4312,-81.3081]},
    {"iata":"MIA","name":"Miami International","city":"Miami","country":"US","coordinates":[25.7959,-80.2870]},
    {"iata":"CLT","name":"Charlotte Douglas International","city":"Charlotte","country":"US","coordinates":[35.2140,-80.9431]},
    {"iata":"EWR","name":"Newark Liberty International","city":"Newark","country":"US","coordinates":[40.6895,-74.1745]},
    {"iata":"PHX","name":"Phoenix Sky Harbor","city":"Phoenix","country":"US","coordinates":[33.4373,-112.0078]},
    {"iata":"IAH","name":"George Bush Intercontinental","city":"Houston","country":"US","coordinates":[29.9902,-95.3368]},
    {"iata":"LAS","name":"Harry Reid International","city":"Las Vegas","country":"US","coordinates":[36.0840,-115.1537]},
    {"iata":"MSP","name":"Minneapolis-Saint Paul","city":"Minneapolis","country":"US","coordinates":[44.8848,-93.2223]},
    {"iata":"DTW","name":"Detroit Metropolitan","city":"Detroit","country":"US","coordinates":[42.2124,-83.3534]},
    {"iata":"BOS","name":"Boston Logan International","city":"Boston","country":"US","coordinates":[42.3656,-71.0096]},
    {"iata":"PHL","name":"Philadelphia International","city":"Philadelphia","country":"US","coordinates":[39.8721,-75.2411]},
    {"iata":"FLL","name":"Fort Lauderdale-Hollywood","city":"Fort Lauderdale","country":"US","coordinates":[26.0726,-80.1527]},
    {"iata":"BWI","name":"Baltimore/Washington International","city":"Baltimore","country":"US","coordinates":[39.1754,-76.6683]},
    {"iata":"SLC","name":"Salt Lake City International","city":"Salt Lake City","country":"US","coordinates":[40.7884,-111.9778]},
    {"iata":"IAD","name":"Washington Dulles International","city":"Washington","country":"US","coordinates":[38.9531,-77.4565]},
    {"iata":"DCA","name":"Ronald Reagan Washington National","city":"Washington","country":"US","coordinates":[38.8512,-77.0402]},
    {"iata":"SAN","name":"San Diego International","city":"San Diego","country":"US","coordinates":[32.7336,-117.1897]},
    {"iata":"TPA","name":"Tampa International","city":"Tampa","country":"US","coordinates":[27.9755,-82.5332]},
    {"iata":"PDX","name":"Portland International","city":"Portland","country":"US","coordinates":[45.5898,-122.5951]},
    {"iata":"HNL","name":"Daniel K. Inouye International","city":"Honolulu","country":"US","coordinates":[21.3245,-157.9251]},
    {"iata":"STL","name":"St. Louis Lambert International","city":"St. Louis","country":"US","coordinates":[38.7487,-90.3700]},
    {"iata":"AUS","name":"Austin-Bergstrom International","city":"Austin","country":"US","coordinates":[30.1975,-97.6664]},
    {"iata":"BNA","name":"Nashville International","city":"Nashville","country":"US","coordinates":[36.1263,-86.6774]},
    {"iata":"RDU","name":"Raleigh-Durham International","city":"Raleigh","country":"US","coordinates":[35.8801,-78.7880]},
    {"iata":"MDW","name":"Chicago Midway","city":"Chicago","country":"US","coordinates":[41.7868,-87.7522]},
    {"iata":"SJC","name":"San José International","city":"San Jose","country":"US","coordinates":[37.3626,-121.9291]},
    {"iata":"DAL","name":"Dallas Love Field","city":"Dallas","country":"US","coordinates":[32.8471,-96.8518]},
    {"iata":"OAK","name":"Oakland International","city":"Oakland","country":"US","coordinates":[37.7213,-122.2208]},
    {"iata":"RSW","name":"Southwest Florida International","city":"Fort Myers","country":"US","coordinates":[26.5362,-81.7552]},
    {"iata":"YYZ","name":"Toronto Pearson International","city":"Toronto","country":"CA","coordinates":[43.6777,-79.6248]},
    {"iata":"YVR","name":"Vancouver International","city":"Vancouver","country":"CA","coordinates":[49.1967,-123.1815]},
    {"iata":"YUL","name":"Montréal-Trudeau International","city":"Montréal","country":"CA","coordinates":[45.4706,-73.7408]},
    {"iata":"YYC","name":"Calgary International","city":"Calgary","country":"CA","coordinates":[51.1215,-114.0076]},
    {"iata":"YOW","name":"Ottawa Macdonald-Cartier","city":"Ottawa","country":"CA","coordinates":[45.3225,-75.6692]},
    {"iata":"YEG","name":"Edmonton International","city":"Edmonton","country":"CA","coordinates":[53.3097,-113.5800]},
    {"iata":"YHZ","name":"Halifax Stanfield International","city":"Halifax","country":"CA","coordinates":[44.8808,-63.5086]},
    {"iata":"YWG","name":"Winnipeg James Armstrong Richardson","city":"Winnipeg","country":"CA","coordinates":[49.9100,-97.2399]},
    {"iata":"MEX","name":"Benito Juárez International","city":"Mexico City","country":"MX","coordinates":[19.4363,-99.0721]},
    {"iata":"CUN","name":"Cancún International","city":"Cancún","country":"MX","coordinates":[21.0365,-86.8771]},
    {"iata":"GDL","name":"Guadalajara International","city":"Guadalajara","country":"MX","coordinates":[20.5218,-103.3113]},
    {"iata":"GRU","name":"São Paulo-Guarulhos","city":"São Paulo","country":"BR","coordinates":[-23.4356,-46.4731]},
    {"iata":"GIG","name":"Rio de Janeiro-Galeão","city":"Rio de Janeiro","country":"BR","coordinates":[-22.8100,-43.2506]},
    {"iata":"BSB","name":"Brasília International","city":"Brasília","country":"BR","coordinates":[-15.8711,-47.9186]},
    {"iata":"EZE","name":"Ministro Pistarini International","city":"Buenos Aires","country":"AR","coordinates":[-34.8222,-58.5358]},
    {"iata":"SCL","name":"Arturo Merino Benítez International","city":"Santiago","country":"CL","coordinates":[-33.3930,-70.7858]},
    {"iata":"LIM","name":"Jorge Chávez International","city":"Lima","country":"PE","coordinates":[-12.0219,-77.1143]},
    {"iata":"BOG","name":"El Dorado International","city":"Bogotá","country":"CO","coordinates":[4.7016,-74.1469]},
    {"iata":"PTY","name":"Tocumen International","city":"Panama City","country":"PA","coordinates":[9.0714,-79.3835]},
    {"iata":"SJO","name":"Juan Santamaría International","city":"San José","country":"CR","coordinates":[9.9939,-84.2088]},
    {"iata":"UIO","name":"Mariscal Sucre International","city":"Quito","country":"EC","coordinates":[-0.1292,-78.3575]},
    {"iata":"CTG","name":"Rafael Núñez International","city":"Cartagena","country":"CO","coordinates":[10.4424,-75.5130]},
    {"iata":"LGW","name":"Gatwick","city":"London","country":"GB","coordinates":[51.1537,-0.1821]},
    {"iata":"STN","name":"Stansted","city":"London","country":"GB","coordinates":[51.8860,0.2389]},
    {"iata":"LTN","name":"Luton","city":"London","country":"GB","coordinates":[51.8747,-0.3683]},
    {"iata":"MAN","name":"Manchester","city":"Manchester","country":"GB","coordinates":[53.3537,-2.2750]},
    {"iata":"EDI","name":"Edinburgh","city":"Edinburgh","country":"GB","coordinates":[55.9500,-3.3725]},
    {"iata":"BHX","name":"Birmingham","city":"Birmingham","country":"GB","coordinates":[52.4539,-1.7480]},
    {"iata":"GLA","name":"Glasgow","city":"Glasgow","country":"GB","coordinates":[55.8642,-4.4331]},
    {"iata":"BRS","name":"Bristol","city":"Bristol","country":"GB","coordinates":[51.3827,-2.7191]},
    {"iata":"ORY","name":"Paris Orly","city":"Paris","country":"FR","coordinates":[48.7262,2.3652]},
    {"iata":"NCE","name":"Nice Côte d'Azur","city":"Nice","country":"FR","coordinates":[43.6584,7.2159]},
    {"iata":"LYS","name":"Lyon-Saint Exupéry","city":"Lyon","country":"FR","coordinates":[45.7256,5.0811]},
    {"iata":"MRS","name":"Marseille Provence","city":"Marseille","country":"FR","coordinates":[43.4393,5.2214]},
    {"iata":"TLS","name":"Toulouse-Blagnac","city":"Toulouse","country":"FR","coordinates":[43.6291,1.3638]},
    {"iata":"MUC","name":"Munich","city":"Munich","country":"DE","coordinates":[48.3538,11.7861]},
    {"iata":"TXL","name":"Berlin Brandenburg","city":"Berlin","country":"DE","coordinates":[52.3667,13.5033]},
    {"iata":"HAM","name":"Hamburg","city":"Hamburg","country":"DE","coordinates":[53.6304,9.9882]},
    {"iata":"DUS","name":"Düsseldorf","city":"Düsseldorf","country":"DE","coordinates":[51.2895,6.7668]},
    {"iata":"CGN","name":"Cologne Bonn","city":"Cologne","country":"DE","coordinates":[50.8659,7.1427]},
    {"iata":"MAD","name":"Adolfo Suárez Madrid-Barajas","city":"Madrid","country":"ES","coordinates":[40.4983,-3.5676]},
    {"iata":"BCN","name":"Barcelona-El Prat","city":"Barcelona","country":"ES","coordinates":[41.2971,2.0785]},
    {"iata":"PMI","name":"Palma de Mallorca","city":"Palma","country":"ES","coordinates":[39.5517,2.7388]},
    {"iata":"AGP","name":"Málaga-Costa del Sol","city":"Málaga","country":"ES","coordinates":[36.6749,-4.4991]},
    {"iata":"ALC","name":"Alicante-Elche","city":"Alicante","country":"ES","coordinates":[38.2822,-0.5582]},
    {"iata":"SVQ","name":"Seville","city":"Seville","country":"ES","coordinates":[37.4180,-5.8931]},
    {"iata":"FCO","name":"Leonardo da Vinci-Fiumicino","city":"Rome","country":"IT","coordinates":[41.8003,12.2389]},
    {"iata":"MXP","name":"Milan Malpensa","city":"Milan","country":"IT","coordinates":[45.6306,8.7281]},
    {"iata":"VCE","name":"Venice Marco Polo","city":"Venice","country":"IT","coordinates":[45.5053,12.3519]},
    {"iata":"NAP","name":"Naples International","city":"Naples","country":"IT","coordinates":[40.8860,14.2908]},
    {"iata":"FLR","name":"Florence Peretola","city":"Florence","country":"IT","coordinates":[43.8100,11.2051]},
    {"iata":"BGY","name":"Milan Bergamo","city":"Milan","country":"IT","coordinates":[45.6739,9.7042]},
    {"iata":"LIS","name":"Humberto Delgado","city":"Lisbon","country":"PT","coordinates":[38.7813,-9.1359]},
    {"iata":"OPO","name":"Francisco Sá Carneiro","city":"Porto","country":"PT","coordinates":[41.2481,-8.6814]},
    {"iata":"FAO","name":"Faro","city":"Faro","country":"PT","coordinates":[37.0144,-7.9659]},
    {"iata":"ZRH","name":"Zurich","city":"Zurich","country":"CH","coordinates":[47.4647,8.5492]},
    {"iata":"GVA","name":"Geneva","city":"Geneva","country":"CH","coordinates":[46.2381,6.1089]},
    {"iata":"VIE","name":"Vienna International","city":"Vienna","country":"AT","coordinates":[48.1103,16.5697]},
    {"iata":"BRU","name":"Brussels","city":"Brussels","country":"BE","coordinates":[50.9014,4.4844]},
    {"iata":"DUB","name":"Dublin","city":"Dublin","country":"IE","coordinates":[53.4264,-6.2499]},
    {"iata":"CPH","name":"Copenhagen Kastrup","city":"Copenhagen","country":"DK","coordinates":[55.6180,12.6508]},
    {"iata":"ARN","name":"Stockholm Arlanda","city":"Stockholm","country":"SE","coordinates":[59.6519,17.9186]},
    {"iata":"OSL","name":"Oslo Gardermoen","city":"Oslo","country":"NO","coordinates":[60.1976,11.1004]},
    {"iata":"HEL","name":"Helsinki-Vantaa","city":"Helsinki","country":"FI","coordinates":[60.3172,24.9633]},
    {"iata":"KEF","name":"Keflavík International","city":"Reykjavik","country":"IS","coordinates":[63.9850,-22.6056]},
    {"iata":"WAW","name":"Warsaw Chopin","city":"Warsaw","country":"PL","coordinates":[52.1657,20.9671]},
    {"iata":"PRG","name":"Václav Havel Prague","city":"Prague","country":"CZ","coordinates":[50.1008,14.2600]},
    {"iata":"BUD","name":"Budapest Ferenc Liszt","city":"Budapest","country":"HU","coordinates":[47.4369,19.2556]},
    {"iata":"OTP","name":"Henri Coandă International","city":"Bucharest","country":"RO","coordinates":[44.5711,26.0850]},
    {"iata":"SOF","name":"Sofia","city":"Sofia","country":"BG","coordinates":[42.6952,23.4114]},
    {"iata":"ZAG","name":"Franjo Tuđman","city":"Zagreb","country":"HR","coordinates":[45.7430,16.0688]},
    {"iata":"DBV","name":"Dubrovnik","city":"Dubrovnik","country":"HR","coordinates":[42.5614,18.2682]},
    {"iata":"SPU","name":"Split","city":"Split","country":"HR","coordinates":[43.5389,16.2980]},
    {"iata":"ATH","name":"Athens International","city":"Athens","country":"GR","coordinates":[37.9364,23.9445]},
    {"iata":"JTR","name":"Santorini (Thira)","city":"Santorini","country":"GR","coordinates":[36.3992,25.4793]},
    {"iata":"JMK","name":"Mykonos","city":"Mykonos","country":"GR","coordinates":[37.4351,25.3481]},
    {"iata":"HER","name":"Heraklion","city":"Heraklion","country":"GR","coordinates":[35.3397,25.1803]},
    {"iata":"TLL","name":"Tallinn","city":"Tallinn","country":"EE","coordinates":[59.4133,24.8328]},
    {"iata":"RIX","name":"Riga International","city":"Riga","country":"LV","coordinates":[56.9236,23.9711]},
    {"iata":"VNO","name":"Vilnius","city":"Vilnius","country":"LT","coordinates":[54.6341,25.2858]},
    {"iata":"LJU","name":"Ljubljana Jože Pučnik","city":"Ljubljana","country":"SI","coordinates":[46.2237,14.4576]},
    {"iata":"TGD","name":"Podgorica","city":"Podgorica","country":"ME","coordinates":[42.3594,19.2519]},
    {"iata":"TIV","name":"Tivat","city":"Tivat","country":"ME","coordinates":[42.4047,18.7233]},
    {"iata":"SJJ","name":"Sarajevo International","city":"Sarajevo","country":"BA","coordinates":[43.8246,18.3315]},
    {"iata":"TIA","name":"Tirana International","city":"Tirana","country":"AL","coordinates":[41.4147,19.7206]},
    {"iata":"SKG","name":"Thessaloniki","city":"Thessaloniki","country":"GR","coordinates":[40.5197,22.9709]},
    {"iata":"NRT","name":"Narita International","city":"Tokyo","country":"JP","coordinates":[35.7720,140.3929]},
    {"iata":"KIX","name":"Kansai International","city":"Osaka","country":"JP","coordinates":[34.4347,135.2441]},
    {"iata":"CTS","name":"New Chitose","city":"Sapporo","country":"JP","coordinates":[42.7752,141.6924]},
    {"iata":"FUK","name":"Fukuoka","city":"Fukuoka","country":"JP","coordinates":[33.5859,130.4511]},
    {"iata":"NGO","name":"Chubu Centrair International","city":"Nagoya","country":"JP","coordinates":[34.8584,136.8125]},
    {"iata":"OKA","name":"Naha","city":"Okinawa","country":"JP","coordinates":[26.1958,127.6459]},
    {"iata":"PVG","name":"Shanghai Pudong","city":"Shanghai","country":"CN","coordinates":[31.1443,121.8083]},
    {"iata":"SHA","name":"Shanghai Hongqiao","city":"Shanghai","country":"CN","coordinates":[31.1979,121.3363]},
    {"iata":"HKG","name":"Hong Kong International","city":"Hong Kong","country":"CN","coordinates":[22.3080,113.9185]},
    {"iata":"TPE","name":"Taiwan Taoyuan International","city":"Taipei","country":"TW","coordinates":[25.0797,121.2342]},
    {"iata":"GMP","name":"Gimpo International","city":"Seoul","country":"KR","coordinates":[37.5583,126.7906]},
    {"iata":"PUS","name":"Gimhae International","city":"Busan","country":"KR","coordinates":[35.1796,128.9382]},
    {"iata":"CJU","name":"Jeju International","city":"Jeju","country":"KR","coordinates":[33.5113,126.4929]},
    {"iata":"KUL","name":"Kuala Lumpur International","city":"Kuala Lumpur","country":"MY","coordinates":[2.7456,101.7099]},
    {"iata":"PEN","name":"Penang International","city":"Penang","country":"MY","coordinates":[5.2972,100.2769]},
    {"iata":"BKI","name":"Kota Kinabalu International","city":"Kota Kinabalu","country":"MY","coordinates":[5.9372,116.0515]},
    {"iata":"CGK","name":"Soekarno-Hatta International","city":"Jakarta","country":"ID","coordinates":[-6.1256,106.6558]},
    {"iata":"DPS","name":"Ngurah Rai International","city":"Bali","country":"ID","coordinates":[-8.7482,115.1672]},
    {"iata":"SUB","name":"Juanda International","city":"Surabaya","country":"ID","coordinates":[-7.3798,112.7868]},
    {"iata":"MNL","name":"Ninoy Aquino International","city":"Manila","country":"PH","coordinates":[14.5086,121.0198]},
    {"iata":"CEB","name":"Mactan-Cebu International","city":"Cebu","country":"PH","coordinates":[10.3076,123.9794]},
    {"iata":"SGN","name":"Tan Son Nhat International","city":"Ho Chi Minh City","country":"VN","coordinates":[10.8188,106.6520]},
    {"iata":"HAN","name":"Noi Bai International","city":"Hanoi","country":"VN","coordinates":[21.2212,105.8071]},
    {"iata":"DAD","name":"Da Nang International","city":"Da Nang","country":"VN","coordinates":[16.0439,108.1992]},
    {"iata":"DMK","name":"Don Mueang International","city":"Bangkok","country":"TH","coordinates":[13.9126,100.6070]},
    {"iata":"CNX","name":"Chiang Mai International","city":"Chiang Mai","country":"TH","coordinates":[18.7669,98.9625]},
    {"iata":"HKT","name":"Phuket International","city":"Phuket","country":"TH","coordinates":[8.1132,98.3169]},
    {"iata":"USM","name":"Samui International","city":"Ko Samui","country":"TH","coordinates":[9.5478,100.0622]},
    {"iata":"RGN","name":"Yangon International","city":"Yangon","country":"MM","coordinates":[16.9073,96.1332]},
    {"iata":"PNH","name":"Phnom Penh International","city":"Phnom Penh","country":"KH","coordinates":[11.5466,104.8441]},
    {"iata":"REP","name":"Siem Reap International","city":"Siem Reap","country":"KH","coordinates":[13.4107,103.8131]},
    {"iata":"VTE","name":"Wattay International","city":"Vientiane","country":"LA","coordinates":[17.9883,102.5633]},
    {"iata":"CMB","name":"Bandaranaike International","city":"Colombo","country":"LK","coordinates":[7.1808,79.8841]},
    {"iata":"MLE","name":"Velana International","city":"Malé","country":"MV","coordinates":[4.1918,73.5291]},
    {"iata":"BOM","name":"Chhatrapati Shivaji Maharaj International","city":"Mumbai","country":"IN","coordinates":[19.0896,72.8656]},
    {"iata":"BLR","name":"Kempegowda International","city":"Bangalore","country":"IN","coordinates":[13.1986,77.7066]},
    {"iata":"MAA","name":"Chennai International","city":"Chennai","country":"IN","coordinates":[12.9941,80.1709]},
    {"iata":"HYD","name":"Rajiv Gandhi International","city":"Hyderabad","country":"IN","coordinates":[17.2403,78.4294]},
    {"iata":"CCU","name":"Netaji Subhas Chandra Bose International","city":"Kolkata","country":"IN","coordinates":[22.6547,88.4467]},
    {"iata":"COK","name":"Cochin International","city":"Kochi","country":"IN","coordinates":[10.1520,76.4019]},
    {"iata":"GOI","name":"Goa International","city":"Goa","country":"IN","coordinates":[15.3808,73.8314]},
    {"iata":"KTM","name":"Tribhuvan International","city":"Kathmandu","country":"NP","coordinates":[27.6966,85.3591]},
    {"iata":"ISB","name":"Islamabad International","city":"Islamabad","country":"PK","coordinates":[33.5605,72.8526]},
    {"iata":"KHI","name":"Jinnah International","city":"Karachi","country":"PK","coordinates":[24.9065,67.1610]},
    {"iata":"DAC","name":"Hazrat Shahjalal International","city":"Dhaka","country":"BD","coordinates":[23.8432,90.3977]},
    {"iata":"DOH","name":"Hamad International","city":"Doha","country":"QA","coordinates":[25.2731,51.6081]},
    {"iata":"AUH","name":"Abu Dhabi International","city":"Abu Dhabi","country":"AE","coordinates":[24.4330,54.6511]},
    {"iata":"BAH","name":"Bahrain International","city":"Manama","country":"BH","coordinates":[26.2192,50.6336]},
    {"iata":"MCT","name":"Muscat International","city":"Muscat","country":"OM","coordinates":[23.5933,58.2844]},
    {"iata":"KWI","name":"Kuwait International","city":"Kuwait City","country":"KW","coordinates":[29.2266,47.9689]},
    {"iata":"AMM","name":"Queen Alia International","city":"Amman","country":"JO","coordinates":[31.7226,35.9932]},
    {"iata":"TLV","name":"Ben Gurion International","city":"Tel Aviv","country":"IL","coordinates":[32.0114,34.8867]},
    {"iata":"JED","name":"King Abdulaziz International","city":"Jeddah","country":"SA","coordinates":[21.6796,39.1565]},
    {"iata":"RUH","name":"King Khalid International","city":"Riyadh","country":"SA","coordinates":[24.9578,46.6989]},
    {"iata":"CAI","name":"Cairo International","city":"Cairo","country":"EG","coordinates":[30.1219,31.4056]},
    {"iata":"HRG","name":"Hurghada International","city":"Hurghada","country":"EG","coordinates":[27.1783,33.7994]},
    {"iata":"SSH","name":"Sharm el-Sheikh International","city":"Sharm el-Sheikh","country":"EG","coordinates":[27.9773,34.3950]},
    {"iata":"LXR","name":"Luxor International","city":"Luxor","country":"EG","coordinates":[25.6710,32.7066]},
    {"iata":"CMN","name":"Mohammed V International","city":"Casablanca","country":"MA","coordinates":[33.3675,-7.5898]},
    {"iata":"RAK","name":"Marrakech Menara","city":"Marrakech","country":"MA","coordinates":[31.6069,-8.0363]},
    {"iata":"TUN","name":"Tunis-Carthage International","city":"Tunis","country":"TN","coordinates":[36.8510,10.2272]},
    {"iata":"ALG","name":"Houari Boumediene","city":"Algiers","country":"DZ","coordinates":[36.6910,3.2154]},
    {"iata":"ADD","name":"Addis Ababa Bole International","city":"Addis Ababa","country":"ET","coordinates":[8.9779,38.7993]},
    {"iata":"NBO","name":"Jomo Kenyatta International","city":"Nairobi","country":"KE","coordinates":[-1.3192,36.9278]},
    {"iata":"JNB","name":"O.R. Tambo International","city":"Johannesburg","country":"ZA","coordinates":[-26.1392,28.2460]},
    {"iata":"CPT","name":"Cape Town International","city":"Cape Town","country":"ZA","coordinates":[-33.9649,18.6017]},
    {"iata":"DUR","name":"King Shaka International","city":"Durban","country":"ZA","coordinates":[-29.6144,31.1197]},
    {"iata":"DAR","name":"Julius Nyerere International","city":"Dar es Salaam","country":"TZ","coordinates":[-6.8781,39.2026]},
    {"iata":"ZNZ","name":"Abeid Amani Karume International","city":"Zanzibar","country":"TZ","coordinates":[-6.2220,39.2249]},
    {"iata":"JRO","name":"Kilimanjaro International","city":"Kilimanjaro","country":"TZ","coordinates":[-3.4294,37.0745]},
    {"iata":"LOS","name":"Murtala Muhammed International","city":"Lagos","country":"NG","coordinates":[6.5774,3.3211]},
    {"iata":"ACC","name":"Kotoka International","city":"Accra","country":"GH","coordinates":[5.6052,-0.1668]},
    {"iata":"DSS","name":"Blaise Diagne International","city":"Dakar","country":"SN","coordinates":[14.6700,-17.0700]},
    {"iata":"MRU","name":"Sir Seewoosagur Ramgoolam International","city":"Mauritius","country":"MU","coordinates":[-20.4302,57.6836]},
    {"iata":"SEZ","name":"Seychelles International","city":"Mahé","country":"SC","coordinates":[-4.6743,55.5218]},
    {"iata":"WDH","name":"Hosea Kutako International","city":"Windhoek","country":"NA","coordinates":[-22.4799,17.4709]},
    {"iata":"VFA","name":"Victoria Falls International","city":"Victoria Falls","country":"ZW","coordinates":[-18.0959,25.8390]},
    {"iata":"LLW","name":"Kamuzu International","city":"Lilongwe","country":"MW","coordinates":[-13.7894,33.7810]},
    {"iata":"EBB","name":"Entebbe International","city":"Entebbe","country":"UG","coordinates":[0.0424,32.4435]},
    {"iata":"KGL","name":"Kigali International","city":"Kigali","country":"RW","coordinates":[-1.9686,30.1395]},
    {"iata":"SYD","name":"Sydney Kingsford Smith","city":"Sydney","country":"AU","coordinates":[-33.9461,151.1772]},
    {"iata":"MEL","name":"Melbourne Tullamarine","city":"Melbourne","country":"AU","coordinates":[-37.6733,144.8433]},
    {"iata":"BNE","name":"Brisbane","city":"Brisbane","country":"AU","coordinates":[-27.3842,153.1175]},
    {"iata":"PER","name":"Perth","city":"Perth","country":"AU","coordinates":[-31.9403,115.9672]},
    {"iata":"ADL","name":"Adelaide","city":"Adelaide","country":"AU","coordinates":[-34.9450,138.5306]},
    {"iata":"CNS","name":"Cairns","city":"Cairns","country":"AU","coordinates":[-16.8858,145.7554]},
    {"iata":"OOL","name":"Gold Coast","city":"Gold Coast","country":"AU","coordinates":[-28.1644,153.5047]},
    {"iata":"AKL","name":"Auckland","city":"Auckland","country":"NZ","coordinates":[-37.0082,174.7850]},
    {"iata":"WLG","name":"Wellington","city":"Wellington","country":"NZ","coordinates":[-41.3272,174.8053]},
    {"iata":"CHC","name":"Christchurch","city":"Christchurch","country":"NZ","coordinates":[-43.4894,172.5322]},
    {"iata":"ZQN","name":"Queenstown","city":"Queenstown","country":"NZ","coordinates":[-45.0211,168.7392]},
    {"iata":"NAN","name":"Nadi International","city":"Nadi","country":"FJ","coordinates":[-17.7554,177.4431]},
    {"iata":"PPT","name":"Faa'a International","city":"Papeete","country":"PF","coordinates":[-17.5537,-149.6114]},
    {"iata":"BOB","name":"Bora Bora","city":"Bora Bora","country":"PF","coordinates":[-16.4444,-151.7513]},
    {"iata":"APW","name":"Faleolo International","city":"Apia","country":"WS","coordinates":[-13.8299,-172.0065]},
    {"iata":"HAV","name":"José Martí International","city":"Havana","country":"CU","coordinates":[22.9892,-82.4091]},
    {"iata":"SJU","name":"Luis Muñoz Marín International","city":"San Juan","country":"PR","coordinates":[18.4394,-66.0018]},
    {"iata":"PUJ","name":"Punta Cana International","city":"Punta Cana","country":"DO","coordinates":[18.5674,-68.3634]},
    {"iata":"MBJ","name":"Sangster International","city":"Montego Bay","country":"JM","coordinates":[18.5037,-77.9134]},
    {"iata":"KIN","name":"Norman Manley International","city":"Kingston","country":"JM","coordinates":[17.9357,-76.7875]},
    {"iata":"NAS","name":"Lynden Pindling International","city":"Nassau","country":"BS","coordinates":[25.0390,-77.4662]},
    {"iata":"BGI","name":"Grantley Adams International","city":"Bridgetown","country":"BB","coordinates":[13.0746,-59.4925]},
    {"iata":"ANU","name":"V.C. Bird International","city":"St. John's","country":"AG","coordinates":[17.1366,-61.7926]},
    {"iata":"POS","name":"Piarco International","city":"Port of Spain","country":"TT","coordinates":[10.5955,-61.3372]},
    {"iata":"AUA","name":"Queen Beatrix International","city":"Oranjestad","country":"AW","coordinates":[12.5014,-70.0152]},
    {"iata":"CUR","name":"Hato International","city":"Willemstad","country":"CW","coordinates":[12.1889,-68.9598]},
    {"iata":"SXM","name":"Princess Juliana International","city":"Philipsburg","country":"SX","coordinates":[18.0410,-63.1089]},
    {"iata":"GCM","name":"Owen Roberts International","city":"George Town","country":"KY","coordinates":[19.2928,-81.3577]},
    {"iata":"BDA","name":"L.F. Wade International","city":"Hamilton","country":"BM","coordinates":[32.3640,-64.6787]},
    {"iata":"PLS","name":"Providenciales International","city":"Providenciales","country":"TC","coordinates":[21.7736,-72.2659]},
    {"iata":"TBS","name":"Tbilisi International","city":"Tbilisi","country":"GE","coordinates":[41.6692,44.9547]},
    {"iata":"EVN","name":"Zvartnots International","city":"Yerevan","country":"AM","coordinates":[40.1473,44.3959]},
    {"iata":"GYD","name":"Heydar Aliyev International","city":"Baku","country":"AZ","coordinates":[40.4675,50.0467]},
    {"iata":"TAS","name":"Islam Karimov International","city":"Tashkent","country":"UZ","coordinates":[41.2579,69.2813]},
    {"iata":"SKD","name":"Samarkand International","city":"Samarkand","country":"UZ","coordinates":[39.7005,66.9838]},
    {"iata":"FRU","name":"Manas International","city":"Bishkek","country":"KG","coordinates":[43.0613,74.4776]},
    {"iata":"DYU","name":"Dushanbe International","city":"Dushanbe","country":"TJ","coordinates":[38.5433,68.8250]},
    {"iata":"ALA","name":"Almaty International","city":"Almaty","country":"KZ","coordinates":[43.3521,77.0405]},
    {"iata":"NQZ","name":"Nursultan Nazarbayev International","city":"Astana","country":"KZ","coordinates":[51.0222,71.4669]},
    {"iata":"SAW","name":"Sabiha Gökçen International","city":"Istanbul","country":"TR","coordinates":[40.8986,29.3092]},
    {"iata":"AYT","name":"Antalya","city":"Antalya","country":"TR","coordinates":[36.8987,30.8005]},
    {"iata":"ADB","name":"Adnan Menderes","city":"Izmir","country":"TR","coordinates":[38.2924,27.1570]},
    {"iata":"DLM","name":"Dalaman","city":"Dalaman","country":"TR","coordinates":[36.7131,28.7925]},
    {"iata":"BJV","name":"Milas-Bodrum","city":"Bodrum","country":"TR","coordinates":[37.2506,28.3043]},
    {"iata":"NAV","name":"Nevşehir Kapadokya","city":"Cappadocia","country":"TR","coordinates":[38.7719,34.5345]},
    {"iata":"BEY","name":"Rafic Hariri International","city":"Beirut","country":"LB","coordinates":[33.8209,35.4884]},
    {"iata":"IKA","name":"Imam Khomeini International","city":"Tehran","country":"IR","coordinates":[35.4161,51.1522]},
    {"iata":"CTU","name":"Chengdu Shuangliu","city":"Chengdu","country":"CN","coordinates":[30.5785,103.9471]},
    {"iata":"CKG","name":"Chongqing Jiangbei","city":"Chongqing","country":"CN","coordinates":[29.7192,106.6417]},
    {"iata":"SZX","name":"Shenzhen Bao'an","city":"Shenzhen","country":"CN","coordinates":[22.6393,113.8107]},
    {"iata":"XIY","name":"Xi'an Xianyang","city":"Xi'an","country":"CN","coordinates":[34.4471,108.7516]},
    {"iata":"KMG","name":"Kunming Changshui","city":"Kunming","country":"CN","coordinates":[24.9924,102.7432]},
    {"iata":"HGH","name":"Hangzhou Xiaoshan","city":"Hangzhou","country":"CN","coordinates":[30.2295,120.4344]},
    {"iata":"NKG","name":"Nanjing Lukou","city":"Nanjing","country":"CN","coordinates":[31.7420,118.8620]},
    {"iata":"WUH","name":"Wuhan Tianhe","city":"Wuhan","country":"CN","coordinates":[30.7838,114.2081]},
    {"iata":"TAO","name":"Qingdao Jiaodong","city":"Qingdao","country":"CN","coordinates":[36.2611,120.1253]},
    {"iata":"DLC","name":"Dalian Zhoushuizi","city":"Dalian","country":"CN","coordinates":[38.9657,121.5386]},
    {"iata":"ULN","name":"Chinggis Khaan International","city":"Ulaanbaatar","country":"MN","coordinates":[47.8431,106.7669]},
    {"iata":"MFM","name":"Macau International","city":"Macau","country":"MO","coordinates":[22.1496,113.5916]},
    {"iata":"LPB","name":"El Alto International","city":"La Paz","country":"BO","coordinates":[-16.5133,-68.1923]},
    {"iata":"MVD","name":"Carrasco International","city":"Montevideo","country":"UY","coordinates":[-34.8384,-56.0308]},
    {"iata":"ASU","name":"Silvio Pettirossi International","city":"Asunción","country":"PY","coordinates":[-25.2400,-57.5200]},
    {"iata":"CCS","name":"Simón Bolívar International","city":"Caracas","country":"VE","coordinates":[10.6012,-66.9912]},
    {"iata":"MDE","name":"José María Córdova International","city":"Medellín","country":"CO","coordinates":[6.1645,-75.4231]},
    {"iata":"CLO","name":"Alfonso Bonilla Aragón International","city":"Cali","country":"CO","coordinates":[3.5432,-76.3816]},
    {"iata":"GYE","name":"José Joaquín de Olmedo International","city":"Guayaquil","country":"EC","coordinates":[-2.1574,-79.8837]},
    {"iata":"GPS","name":"Seymour","city":"Galápagos","country":"EC","coordinates":[-0.4537,-90.2659]},
    {"iata":"CUZ","name":"Alejandro Velasco Astete International","city":"Cusco","country":"PE","coordinates":[-13.5357,-71.9388]},
    {"iata":"BZE","name":"Philip S. W. Goldson International","city":"Belize City","country":"BZ","coordinates":[17.5391,-88.3082]},
    {"iata":"GUA","name":"La Aurora International","city":"Guatemala City","country":"GT","coordinates":[14.5833,-90.5275]},
    {"iata":"SAL","name":"Óscar Arnulfo Romero International","city":"San Salvador","country":"SV","coordinates":[13.4409,-89.0557]},
    {"iata":"TGU","name":"Toncontín International","city":"Tegucigalpa","country":"HN","coordinates":[14.0609,-87.2172]},
    {"iata":"MGA","name":"Augusto C. Sandino International","city":"Managua","country":"NI","coordinates":[12.1415,-86.1682]},
    {"iata":"LPQ","name":"Luang Prabang International","city":"Luang Prabang","country":"LA","coordinates":[19.8973,102.1614]},
    {"iata":"PBH","name":"Paro International","city":"Paro","country":"BT","coordinates":[27.4032,89.4246]},
    {"iata":"SVO","name":"Sheremetyevo International","city":"Moscow","country":"RU","coordinates":[55.9726,37.4146]},
    {"iata":"DME","name":"Domodedovo International","city":"Moscow","country":"RU","coordinates":[55.4088,37.9063]},
    {"iata":"LED","name":"Pulkovo","city":"St. Petersburg","country":"RU","coordinates":[59.8003,30.2625]},
    {"iata":"MLA","name":"Malta International","city":"Valletta","country":"MT","coordinates":[35.8575,14.4775]},
    {"iata":"SKP","name":"Skopje International","city":"Skopje","country":"MK","coordinates":[41.9616,21.6214]},
    {"iata":"BEG","name":"Belgrade Nikola Tesla","city":"Belgrade","country":"RS","coordinates":[44.8184,20.3091]},
    {"iata":"LCA","name":"Larnaca International","city":"Larnaca","country":"CY","coordinates":[34.8751,33.6249]},
    {"iata":"PFO","name":"Paphos International","city":"Paphos","country":"CY","coordinates":[34.7180,32.4857]},
    {"iata":"SVX","name":"Koltsovo","city":"Yekaterinburg","country":"RU","coordinates":[56.7431,60.8027]},
    {"iata":"OVB","name":"Tolmachevo","city":"Novosibirsk","country":"RU","coordinates":[55.0126,82.6507]},
    {"iata":"VVO","name":"Vladivostok","city":"Vladivostok","country":"RU","coordinates":[43.3960,132.1483]},
    {"iata":"IKT","name":"Irkutsk","city":"Irkutsk","country":"RU","coordinates":[52.2680,104.3889]},
    {"iata":"KZN","name":"Kazan International","city":"Kazan","country":"RU","coordinates":[55.6062,49.2787]},
    {"iata":"AER","name":"Sochi International","city":"Sochi","country":"RU","coordinates":[43.4499,39.9566]},
    {"iata":"FAE","name":"Vágar","city":"Faroe Islands","country":"FO","coordinates":[62.0636,-7.2772]},
    {"iata":"LYR","name":"Svalbard Airport","city":"Longyearbyen","country":"NO","coordinates":[78.2461,15.4656]},
    {"iata":"TOS","name":"Tromsø Langnes","city":"Tromsø","country":"NO","coordinates":[69.6833,18.9189]},
    {"iata":"BGO","name":"Bergen Flesland","city":"Bergen","country":"NO","coordinates":[60.2934,5.2181]},
    {"iata":"SVG","name":"Stavanger Sola","city":"Stavanger","country":"NO","coordinates":[58.8767,5.6378]},
    {"iata":"GOT","name":"Gothenburg Landvetter","city":"Gothenburg","country":"SE","coordinates":[57.6628,12.2798]},
    {"iata":"RVN","name":"Rovaniemi","city":"Rovaniemi","country":"FI","coordinates":[66.5648,25.8304]},
    {"iata":"TRD","name":"Trondheim Værnes","city":"Trondheim","country":"NO","coordinates":[63.4578,10.9240]},
    {"iata":"SNN","name":"Shannon","city":"Shannon","country":"IE","coordinates":[52.7020,-8.9248]},
    {"iata":"ORK","name":"Cork","city":"Cork","country":"IE","coordinates":[51.8413,-8.4911]},
    {"iata":"KNO","name":"Kualanamu International","city":"Medan","country":"ID","coordinates":[3.6422,98.8853]},
    {"iata":"LBJ","name":"Komodo","city":"Labuan Bajo","country":"ID","coordinates":[-8.4866,119.8892]},
    {"iata":"SOQ","name":"Domine Eduard Osok","city":"Sorong","country":"ID","coordinates":[-0.8937,131.2869]},
    {"iata":"LOP","name":"Lombok International","city":"Lombok","country":"ID","coordinates":[-8.7573,116.2767]},
    {"iata":"TAG","name":"Panglao International","city":"Bohol","country":"PH","coordinates":[9.5584,123.7714]},
    {"iata":"PPS","name":"Puerto Princesa International","city":"Puerto Princesa","country":"PH","coordinates":[9.7421,118.7587]},
    {"iata":"IAD","name":"Dulles International","city":"Washington DC","country":"US","coordinates":[38.9531,-77.4565]},
    {"iata":"GEG","name":"Spokane International","city":"Spokane","country":"US","coordinates":[47.6199,-117.5338]},
    {"iata":"OGG","name":"Kahului","city":"Maui","country":"US","coordinates":[20.8986,-156.4305]},
    {"iata":"LIH","name":"Lihue","city":"Kauai","country":"US","coordinates":[21.9760,-159.3390]},
    {"iata":"KOA","name":"Ellison Onizuka Kona","city":"Kona","country":"US","coordinates":[19.7388,-156.0456]},
    {"iata":"JAC","name":"Jackson Hole","city":"Jackson Hole","country":"US","coordinates":[43.6073,-110.7377]},
    {"iata":"ASE","name":"Aspen/Pitkin County","city":"Aspen","country":"US","coordinates":[39.2232,-106.8688]},
    {"iata":"MSY","name":"Louis Armstrong International","city":"New Orleans","country":"US","coordinates":[29.9934,-90.2580]},
    {"iata":"CHS","name":"Charleston International","city":"Charleston","country":"US","coordinates":[32.8987,-80.0405]},
    {"iata":"SAV","name":"Savannah/Hilton Head International","city":"Savannah","country":"US","coordinates":[32.1276,-81.2021]},
    {"iata":"SMF","name":"Sacramento International","city":"Sacramento","country":"US","coordinates":[38.6954,-121.5908]},
    {"iata":"IND","name":"Indianapolis International","city":"Indianapolis","country":"US","coordinates":[39.7173,-86.2944]},
    {"iata":"MKE","name":"Milwaukee Mitchell","city":"Milwaukee","country":"US","coordinates":[42.9472,-87.8966]},
    {"iata":"PIT","name":"Pittsburgh International","city":"Pittsburgh","country":"US","coordinates":[40.4915,-80.2329]},
    {"iata":"CVG","name":"Cincinnati/Northern Kentucky","city":"Cincinnati","country":"US","coordinates":[39.0488,-84.6678]},
    {"iata":"CLE","name":"Cleveland Hopkins International","city":"Cleveland","country":"US","coordinates":[41.4117,-81.8498]},
    {"iata":"CMH","name":"John Glenn Columbus International","city":"Columbus","country":"US","coordinates":[39.9980,-82.8919]},
    {"iata":"JAX","name":"Jacksonville International","city":"Jacksonville","country":"US","coordinates":[30.4941,-81.6879]},
    {"iata":"ABQ","name":"Albuquerque International Sunport","city":"Albuquerque","country":"US","coordinates":[35.0402,-106.6091]},
    {"iata":"OMA","name":"Eppley Airfield","city":"Omaha","country":"US","coordinates":[41.3032,-95.8941]},
    {"iata":"MEM","name":"Memphis International","city":"Memphis","country":"US","coordinates":[35.0424,-89.9767]},
    {"iata":"ANC","name":"Ted Stevens Anchorage International","city":"Anchorage","country":"US","coordinates":[61.1743,-149.9962]},
    {"iata":"YQB","name":"Québec City Jean Lesage International","city":"Québec City","country":"CA","coordinates":[46.7911,-71.3933]},
    {"iata":"YXE","name":"Saskatoon John G. Diefenbaker","city":"Saskatoon","country":"CA","coordinates":[52.1708,-106.6997]},
    {"iata":"YQR","name":"Regina International","city":"Regina","country":"CA","coordinates":[50.4319,-104.6658]},
    {"iata":"YVR","name":"Vancouver International","city":"Vancouver","country":"CA","coordinates":[49.1967,-123.1815]},
    {"iata":"YLW","name":"Kelowna International","city":"Kelowna","country":"CA","coordinates":[49.9561,-119.3778]},
    {"iata":"YXY","name":"Erik Nielsen Whitehorse International","city":"Whitehorse","country":"CA","coordinates":[60.7096,-135.0674]},
    {"iata":"YZF","name":"Yellowknife","city":"Yellowknife","country":"CA","coordinates":[62.4628,-114.4403]},
    {"iata":"PIX","name":"Pico","city":"Azores","country":"PT","coordinates":[38.5543,-28.4413]},
    {"iata":"PDL","name":"Ponta Delgada","city":"Azores","country":"PT","coordinates":[37.7412,-25.6979]},
    {"iata":"FNC","name":"Cristiano Ronaldo International","city":"Madeira","country":"PT","coordinates":[32.6942,-16.7745]},
    {"iata":"SPC","name":"La Palma","city":"La Palma","country":"ES","coordinates":[28.6265,-17.7556]},
    {"iata":"ACE","name":"Lanzarote","city":"Lanzarote","country":"ES","coordinates":[28.9455,-13.6052]},
    {"iata":"TFS","name":"Tenerife South","city":"Tenerife","country":"ES","coordinates":[28.0445,-16.5725]},
    {"iata":"LPA","name":"Gran Canaria","city":"Gran Canaria","country":"ES","coordinates":[27.9319,-15.3866]},
    {"iata":"FUE","name":"Fuerteventura","city":"Fuerteventura","country":"ES","coordinates":[28.4527,-13.8638]},
    {"iata":"OLB","name":"Olbia Costa Smeralda","city":"Sardinia","country":"IT","coordinates":[40.8987,9.5177]},
    {"iata":"CAG","name":"Cagliari Elmas","city":"Sardinia","country":"IT","coordinates":[39.2515,9.0543]},
    {"iata":"AJA","name":"Ajaccio Napoleon Bonaparte","city":"Corsica","country":"FR","coordinates":[41.9236,8.8029]},
    {"iata":"CFU","name":"Corfu International","city":"Corfu","country":"GR","coordinates":[39.6019,19.9117]},
    {"iata":"RHO","name":"Rhodes Diagoras","city":"Rhodes","country":"GR","coordinates":[36.4054,28.0862]},
    {"iata":"CHQ","name":"Chania International","city":"Crete","country":"GR","coordinates":[35.5317,24.1497]},
    {"iata":"KGS","name":"Kos","city":"Kos","country":"GR","coordinates":[36.7933,27.0917]},
    {"iata":"ZTH","name":"Zakynthos","city":"Zakynthos","country":"GR","coordinates":[37.7509,20.8843]},
    {"iata":"BWN","name":"Brunei International","city":"Bandar Seri Begawan","country":"BN","coordinates":[4.9442,114.9283]},
    {"iata":"SIN","name":"Singapore Changi","city":"Singapore","country":"SG","coordinates":[1.3644,103.9915]},
    {"iata":"RUN","name":"Roland Garros","city":"Réunion","country":"RE","coordinates":[-20.8871,55.5103]},
    {"iata":"TNR","name":"Ivato International","city":"Antananarivo","country":"MG","coordinates":[-18.7969,47.4789]},
    {"iata":"MBA","name":"Moi International","city":"Mombasa","country":"KE","coordinates":[-4.0348,39.5942]},
    {"iata":"PLZ","name":"Chief Dawid Stuurman International","city":"Gqeberha","country":"ZA","coordinates":[-33.9849,25.6173]},
    {"iata":"GBE","name":"Sir Seretse Khama International","city":"Gaborone","country":"BW","coordinates":[-24.5552,25.9182]},
    {"iata":"MUN","name":"Maun","city":"Maun","country":"BW","coordinates":[-19.9726,23.4311]},
    {"iata":"HRE","name":"Robert Gabriel Mugabe International","city":"Harare","country":"ZW","coordinates":[-17.9318,31.0928]},
    {"iata":"LUN","name":"Kenneth Kaunda International","city":"Lusaka","country":"ZM","coordinates":[-15.3308,28.4526]},
    {"iata":"LVI","name":"Harry Mwanga Nkumbula International","city":"Livingstone","country":"ZM","coordinates":[-17.8218,25.8227]},
    {"iata":"LAD","name":"Quatro de Fevereiro","city":"Luanda","country":"AO","coordinates":[-8.8584,13.2312]},
    {"iata":"MPM","name":"Maputo International","city":"Maputo","country":"MZ","coordinates":[-25.9208,32.5726]},
    {"iata":"ABV","name":"Nnamdi Azikiwe International","city":"Abuja","country":"NG","coordinates":[9.0065,7.2632]},
    {"iata":"DKR","name":"Léopold Sédar Senghor","city":"Dakar","country":"SN","coordinates":[14.7397,-17.4902]},
    {"iata":"ABJ","name":"Félix-Houphouët-Boigny International","city":"Abidjan","country":"CI","coordinates":[5.2614,-3.9262]},
    {"iata":"ROB","name":"Roberts International","city":"Monrovia","country":"LR","coordinates":[6.2338,-10.3623]},
    {"iata":"FNA","name":"Lungi International","city":"Freetown","country":"SL","coordinates":[8.6164,-13.1956]},
    {"iata":"BKO","name":"Modibo Keïta International","city":"Bamako","country":"ML","coordinates":[12.5335,-8.0714]},
    {"iata":"OUA","name":"Thomas Sankara International","city":"Ouagadougou","country":"BF","coordinates":[12.3532,-1.5124]},
    {"iata":"COO","name":"Cadjehoun","city":"Cotonou","country":"BJ","coordinates":[6.3573,2.3844]},
    {"iata":"LFW","name":"Lomé-Tokoin","city":"Lomé","country":"TG","coordinates":[6.1661,1.2545]},
    {"iata":"DLA","name":"Douala International","city":"Douala","country":"CM","coordinates":[4.0061,9.7194]},
    {"iata":"FIH","name":"N'djili International","city":"Kinshasa","country":"CD","coordinates":[-4.3858,15.4446]},
    {"iata":"BZV","name":"Maya-Maya","city":"Brazzaville","country":"CG","coordinates":[-4.2517,15.2530]},
    {"iata":"LBV","name":"Léon-Mba International","city":"Libreville","country":"GA","coordinates":[0.4586,9.4123]}
]

with open("references/airports.json", "w") as f:
    json.dump(airports, f, indent=2)

print(f"Generated {len(airports)} airports")
