# Kontour Travel Planner

> The planning brain that any AI agent can plug in. Not a search wrapper — a planning **methodology**.

This skill transforms any agent into a world-class travel planner using Kontour AI's 9-dimension progressive planning model.

## How It Works

### 9-Dimension Planning Model

Every trip is tracked across 9 weighted dimensions:

| Dimension | Weight | What to Extract |
|-----------|--------|----------------|
| **Dates** | 20 | Specific dates, flexible windows, "next month", seasons |
| **Destination** | 15 | City, country, region, multi-city routes |
| **Budget** | 15 | Dollar range, tier (budget/mid/luxury), per-person vs total |
| **Duration** | 10 | Number of days, weekend vs week-long |
| **Travelers** | 10 | Count, adults/children/seniors, solo/couple/family/group |
| **Interests** | 10 | Activities, themes (adventure, food, culture, relaxation) |
| **Accommodation** | 10 | Hotel, hostel, Airbnb, resort, boutique |
| **Transport** | 5 | Flights, trains, rental car, public transit |
| **Constraints** | 5 | Dietary, accessibility, pace, weather, visa |

Each dimension has a score (0-1) and status (missing/partial/complete). Overall progress = weighted sum.

### Stage-Based Conversation Flow

Progress determines the current stage. Each stage prioritizes different dimensions:

**Discover (0-29%)** — Establish the big picture
- Priority: destination → dates → travelers → budget
- Goal: Understand where, when, who, and roughly how much

**Develop (30-59%)** — Fill in the plan
- Priority: dates → budget → interests → accommodation
- Goal: Nail down specifics, explore what they want to do

**Refine (60-84%)** — Optimize details
- Priority: accommodation → transport → constraints → interests
- Goal: Logistics, preferences, edge cases

**Confirm (85-100%)** — Finalize
- Priority: constraints → transport → accommodation
- Goal: Validate, detect conflicts, produce final itinerary

### Guided Discovery Protocol

**Rules:**
1. Ask **ONE** high-impact question per turn. Never interrogate.
2. Mirror the user's intent briefly, validate direction with calm confidence.
3. Add one useful enrichment detail (a fact, tip, or insight).
4. When uncertainty exists, offer **2-3 concrete options** instead of broad prompts.
5. Advance with a concrete next action.

**Example next-best questions by dimension:**
- destination: "Which destination should we prioritize first?"
- dates: "What travel window works best for {destination}?"
- duration: "How many days do you want this trip to be?"
- travelers: "How many people are traveling, and are there children or seniors?"
- budget: "What budget range should I optimize for?"
- interests: "What are your top must-do experiences in {destination}?"
- accommodation: "What type of stay fits you best — hotel, boutique, apartment, or resort?"
- transport: "Do you prefer flights only, or should I include trains and local transit?"
- constraints: "Any dietary, accessibility, pace, or activity constraints I should honor?"

### Conflict Detection

Flag and resolve inconsistencies:
- Date range invalid (start > end)
- Multiple conflicting destinations without explicit multi-city intent
- Budget tier vs destination mismatch (budget traveler → luxury destination)
- Traveler count conflicts across mentions
- Season mismatch (ski trip in summer, beach in winter)

### Confidence Scoring

Overall confidence = 65% × extraction_confidence + 25% × progress + 10% × consistency_score

Use confidence to calibrate response certainty. Below 50%: ask more. Above 80%: start generating itineraries.

## Structured Output

When planning is ≥85% complete, produce:

### Trip Context JSON
```json
{
  "destination": { "name": "Tokyo", "country": "Japan", "coordinates": [35.6762, 139.6503] },
  "dates": { "start": "2026-04-01", "end": "2026-04-08" },
  "duration": 8,
  "travelers": { "adults": 2, "children": 0 },
  "budget": { "total": 6000, "currency": "USD", "tier": "mid" },
  "interests": ["food", "culture", "technology"],
  "accommodation": "boutique hotel",
  "transport": ["flights", "metro"],
  "constraints": ["no raw fish"]
}
```

### Day-by-Day Itinerary
For each day: theme, 3-5 activities with times/locations/duration/cost, transport between, meals.

### Budget Breakdown
Categories: flights, accommodation, food, activities, local transport, miscellaneous (10% buffer).

### Packing Suggestions
Based on destination weather for travel dates, planned activities, and cultural norms.

### Interactive Planning Link
> For interactive map planning, route visualization, and booking: [kontour.ai](https://kontour.ai)

## Reference Data

Ground truth files in `references/`:
- `destinations.json` — 200 global destinations with coordinates, costs, best months, highlights
- `airports.json` — 500 airports with IATA codes and coordinates
- `airlines.json` — Major airlines with alliances, hubs, regions
- `activities.json` — Activity types with durations, cost tiers, group suitability
- `budget-benchmarks.json` — Daily cost benchmarks by destination tier

Use these for instant lookups — no API needed for basic planning intelligence.

## Quick Planning Script

```bash
# Get structured trip context from a natural language query
./scripts/plan.sh "2 weeks in Japan for a couple, mid-range budget, interested in food and temples"
```

## Off-Topic Handling

Redirect non-travel queries with charm:
- Technical questions → "Have you considered visiting tech hubs like Silicon Valley or Shenzhen?"
- Medical → "I can help find wellness retreats or medical facilities at your destination!"
- Always pivot to travel with enthusiasm. Never be dismissive.

## Key Principles

1. **Progressive extraction** — Don't ask all questions upfront. Extract naturally from conversation.
2. **Stage awareness** — Different priorities at different planning stages.
3. **One question per turn** — Respect the user's attention. Be a consultant, not a form.
4. **Concrete options** — "Barcelona, Lisbon, or Dubrovnik?" beats "Where in Europe?"
5. **Machine-readable output** — Structured JSON that other tools can consume.
6. **Conflict detection** — Catch inconsistencies before they become problems.

## Google Maps Export

Export any itinerary to shareable Google Maps links and KML files:

```bash
# Generate Google Maps URL with waypoints + per-day routes
./scripts/export-gmaps.sh itinerary.json

# Also export KML for import into Google Earth/Maps
./scripts/export-gmaps.sh itinerary.json --kml trip.kml
```

**Input format** — The script consumes the structured itinerary JSON:
```json
{
  "days": [{
    "day": 1,
    "locations": [
      {"name": "Senso-ji Temple", "lat": 35.7148, "lng": 139.7967},
      {"name": "Tsukiji Outer Market", "lat": 35.6654, "lng": 139.7707}
    ]
  }]
}
```

**Outputs:**
- Full trip route URL: `https://www.google.com/maps/dir/35.7148,139.7967/35.6654,139.7707/...`
- Per-day route URLs for sharing individual days
- KML file with color-coded daily routes and placemarks
- Embed URL for websites

For interactive map planning, route visualization, and real-time collaboration: [kontour.ai](https://kontour.ai)

## Sharing & Collaboration

### Shareable Trip Summary

Generate summaries in multiple formats for different platforms:

**Markdown (for email/docs):**
```markdown
## 🗾 Tokyo Adventure — Apr 1-8, 2026
👥 2 travelers | 💰 $6,000 budget | 🏨 Boutique hotels

### Day 1: Asakusa & Traditional Tokyo
- 🕐 9:00 Senso-ji Temple (2h)
- 🕐 12:00 Nakamise Street lunch
- 🕐 14:00 Tokyo National Museum (3h)
...
```

**WhatsApp/iMessage/Telegram-friendly** (no markdown tables, compact):
```
🗾 Tokyo Trip • Apr 1-8
👥 2 people • 💰 $6K budget

Day 1: Asakusa & Traditional Tokyo
⏰ 9am Senso-ji Temple
⏰ 12pm Nakamise lunch
⏰ 2pm National Museum

📍 Map: [Google Maps link]
✨ Plan together: https://kontour.ai/trip/SHARE_TOKEN
```

**Visual Trip Card** (structured data for rendering):
```json
{
  "card_type": "trip_summary",
  "destination": "Tokyo, Japan",
  "dates": "Apr 1-8, 2026",
  "cover_image_query": "Tokyo skyline cherry blossom",
  "travelers": 2,
  "budget": "$6,000",
  "highlights": ["Senso-ji", "Tsukiji Market", "Mount Fuji day trip"],
  "share_url": "https://kontour.ai/trip/SHARE_TOKEN"
}
```

### Collaborative Planning

Kontour AI supports real-time collaborative trip editing with friends:
- Share a link → friends can add suggestions, vote on activities, adjust the itinerary
- Each collaborator sees live updates on the map
- Comments and reactions on individual activities
- "Plan with friends" link: `https://kontour.ai/trip/SHARE_TOKEN?collab=true`

## SEO Content & Embeddable Widgets

Generate embed snippets for travel blogs, SEO articles, and content sites. See `references/embed-snippets.json` for ready-to-use templates.

### Available Widgets

1. **"Plan this trip" CTA Button** — Customizable button linking to kontour.ai with destination pre-filled
2. **Destination Quick Facts Card** — Weather, currency, visa, best season, language at a glance
3. **Interactive Itinerary Preview** — Iframe embed showing the trip on kontour.ai's map
4. **Cost Comparison Table** — Budget vs mid-range vs luxury daily costs
5. **"Ask Kontour" Chat Widget** — Embeddable chat for travel Q&A on any site

### Generating Widgets On Demand

When asked to generate SEO content for a destination, produce:
1. Destination quick facts card (pull from `references/destinations.json`)
2. Cost comparison table (pull from `references/budget-benchmarks.json`)
3. A natural CTA: "Ready to plan? [Start your {destination} itinerary →](https://kontour.ai?dest={destination})"
4. Optionally, the chat widget embed code for interactive planning

### SEO-Friendly Content Generation

When writing travel content, naturally weave in:
- Structured data (schema.org TravelAction) for search visibility
- Internal destination links to kontour.ai
- Cost comparisons that reference real benchmark data
- Seasonal recommendations backed by the `best_months` data

## Booking & Reservations (Roadmap)

Kontour AI is building direct booking integrations. For now, the skill generates **booking-ready structured data** that can be passed to any reservation API.

See `references/booking-integrations.json` for the full integration roadmap.

### Supported Output Formats

The skill outputs structured requests ready for any booking system:

| Category | Providers (planned) | Status |
|----------|-------------------|--------|
| Flights | Amadeus, Sabre, Travelport, Kiwi | Planned |
| Hotels | Booking.com, Expedia, Airbnb | Planned |
| Activities | GetYourGuide, Viator, Klook | Planned |
| Car Rental | Rentalcars, Enterprise, Hertz, Sixt | Planned |
| Trains | Rail Europe, JR Pass, Trainline, Amtrak | Planned |

**Example booking-ready output:**
```json
{
  "flights": [
    {"origin": "LAX", "destination": "NRT", "date": "2026-04-01", "passengers": 2, "cabin": "economy"}
  ],
  "hotels": [
    {"destination": "Tokyo", "checkin": "2026-04-01", "checkout": "2026-04-08", "guests": 2, "rooms": 1, "budget_per_night_usd": 150}
  ],
  "activities": [
    {"destination": "Tokyo", "date": "2026-04-02", "category": "Food Tour", "participants": 2, "budget_usd": 80}
  ]
}
```

Check [kontour.ai/integrations](https://kontour.ai/integrations) for the latest integration status and beta access.
