---
name: knowledge-distill
description: "知识蒸馏归档工具，将讨论成果按5类分类写入对应知识文档。支持小龙虾命令记忆库、专业工作知识、工作外知识、讨论过程、思维蒸馏五类归档。"
---

# 知识蒸馏 Skill（knowledge-distill）

将讨论成果分类写入对应的知识文档，支持便捷记录命令、知识结论、思维框架。

## 初始化

首次使用时，检查 `~/knowledge-base/` 是否存在：
- 不存在则自动创建目录和5个空文档
- 用户可通过设置 `KNOWLEDGE_BASE_PATH` 环境变量自定义路径

```
~/knowledge-base/
├── 小龙虾命令记忆库.md     ← OpenClaw/CLI 命令速查
├── 专业知识蒸馏.md         ← 专业领域技术结论
├── 兴趣知识蒸馏.md         ← 工作以外的学习内容
├── 学习研究日志.md         ← 每次讨论的过程记录
└── 思维蒸馏.md             ← 方法论、认知模型、思考框架
```

## 触发词

用户说以下任一内容时启动本 skill：
- "蒸馏" / "记录到文档" / "写入蒸馏" / "存起来"
- "记一下这个命令" / "存到命令库" / "记到命令记忆库"
- 讨论结束时说"总结一下"

## 五类文档分工

| 目标文档 | 写入条件 | 内容类型 |
|----------|---------|---------|
| 小龙虾命令记忆库.md | 用户说"记一下命令"、涉及 CLI/工具命令 | 命令格式、参数说明、使用场景、踩坑记录 |
| 专业知识蒸馏.md | 专业领域的技术结论 | 技术参数、操作步骤、规格数据、最佳实践 |
| 兴趣知识蒸馏.md | 工作以外的兴趣领域知识 | 与专业知识同等格式，仅领域不同 |
| 学习研究日志.md | 每次讨论的过程记录 | 问题背景、讨论过程、结论、演变脉络 |
| 思维蒸馏.md | 非具体内容的思维结晶 | 思考方式、方法论、认知模型、决策框架 |

## 执行流程

1. **判断分类**：根据内容和触发词判断写入哪个文档
2. **整理内容**：提炼核心结论，去掉试错过程
3. **展示预览**：在对话框展示整理好的内容和计划写入位置
4. **等待确认**：用户确认后才执行写入
5. **写入日志**：同步在学习研究日志记录本次讨论过程

## 小龙虾命令记忆库写入格式

```markdown
## [命令名称]
**用途**：一句话说明这个命令做什么
**命令**：
\`\`\`bash
命令格式
\`\`\`
**参数说明**：关键参数解释（可选）
**注意**：踩坑或注意事项（可选）
**日期**：记录时间
```

## 约束

- 未经用户确认不可写入任何文档
- 蒸馏只保留最终正确结论，不保留试错过程
- 日志保留讨论脉络和演变过程
- 修改前必须先展示增删内容
- 内容简洁，每条结论独立成块，便于检索
