# 语言 / Languages

本项目提供中英文双语文档。
This project provides documentation in both English and Chinese.

## English Documentation

- **[README.md](README.md)** - Complete overview and setup guide
- **[QUICKSTART.md](QUICKSTART.md)** - 5-minute getting started tutorial
- **[api-reference.md](api-reference.md)** - Full API endpoint documentation
- **[examples.md](examples.md)** - 20+ comprehensive usage examples
- **[SKILL.md](SKILL.md)** - Claude Code skill definition
- **[CHANGELOG.md](CHANGELOG.md)** - Version history and updates

## 中文文档

- **[README_CN.md](README_CN.md)** - 完整概述和设置指南
- **[QUICKSTART_CN.md](QUICKSTART_CN.md)** - 5分钟快速入门教程
- **[api-reference_CN.md](api-reference_CN.md)** - 完整 API 端点文档
- **[examples_CN.md](examples_CN.md)** - 20+ 综合使用示例

## Configuration Files

These files are language-independent:

- **[.env.example](.env.example)** - Environment configuration template
- **[.gitignore](.gitignore)** - Git ignore patterns
- **[skill.json](skill.json)** - Skill metadata
- **[FILE_STRUCTURE.txt](FILE_STRUCTURE.txt)** - Directory structure overview

## Scripts

Located in `scripts/`:

- **[knowfun-cli.sh](scripts/knowfun-cli.sh)** - Standalone CLI tool
- **[test-api.sh](scripts/test-api.sh)** - API connectivity test suite

---

## 快速导航 / Quick Navigation

### For English Speakers

**Start Here:**
1. Read [README.md](README.md) for an overview
2. Follow [QUICKSTART.md](QUICKSTART.md) to get started in 5 minutes
3. Refer to [api-reference.md](api-reference.md) for API details
4. Check [examples.md](examples.md) for code examples

**Get Help:**
- Web Portal: https://www.knowfun.io
- API Platform: https://www.knowfun.io/api-platform

### 中文用户

**从这里开始：**
1. 阅读 [README_CN.md](README_CN.md) 了解概述
2. 按照 [QUICKSTART_CN.md](QUICKSTART_CN.md) 5分钟快速开始
3. 参考 [api-reference_CN.md](api-reference_CN.md) 了解 API 详情
4. 查看 [examples_CN.md](examples_CN.md) 获取代码示例

**获取帮助：**
- 网站门户：https://www.knowfun.io
- API 平台：https://www.knowfun.io/api-platform

---

## Contributing Translations

If you'd like to contribute translations to other languages, please:

1. Create a new file with the language code suffix (e.g., `README_FR.md` for French)
2. Follow the same structure as existing translations
3. Add language switcher links at the top of the document
4. Update this LANGUAGES.md file with the new translation

如果您想贡献其他语言的翻译，请：

1. 创建带有语言代码后缀的新文件（例如，法语为 `README_FR.md`）
2. 遵循现有翻译的相同结构
3. 在文档顶部添加语言切换链接
4. 更新此 LANGUAGES.md 文件以包含新翻译

---

