# Kite AI Agent Smart Wallet 用户手册

## 这是什么？

这是一个让你在Telegram里管理加密货币钱包的工具。

- 你自己运行Bot，私钥在你手里
- 用Telegram发送命令管理钱包
- 在Kite AI测试网上操作

## 准备工作

### 1. 安装Node.js

先检查有没有Node.js：
```bash
node --version
```

如果没有，去下载：https://nodejs.org （选LTS版本）

### 2. 获取测试币

1. 打开 https://faucet.gokite.ai
2. 输入你的钱包地址领测试币

### 3. 创建Telegram机器人

1. 打开Telegram，搜索 **@BotFather**
2. 发送 `/newbot`
3. 给机器人起个名字（如 KiteWallet）
4. @BotFather会给你一个 **Token**（记下来）

## 安装步骤

### 1. 下载代码

```bash
git clone <这里填仓库地址>
cd kite-wallet
```

### 2. 安装依赖

```bash
npm install
```

### 3. 配置

创建 `.env` 文件：

```env
PRIVATE_KEY=你的私钥
TELEGRAM_BOT_TOKEN=@BotFather给的Token
```

**注意：** 私钥要保管好，不要告诉任何人！

### 4. 启动

```bash
node telegram-bot.js
```

看到 `🤖 Kite Wallet Bot starting...` 就成功了！

## 使用方法

打开Telegram，找到你创建的机器人，开始发命令：

| 命令 | 功能 | 示例 |
|------|------|------|
| `/create` | 创建钱包 | 发送 `/create` |
| `/wallet` | 查看钱包地址 | 发送 `/wallet` |
| `/balance` | 查看余额 | 发送 `/balance` |
| `/session add` | 添加授权key | `/session add 0xABC... 0.5` |
| `/limit set` | 设置限额 | `/limit set 1` |
| `/send` | 转账 | `/send 0xABC... 0.1` |
| `/help` | 帮助 | 发送 `/help` |

## 常见问题

### 1. 私钥是什么？
私钥就像你的银行卡密码，有了它就能控制钱包。一定要保管好！

### 2. 测试币从哪来？
去 https://faucet.gokite.ai 领取

### 3. Bot打不开怎么办？
检查：
- Node.js安装了吗？
- .env文件配置对了吗？
- Token对吗？

### 4. 转账失败怎么办？
- 余额够不够？
- 网络有没有问题？
- 限额设置对了吗？

## 安全建议

1. **不要**把私钥告诉任何人
2. **不要**在公共场合运行Bot
3. **建议**用小钱包测试
4. **记得**备份私钥

## 相关链接

- Kite AI官网: https://gokite.ai
- 测试网浏览器: https://testnet.kitescan.ai
- 水龙头: https://faucet.gokite.ai

---

有问题随时问！
