# Subject Line Formulas: 50+ Proven Templates

**For the Kit Email Marketing Operator**

Use these formulas as inspiration, not rigid templates. Adapt to your brand voice and audience.

---

## Core Principles

**Length:** 27-73 characters (optimal for all email clients)  
**Goal:** Get the open (curiosity, urgency, benefit, or social proof)  
**Avoid:** Spam triggers (all caps, excessive punctuation, "free", "guarantee")

---

## 1. Curiosity + Specificity

**Formula:** [Intriguing claim] + [specific detail]

1. "Email subject lines that helped Jon Morrow sell 10,000 copies"
2. "The 3-minute hack that doubled my email opens"
3. "What 80% of email marketers get wrong (you probably do too)"
4. "I just discovered why your emails aren't getting opened"
5. "The weird trick that increased my click rate by 47%"
6. "This email mistake is costing you $10k/month"
7. "Why your best subscribers aren't opening your emails"
8. "The subject line formula nobody talks about"
9. "I tested 100 subject lines. Here's what worked."
10. "Your competitors are doing this (and you're not)"

**Why it works:** Creates information gap that demands to be filled.

---

## 2. Personalization + Value

**Formula:** [Name] + [specific benefit for them]

11. "[Name], I noticed your expertise in [topic]"
12. "[Name], here's 5 tips to increase [their goal]"
13. "A free [industry] guide just for you, [Name]"
14. "[Name], quick question about [their situation]"
15. "Thought of you when I found this, [Name]"
16. "[Name], this could save you 10 hours/week"
17. "For [Name] and other [their role]"
18. "[Name], your [specific pain point] solution is here"
19. "[Name], I built this for people like you"
20. "Hey [Name], remember when we talked about [topic]?"

**Why it works:** Personal + relevant = irresistible.

---

## 3. Urgency + Benefit

**Formula:** [Time pressure] + [what they'll get]

21. "Open immediately: Your key to [specific benefit]"
22. "Time is running out: Free class ends in 24 hours"
23. "Last chance to save [X]% on [product]"
24. "Price goes up tomorrow (lock in now)"
25. "Only 10 spots left for [opportunity]"
26. "Don't miss this: [Event] starts in 2 hours"
27. "Your access expires tonight"
28. "Final call: [Offer] closes Friday"
29. "Tomorrow it's gone (don't regret this)"
30. "Deadline approaching: [Opportunity] ends [date]"

**Why it works:** FOMO (fear of missing out) drives action.

---

## 4. Social Proof

**Formula:** [Authority/numbers] + [result/insight]

31. "We studied the best [experts]. Here's what we found"
32. "Elon Musk just shared his top 5 [relevant tips]"
33. "How [company] increased [result] by 80%"
34. "10,000 marketers use this exact strategy"
35. "The email formula used by [industry leader]"
36. "[Famous person]'s secret to [achievement]"
37. "247 businesses just implemented this (you're next)"
38. "The tactic that helped [name] hit [impressive result]"
39. "What I learned spending $50k on email marketing"
40. "Case study: $0 to $100k with these 7 emails"

**Why it works:** Borrowed credibility + proof = trust.

---

## 5. Question Hooks

**Formula:** Ask what they're thinking/feeling

41. "Are you tired of struggling with [pain point]?"
42. "What if I told you [surprising claim]?"
43. "Still interested in [topic]?"
44. "Ever wonder why [common frustration]?"
45. "Can I ask you a quick question?"
46. "Ready to stop [negative behavior]?"
47. "What's holding you back from [goal]?"
48. "How much money are you leaving on the table?"
49. "Want to know the #1 reason [problem happens]?"
50. "Curious why [unexpected result]?"

**Why it works:** Questions create mental engagement.

---

## 6. Pattern Interrupts

**Formula:** Say something unexpected

51. "Forget everything you know about [topic]"
52. "This isn't another [type] email"
53. "I made a mistake that cost me $5,000"
54. "Confession: I've been lying to you"
55. "Please ignore this email"
56. "You're going to hate me for this"
57. "This might sound crazy, but..."
58. "Unpopular opinion: [controversial take]"
59. "I'm shutting down [thing] on Friday"
60. "Why I'm giving away [valuable thing] for free"

**Why it works:** Breaks pattern, captures attention.

---

## 7. Direct Benefit

**Formula:** Clear value proposition

61. "Save 10 hours/week with this simple system"
62. "Double your email opens in 30 days"
63. "The fastest way to [achieve goal]"
64. "How to [result] in [timeframe]"
65. "Get more [desired outcome] with less effort"
66. "The lazy person's guide to [achievement]"
67. "Stop [painful activity] forever"
68. "Finally: [solution to common problem]"
69. "The only [tool/guide] you need for [goal]"
70. "Easier than you think: [daunting task made simple]"

**Why it works:** Clear value = clear reason to open.

---

## 8. Storytelling Hooks

**Formula:** Begin a narrative

71. "Yesterday, something weird happened..."
72. "Three years ago, I was broke. Today..."
73. "The day I realized [insight]"
74. "They said it couldn't be done. We did it anyway."
75. "My biggest mistake (and what I learned)"
76. "From [negative state] to [positive state] in [time]"
77. "I wasn't supposed to share this, but..."
78. "The conversation that changed everything"
79. "This almost didn't happen"
80. "What nobody told me about [experience]"

**Why it works:** Stories create emotional connection.

---

## Usage Guidelines

### When to Use Each Type

**Curiosity:** Launch emails, content teasers, re-engagement  
**Personalization:** Relationship-building, segmented campaigns  
**Urgency:** Sales, deadlines, limited offers  
**Social Proof:** Credibility-building, launch emails  
**Questions:** Engagement, survey invitations, checking in  
**Pattern Interrupt:** Re-engagement, attention-grabbing  
**Direct Benefit:** Educational content, lead magnets, value delivery  
**Storytelling:** Relationship emails, personal updates

### A/B Testing

Always test:
- Short vs long
- Question vs statement
- Personalized vs generic
- Benefit-focused vs curiosity-driven

Track what works for YOUR audience.

### Red Flags (Avoid)

❌ All caps: "ACT NOW OR MISS OUT"  
❌ Excessive punctuation: "Quick question???"  
❌ Spam words: "free money", "earn cash", "guaranteed"  
❌ Misleading: Subject doesn't match content  
❌ Too vague: "Quick question" (about what?)  
❌ Too long: Gets cut off on mobile

### Mobile Optimization

60%+ of emails are opened on mobile. Keep subject lines under 50 characters for mobile or front-load the hook.

**Desktop (70 chars):** "We studied 10,000 email campaigns and found 3 patterns that predict success"  
**Mobile (40 chars):** "3 patterns that predict email success"

---

## Combining Formulas

The best subject lines often combine elements:

**Curiosity + Urgency:**
"This closes tomorrow (don't miss it)"

**Personalization + Social Proof:**
"[Name], 1,000 marketers just discovered this"

**Question + Benefit:**
"Want to double your opens in 14 days?"

**Story + Pattern Interrupt:**
"I quit my job to test this theory. Here's what happened."

---

## Final Tips

1. **Write 10, pick 3** - Generate options, test the best
2. **Match your voice** - Formal vs casual depends on brand
3. **Consider context** - Welcome vs sales vs content have different tones
4. **Front-load value** - Put the hook first (mobile cuts off the end)
5. **Stay authentic** - Clickbait damages trust long-term
6. **Track and iterate** - What works for others might not work for you

---

**Use these as inspiration. Adapt to your brand. Test relentlessly. Win.**
