# Email Sequence Templates

**Pre-built email sequences for common use cases**

---

## How to Use These Templates

Each template includes:
- **Purpose:** What the sequence achieves
- **Structure:** Number of emails and timing
- **Content guidelines:** What each email should cover
- **Success metrics:** How to measure performance

**Implementation in Kit:**
1. Create sequence in Kit UI (API cannot create sequences)
2. Use these templates as blueprints
3. Generate actual content using Kit Email Operator skill
4. Copy/paste into Kit sequence builder

---

## Template 1: Welcome Sequence (5-Email)

**Purpose:** Onboard new subscribers, build relationship, introduce core offer

**Timeline:** 14 days  
**Expected Performance:** 40-60% open rate, 5-10% click rate  
**Conversion Goal:** 2-5% to paid offer by end of sequence

### Email 1: Immediate Welcome (Send: Immediately)

**Subject Options:**
- "Welcome to [Your Brand]! Here's what to expect"
- "[Name], your [lead magnet] is ready"
- "Let's get you started, [Name]"

**Content Structure:**
```
[Warm Welcome]
Thank you for joining! You're now part of [community/list].

[Deliver Promise]
Here's your [lead magnet]:
[Download Link/Button]

[Set Expectations]
Over the next 2 weeks, I'll share:
• Day 1: [Topic 1]
• Day 3: [Topic 2]
• Day 7: [Topic 3]

[One Ask]
Add me to your contacts so you don't miss anything.

[Friendly Close]
Looking forward to helping you [achieve goal]!

[Signature]
```

**Length:** 100-150 words  
**CTA:** Download lead magnet + add to contacts

---

### Email 2: Quick Win (Send: 24 hours later)

**Subject Options:**
- "[Name], here's your first win"
- "The one thing you can do today to [outcome]"
- "Quick tip: [Specific actionable advice]"

**Content Structure:**
```
[Personal Greeting]
Yesterday you joined [community]. Welcome again!

[Acknowledge Download]
Hopefully you've had a chance to check out [lead magnet].

[Quick Win]
Here's something you can implement TODAY to [achieve quick outcome]:

[Step 1]
[Step 2]
[Step 3]

[Why It Works]
This works because [explanation].

[Social Proof]
I've seen [number] people get [result] using this exact method.

[Engagement Ask]
Reply and let me know how it goes!

[Signature]
```

**Length:** 150-250 words  
**CTA:** Try the technique, reply with results

---

### Email 3: Story/Connection (Send: 3 days after signup)

**Subject Options:**
- "Why I started [Your Brand]"
- "The day everything changed"
- "My [struggle/mistake] and what I learned"

**Content Structure:**
```
[Story Hook]
I want to share why I started [business/list/community]...

[The Struggle]
A few years ago, I was [struggling with X].

I tried [method 1], [method 2], [method 3]—nothing worked.

[The Turning Point]
Then I discovered [key insight/method].

[The Transformation]
Within [timeframe], I [achieved result].

[The Mission]
Now I'm on a mission to help [audience] do the same.

[Connection to Reader]
If you're [current struggle], you're exactly where I was.

[Next Step]
Tomorrow, I'll share [next topic].

[Signature]
```

**Length:** 200-300 words  
**CTA:** Emotional connection (no hard ask)

---

### Email 4: Social Proof (Send: 5 days after signup)

**Subject Options:**
- "How [Customer Name] achieved [Result]"
- "Case study: From [Before] to [After]"
- "[Number] ways people are using [solution]"

**Content Structure:**
```
[Case Study Introduction]
Meet [Customer Name], a [description] just like you.

[Before State]
[Time period] ago, they were struggling with [problem]:
• [Pain point 1]
• [Pain point 2]
• [Pain point 3]

[The Solution]
They tried [your method/product]:
[Key strategy/feature]

[The Process]
Here's what happened:
• Week 1: [Progress]
• Week 2: [Progress]
• Week 4: [Result]

[Results]
Today, they've achieved:
• [Metric 1]
• [Metric 2]
• [Metric 3]

[Testimonial Quote]
"[Direct quote from customer]"

[Bridge to Reader]
Want similar results?

[Soft Offer]
I can help. [Learn more about product/service]

[Signature]
```

**Length:** 200-300 words  
**CTA:** Learn more (soft sell)

---

### Email 5: Core Offer (Send: 7 days after signup)

**Subject Options:**
- "Ready for the next step?"
- "Your roadmap to [outcome]"
- "Here's how I can help you [achieve goal]"

**Content Structure:**
```
[Recap Journey]
Over the last week, you've:
• Downloaded [lead magnet]
• Learned [key lesson 1]
• Seen how [customer] achieved [result]

[The Next Level]
Here's what comes next if you're serious about [outcome]:

[Core Offer Introduction]
[Product/Service Name]: [One-line description]

[What You Get]
• [Benefit 1]
• [Benefit 2]
• [Benefit 3]

[Who It's For]
Perfect if you're:
✓ [Criteria 1]
✓ [Criteria 2]
✓ [Criteria 3]

[Objection Handling]
"But what if [common objection]?"
[Answer]

[Guarantee/Risk Reversal]
[Money-back guarantee or other risk reversal]

[Clear CTA]
Ready to start? [Get [Product] now]

[Alternative]
Not ready yet? That's okay—stay on the list and keep learning.

[Signature]
```

**Length:** 250-350 words  
**CTA:** Purchase/upgrade (direct sell)

---

**Welcome Sequence Performance Metrics:**
- Email 1 Open Rate: 60-80% (highest)
- Email 2 Open Rate: 40-60%
- Email 3 Open Rate: 35-50%
- Email 4 Open Rate: 30-45%
- Email 5 Open Rate: 25-40%
- Sequence Conversion: 2-5% (to paid offer)

---

## Template 2: Product Launch Sequence (7-Email)

**Purpose:** Build anticipation and sell new product/service

**Timeline:** 14 days (7 pre-launch, 7 launch)  
**Expected Performance:** 30-50% open rate, 10-15% conversion  
**Conversion Goal:** 5-10% of list purchases

### Pre-Launch Phase

### Email 1: Teaser (Send: 7 days before launch)

**Subject:** "Something big is coming..."  
**Content:** Hint at problem your product solves, build curiosity  
**Length:** 100-150 words  
**CTA:** "Get notified" (collect interest)

---

### Email 2: Story (Send: 5 days before launch)

**Subject:** "Why I built [Product Name]"  
**Content:** Origin story, emotional connection  
**Length:** 200-300 words  
**CTA:** "Learn more"

---

### Email 3: Sneak Peek (Send: 3 days before launch)

**Subject:** "Exclusive preview: Inside [Product]"  
**Content:** Feature highlights, testimonials (beta users)  
**Length:** 200-300 words  
**CTA:** "Reserve your spot"

---

### Launch Phase

### Email 4: Launch Announcement (Send: Day 0, 10 AM Tuesday)

**Subject:** "🚀 It's here! [Product] is now available"

**Content Structure:**
```
[Excitement]
Today's the day! [Product Name] is officially live.

[Problem + Solution]
If you've ever struggled with [problem], this is for you.

[What It Does]
[Product] helps you [main benefit]:
• [Feature/benefit 1]
• [Feature/benefit 2]
• [Feature/benefit 3]

[Pricing]
[Price] → [Early-bird price] (ends [deadline])

[Early-Bird Bonus]
Order in the next 48 hours and get:
• [Bonus 1]
• [Bonus 2]

[Strong CTA]
Get [Product] now → [Link]

[Signature]
```

**Length:** 200-300 words

---

### Email 5: Social Proof (Send: 2 days after launch)

**Subject:** "What customers are saying about [Product]"  
**Content:** Testimonials, early results, FAQ  
**Length:** 250-350 words  
**CTA:** "Join [number] happy customers"

---

### Email 6: Scarcity (Send: 5 days after launch)

**Subject:** "Final hours: Bonuses disappear at midnight"  
**Content:** Urgency, FOMO, last testimonial  
**Length:** 150-250 words  
**CTA:** "Claim your bonuses"

---

### Email 7: Last Call (Send: 7 days after launch, 6 PM)

**Subject:** "Doors closing: Last chance for [Product]"

**Content Structure:**
```
[Direct Opening]
This is it. [Product] closes in [hours].

[Recap Benefits]
Last chance to get:
• [Benefit 1]
• [Benefit 2]
• [Bonus 1]
• [Bonus 2]

[Final Testimonial]
"[Powerful quote]" - [Customer]

[Urgency]
After [time], the price goes up [amount] and bonuses disappear.

[Final CTA]
Get [Product] before it's gone → [Link]

[Alternative]
Not ready? No problem—but you'll miss the bonuses.

[Signature]
```

**Length:** 100-200 words (short and punchy)

---

**Launch Sequence Performance Metrics:**
- Email 4 (Launch): 40-60% open, 8-12% click
- Email 5 (Social Proof): 30-45% open, 6-10% click
- Email 6 (Scarcity): 35-50% open, 10-15% click
- Email 7 (Last Call): 45-65% open (highest), 12-18% click
- Overall Conversion: 5-10% of list

**Pro Tip:** Suppress anyone who purchases from remaining emails (tag: "Purchased_[Product]")

---

## Template 3: Nurture Sequence (6-Week)

**Purpose:** Build relationship, establish authority, warm up cold leads

**Timeline:** 42 days (6 weeks)  
**Frequency:** 1-2 emails per week  
**Content Mix:** 80% value, 20% promotion  
**Conversion Goal:** Move to sales-qualified (ready for pitch)

### Week 1: Educational

**Email 1 (Day 0): How-To Guide**  
**Subject:** "How to [achieve outcome] in [timeframe]"  
**Content:** Step-by-step tutorial  
**CTA:** Try it and reply with results

---

### Week 2: Social Proof

**Email 2 (Day 7): Case Study**  
**Subject:** "How [Customer] achieved [Result]"  
**Content:** Detailed transformation story  
**CTA:** See more success stories

---

### Week 3: Authority Building

**Email 3 (Day 14): Industry Insights**  
**Subject:** "What I learned from [event/research/experience]"  
**Content:** Thought leadership, trends  
**CTA:** What do you think? (engagement)

---

### Week 4: Engagement Prompt

**Email 4 (Day 21): Survey/Question**  
**Subject:** "Quick question, [Name]"  
**Content:** Ask about their biggest challenge  
**CTA:** Reply with your answer

---

### Week 5: Educational + Soft Sell

**Email 5 (Day 28): Framework/Strategy**  
**Subject:** "The [Framework Name] strategy"  
**Content:** Your methodology + mention product  
**CTA:** Learn more (soft sell)

---

### Week 6: Direct Offer

**Email 6 (Day 35): Offer**  
**Subject:** "Ready to [achieve goal]? Here's how I can help"  
**Content:** Clear offer with benefits  
**CTA:** Purchase/book call

---

**Nurture Sequence Performance Metrics:**
- Average Open Rate: 25-35%
- Average Click Rate: 3-6%
- Engagement Rate: 40-60% (opened at least once)
- Conversion to SQL: 10-20%

---

## Template 4: Re-Engagement Sequence (3-Email)

**Purpose:** Win back inactive subscribers or remove them

**Timeline:** 10 days  
**Trigger:** No opens in 60-90 days  
**Conversion Goal:** 10-20% re-engage, rest unsubscribe (clean list)

### Email 1: We Miss You (Send: Day 0)

**Subject Options:**
- "We miss you, [Name]"
- "Are you still interested in [topic]?"
- "Should we keep sending emails?"

**Content Structure:**
```
[Honest Opening]
I noticed you haven't opened my emails in a while.

[Acknowledge Change]
Maybe your interests changed.
Maybe our content isn't relevant anymore.
Maybe you're just busy.

[The Question]
Here's what I want to know:

Are you still interested in [topic]?

[Two Options]
**YES → Click here** to stay subscribed (and tell me what you want more of)

**NO → Click here** to unsubscribe (no hard feelings)

[Why It Matters]
I only want to send emails to people who actually want them.

If you're not opening, I'm wasting your time and my effort.

[Simple Close]
Let me know?

[Signature]
```

**Length:** 100-150 words  
**CTA:** Yes (stay) or No (unsubscribe)

---

### Email 2: Here's What You Missed (Send: 3 days later if no action)

**Subject Options:**
- "Here's what you've been missing"
- "Our best content from the last [timeframe]"
- "Catching you up..."

**Content Structure:**
```
[Friendly Reminder]
You're still on my list, which means you haven't unsubscribed yet.

[Value Recap]
Here's what you've missed over the last [timeframe]:

📧 **[Email 1 Topic]**: [One-line description]
[Link]

📧 **[Email 2 Topic]**: [One-line description]
[Link]

📧 **[Email 3 Topic]**: [One-line description]
[Link]

[Special Offer]
As a thank-you for staying, here's something special:
[Exclusive resource/discount]

[Clear Choice]
Want back in? [Click here]

Done with us? [Unsubscribe here]

[Signature]
```

**Length:** 150-200 words  
**CTA:** Click content or unsubscribe

---

### Email 3: Last Chance (Send: 7 days after Email 1 if no action)

**Subject Options:**
- "Should we say goodbye, [Name]?"
- "Last email: Want to stay subscribed?"
- "One last question..."

**Content Structure:**
```
[Direct Opening]
This is my last email to you.

[The Situation]
You haven't opened anything in [days], and I respect your inbox.

[Two Clicks]
Only two options:

**1. Stay subscribed** → [Click here]
(I'll reset your profile and send relevant content)

**2. Unsubscribe** → [Click here]
(Clean break, no hard feelings)

[Auto-Remove Warning]
If I don't hear from you by [deadline], I'll automatically remove you from the list.

[Gratitude]
Thanks for being here, even if it's time to say goodbye.

[Signature]
```

**Length:** 75-125 words (short and direct)  
**CTA:** Stay or go (forced choice)

---

**Re-Engagement Sequence Performance Metrics:**
- Email 1 Open Rate: 5-15% (inactive audience)
- Email 2 Open Rate: 8-20% (curiosity bump)
- Email 3 Open Rate: 10-25% (final chance)
- Re-engagement Rate: 10-20%
- Unsubscribe Rate: 5-15%
- Auto-remove: 65-85%

**Success = Cleaning your list + re-engaging those who care**

---

## Template 5: Cart Abandonment Sequence (3-Email)

**Purpose:** Recover lost sales from abandoned carts

**Timeline:** 7 days  
**Trigger:** Item added to cart, no purchase  
**Conversion Goal:** 15-30% recovery rate

### Email 1: Friendly Reminder (Send: 1 hour after abandonment)

**Subject:** "You left something behind..."  
**Content:** Show cart items, remove obstacles  
**Length:** 100 words  
**CTA:** Complete your order

---

### Email 2: Incentive (Send: 24 hours after abandonment)

**Subject:** "Still thinking it over? Here's 10% off"  
**Content:** Discount code, urgency (48-hour expiry)  
**Length:** 100-150 words  
**CTA:** Use code and checkout

---

### Email 3: Last Chance (Send: 3 days after abandonment)

**Subject:** "Your cart expires in 24 hours"  
**Content:** Final reminder, scarcity  
**Length:** 75-100 words  
**CTA:** Complete purchase

---

**Cart Abandonment Performance Metrics:**
- Email 1: 40-50% open, 10-15% conversion
- Email 2: 30-40% open, 8-12% conversion
- Email 3: 25-35% open, 5-10% conversion
- Total Recovery: 15-30% of abandoned carts

---

## Template 6: Post-Purchase Sequence (4-Email)

**Purpose:** Onboard customers, reduce refunds, upsell

**Timeline:** 30 days  
**Trigger:** Purchase completed  
**Conversion Goal:** Reduce churn, increase LTV

### Email 1: Thank You + Getting Started (Send: Immediately)

**Subject:** "Thank you! Here's what's next"  
**Content:** Confirmation, onboarding steps, support  
**Length:** 150 words  
**CTA:** Start using product

---

### Email 2: Quick Win (Send: 3 days after purchase)

**Subject:** "Your first win with [Product]"  
**Content:** Easy tutorial for quick result  
**Length:** 200 words  
**CTA:** Try this feature

---

### Email 3: Advanced Tips (Send: 7 days after purchase)

**Subject:** "Getting more out of [Product]"  
**Content:** Advanced features, tips  
**Length:** 200-250 words  
**CTA:** Learn advanced techniques

---

### Email 4: Upsell (Send: 30 days after purchase)

**Subject:** "Ready to level up?"  
**Content:** Complementary product or upgrade  
**Length:** 200-250 words  
**CTA:** Upgrade or purchase add-on

---

**Post-Purchase Performance Metrics:**
- Email 1: 70-90% open (highest)
- Email 2: 50-70% open
- Email 3: 40-60% open
- Email 4: 35-50% open
- Upsell Conversion: 10-25%

---

## Sequence Best Practices

### Timing

**Optimal Send Times:**
- Welcome/Transactional: Immediate
- Educational: Tuesday-Thursday, 10 AM
- Promotional: Wednesday-Friday, 2 PM
- Re-engagement: Thursday, 11 AM (mid-week, mid-day)

**Optimal Delays:**
- Fast sequences: 1-3 days between emails
- Nurture: 3-7 days between emails
- Long-term: 7-14 days between emails

---

### Exit Conditions

**Stop sending when:**
- Subscriber completes goal (purchase, registration, etc.)
- Subscriber unsubscribes
- Subscriber joins another sequence
- Hard bounce
- Spam complaint

**Kit Implementation:**
- Use tags to track conversions
- Segment out purchasers
- Manually suppress or use automation rules

---

### Performance Tracking

**Measure:**
- Open rate (per email and sequence average)
- Click rate (per email and sequence average)
- Conversion rate (sequence goal completion)
- Unsubscribe rate (should be <0.5% per email)
- Bounce rate (should be <2%)

**Optimize:**
- A/B test subject lines on Email 1
- Test send times
- Adjust delays between emails
- Rewrite low-performing emails
- Remove emails that don't contribute

---

### Content Guidelines

**Email 1:** Hook and deliver immediate value  
**Email 2-3:** Build relationship and trust  
**Email 4-5:** Establish authority with social proof  
**Final Email:** Clear CTA and offer

**Every Email Should:**
- Have ONE primary goal
- Include ONE primary CTA
- Be mobile-optimized
- Match brand voice
- Provide value (even promotional emails)

---

## Customization Tips

**To adapt these templates:**

1. **Change timeline** based on your sales cycle
   - B2B: Longer sequences (8-12 weeks)
   - E-commerce: Shorter sequences (3-7 days)
   
2. **Adjust tone** to match your brand
   - Professional: More formal language
   - Casual: More conversational, relaxed

3. **Add/remove emails** based on complexity
   - Simple product: 3-email launch
   - Complex service: 10-email nurture

4. **Personalize** with custom fields
   - Industry-specific examples
   - Behavior-based content
   - Custom recommendations

---

## Implementation Checklist

Before launching a sequence:

- [ ] All emails written and reviewed
- [ ] Subject lines A/B tested (at least Email 1)
- [ ] Personalization tags tested
- [ ] Mobile preview checked
- [ ] Links tested and working
- [ ] Exit conditions set (suppress converters)
- [ ] Analytics tracking configured
- [ ] Team aligned on goals and metrics
- [ ] Test subscriber run through sequence
- [ ] Support team briefed (if needed)

---

**Remember:** These are templates, not rigid formulas. Adapt them to your audience, brand, and goals. Test everything. Optimize based on data.

---

**Version 1.0.0** | Last Updated: 2026-02-17
