# Nurture Email Examples

**Use Case:** Build relationship with leads who aren't ready to buy  
**Goal:** Provide value, establish authority, warm up for future offer  
**Frequency:** 1-2 times per week  
**Expected Performance:** 25-35% open rate, 3-6% click rate

---

## Example 1: Educational How-To (Course Creator)

### Context
Week 2 of nurture sequence. Subscriber downloaded lead magnet but hasn't purchased course yet.

### Subject Line Options

**Option 1:** "The #1 productivity mistake I see entrepreneurs make"

**Option 2:** "{{ subscriber.first_name }}, are you making this time-management mistake?"

**Option 3:** "How to get 3 hours back every week (it's not what you think)"

**Winner:** Option 3 (curiosity + specific benefit = 32% open rate)

---

### Email Body

```
Subject: How to get 3 hours back every week (it's not what you think)

---

Hey {{ subscriber.first_name }},

Last week you downloaded my Productivity System guide. Hopefully you've had a chance to implement at least one strategy.

Today, I want to share the single biggest time-waster I see—and it's NOT what you'd expect.

It's not social media.
It's not meetings.
It's not email.

**It's context switching.**

Here's what I mean...

**The problem:**

You're writing a blog post. An email comes in. You check it. You respond. You go back to the blog post.

But now you've lost your flow. It takes 15-23 minutes to get back into "deep work mode" (according to research from UC Irvine).

That email cost you 20 minutes, not 2.

Do that 10 times a day? You've lost 3+ hours to context switching.

**The solution:**

**Time blocking + "Context Batching"**

Instead of switching between tasks randomly, group similar tasks together:

• **Content block:** 9-11 AM — Write all your content (blog, emails, social)
• **Communication block:** 11 AM-12 PM — All emails, Slack, calls
• **Admin block:** 4-5 PM — Invoices, scheduling, filing

Your brain stays in "one mode" for longer, so you work faster and better.

**How to start:**

1. Look at your calendar for tomorrow
2. Block 2-hour chunks for your 3 most important task types
3. During each block, ONLY do that type of work (no exceptions)

Try it for one week. I promise you'll feel the difference.

**Want help implementing this?**

I've created a "Time Block Template" you can copy:
[Get the Template]

It's the exact schedule I use to run 3 businesses and still work <40 hours/week.

Let me know how it goes!

Sarah

P.S. — Next week, I'll share my "energy audit" technique. It helped me identify which tasks drain me (so I can delegate them) vs. which ones energize me (so I can do more of them). Game-changer.

---

[Unsubscribe] | Update preferences
The Productivity Lab | 123 Main St, San Francisco, CA 94102
```

---

### Why This Works

✅ **Addresses real pain:** Context switching is relatable  
✅ **Backed by research:** UC Irvine study adds credibility  
✅ **Specific solution:** 3 steps to implement  
✅ **Quick win:** Can try tomorrow  
✅ **CTA provides more value:** Template is helpful, not salesy  
✅ **Preview of next email:** Keeps them engaged  
✅ **Conversational tone:** Feels like advice from a friend  

---

## Example 2: Case Study (SaaS Product)

### Context
Week 3 of nurture. Trial user exploring features but hasn't converted to paid yet.

### Subject Line Options

**Option 1:** "How [Company Name] saved 15 hours/week with one automation"

**Option 2:** "Case study: $120K/year saved with this workflow"

**Option 3:** "{{ subscriber.first_name }}, here's what our best customers do differently"

**Winner:** Option 1 (specific outcome + "one automation" = 29% open rate)

---

### Email Body

```
Subject: How TechCorp saved 15 hours/week with one automation

---

Hi {{ subscriber.first_name }},

Quick question: How much time does your team spend manually processing customer emails?

For TechCorp (a 50-person SaaS company), the answer was **15 hours per week**.

That's 780 hours per year. At $50/hour, that's **$39,000 in wasted labor.**

**Then they set up one [Product Name] automation.**

**The Challenge:**

TechCorp's support team was drowning. They received 500+ emails daily:

• Customer questions
• Bug reports  
• Feature requests  
• Sales inquiries
• Spam

Everything went to one inbox. The team spent hours triaging before they could even START solving problems.

**The Solution:**

They used [Product Name] to create automatic routing rules:

• **Rule 1:** Route emails with "bug" or "error" → Engineering team
• **Rule 2:** Route emails asking about pricing → Sales team  
• **Rule 3:** Route FAQ topics → Auto-respond with help docs
• **Rule 4:** Everything else → Support team (prioritized by urgency)

**Setup time:** 45 minutes

**The Results (First Month):**

• ⏱️ 15 hours/week saved (no more manual triaging)
• 📈 Response time dropped from 4 hours → 45 minutes
• 😊 Customer satisfaction up 23%
• 💰 $39,000/year in labor savings

**Here's what Sarah (Head of Support) said:**

> "I honestly didn't believe it would work this well. We've tried other tools, but [Product] just... gets it. The AI learns from our patterns and gets smarter over time. Now my team actually spends time helping customers, not sorting emails."

**Want to try the same automation?**

I've created a step-by-step guide specifically for SaaS companies:
[Get the SaaS Automation Playbook]

It includes:
• Pre-built rule templates (copy/paste)
• FAQ auto-responder setup
• Priority scoring system
• Email routing flowcharts

Takes about 30 minutes to implement. Could save your team hundreds of hours.

Let me know if you have questions!

Alex
Customer Success, [Product Name]

P.S. — TechCorp started with one automation. Now they have 47 rules handling 80% of their email volume automatically. If you want help planning YOUR automation stack, just reply and I'll send you a custom recommendation.

---

[Unsubscribe] | [Help Center] | [Schedule Demo]
[Product Name] | 456 Tech Blvd, Austin, TX 78701
```

---

### Why This Works

✅ **Quantified results:** Specific hours and dollars saved  
✅ **Relatable challenge:** Every team has email overload  
✅ **Clear before/after:** Easy to visualize transformation  
✅ **Testimonial quote:** Adds authenticity  
✅ **Actionable resource:** Playbook provides immediate value  
✅ **Soft upsell in P.S.:** "Custom recommendation" = sales call entry point  

---

## Example 3: Story/Thought Leadership (Newsletter)

### Context
Week 4 of nurture. Building authority and emotional connection.

### Subject Line Options

**Option 1:** "The day I almost gave up on my newsletter"

**Option 2:** "{{ subscriber.first_name }}, I need to tell you something"

**Option 3:** "What I learned from 52 weeks of writing"

**Winner:** Option 1 (vulnerability + curiosity = 35% open rate)

---

### Email Body

```
Subject: The day I almost gave up on my newsletter

---

Hey {{ subscriber.first_name }},

I need to be honest with you.

**Six months ago, I almost quit this newsletter.**

I'd been writing every Tuesday for 18 months. Pouring my heart into every essay. Spending 6-8 hours per email.

And I had... 243 subscribers.

That's it. After a year and a half.

I did the math: $0 in revenue. 400+ hours invested. That's a terrible ROI.

My wife said, "Maybe it's time to try something else."

She was right. It wasn't working.

**But here's the thing I didn't realize...**

I was measuring the wrong metrics.

Yes, I only had 243 subscribers. But...

• 38% of them opened EVERY email (that's insane)
• 12 people replied to EVERY essay
• 3 people became clients (worth $50K+ combined)
• 1 person became a close friend

**I wasn't building an audience. I was building a community.**

And communities don't scale linearly. They compound.

Those 12 super-engaged readers? They shared my essays. They told their friends. They vouched for me.

Within 6 months, I went from 243 → 2,000 subscribers. Within 12 months, 10,000.

Today: 50,000.

**The lesson:**

Stop optimizing for size. Optimize for depth.

I see so many creators chasing big numbers:
• 10K subscribers
• 100K followers  
• 1M views

But what matters more is: **Do people care?**

Would you rather have:
• 10,000 subscribers who never open your emails?
• Or 1,000 subscribers who read every word and tell their friends?

I'll take the 1,000 every time.

**How to build depth (not just size):**

1. **Ask questions.** Every email should invite a response.
2. **Tell the truth.** Vulnerability > polish.
3. **Focus on one person.** Write like you're talking to your best friend, not a crowd.
4. **Measure engagement, not size.** Open rates and replies > subscriber count.

If you're early in your journey and feel discouraged by "small" numbers, remember:

**Small and engaged > big and indifferent.**

I'm living proof.

Keep going.

Marcus

P.S. — If you're building your own newsletter/audience/community, I'd love to hear about it. Just hit reply and tell me: What are you building? What's been hardest? I read every response.

---

[Unsubscribe] | [Read past essays] | [About me]
The Creative Misfit | marcuslee.com
```

---

### Why This Works

✅ **Vulnerable opening:** "I almost quit" = immediate hook  
✅ **Relatable struggle:** Every creator has felt this  
✅ **Mindset shift:** "Measure depth, not size" is valuable advice  
✅ **Specific numbers:** Transparency builds trust  
✅ **Actionable takeaway:** 4 steps to implement  
✅ **Engagement prompt:** "Tell me what you're building"  
✅ **No hard sell:** Pure value, no pitch  

---

## Example 4: Authority Building (Consultant)

### Context
Week 5 of nurture. Establishing expertise before making an offer.

### Subject Line Options

**Option 1:** "The 3 biggest myths about [industry/topic]"

**Option 2:** "{{ subscriber.first_name }}, most people get this wrong"

**Option 3:** "What I learned from working with 100+ [target audience]"

**Winner:** Option 3 (social proof + authority = 28% open rate)

---

### Email Body

```
Subject: What I learned from working with 100+ SaaS founders

---

Hi {{ subscriber.first_name }},

Over the last 4 years, I've helped 127 SaaS founders improve their onboarding.

I've seen what works. And more importantly, what doesn't.

**Here are the 3 biggest mistakes I see (and how to fix them):**

---

**Mistake #1: Asking for too much, too soon**

❌ **What founders do:**
30-field signup form. "Tell us about your company, team size, use case, budget..."

✅ **What works:**
Email + password. That's it. Get them IN, THEN ask for details.

**Why:** Every field you add reduces signups by 10-20%. Get the email first. You can always ask for more later.

**Real example:** One client dropped from 12 fields → 2 fields. Signups increased 67%.

---

**Mistake #2: Feature dumping in the first session**

❌ **What founders do:**
"Here are all 47 features! Let me show you everything!"

✅ **What works:**
One feature. One "aha moment." One quick win.

**Why:** Overwhelmed users churn. Focus on the ONE thing that makes them say "wow, this is useful."

**Real example:** Client went from 30-minute product tour → 3-minute focused demo. Trial-to-paid conversion up 41%.

---

**Mistake #3: No follow-up after trial starts**

❌ **What founders do:**
User signs up. Crickets. Check back in 2 weeks: "Trial expiring soon!"

✅ **What works:**
Email sequence triggered on Day 1, 3, 7, 10, 13:
• Day 1: Welcome + quick win
• Day 3: Use case inspiration
• Day 7: Advanced tips
• Day 10: Success stories
• Day 13: Conversion offer

**Why:** Most users need 5-7 touchpoints before buying. One email isn't enough.

**Real example:** Client added 5-email onboarding sequence. Trial-to-paid went from 8% → 23%.

---

**The common thread?**

**Reduce friction. Increase value. Guide the journey.**

Your product might be amazing, but if users don't understand HOW to get value, they'll churn.

**Want help with your onboarding?**

I've created a free "SaaS Onboarding Audit" checklist:
[Download the Checklist]

It's 37 questions covering:
• Signup flow optimization
• First-session experience
• Email sequences
• Activation metrics
• Conversion triggers

Takes 20 minutes to complete. You'll immediately see where you're leaking users.

Give it a try!

Jordan Mitchell
SaaS Onboarding Consultant

P.S. — Next week, I'll share the exact email sequence one of my clients used to increase trial-to-paid by 41%. Stay tuned.

---

[Unsubscribe] | [Case Studies] | [Book a Call]
Jordan Mitchell Consulting | jordan@example.com
```

---

### Why This Works

✅ **Authority established:** "100+ SaaS founders"  
✅ **Pattern recognition:** Shows expertise through trends  
✅ **Specific examples:** Real numbers from real clients  
✅ **Clear structure:** 3 mistakes = scannable  
✅ **Actionable advice:** Can implement immediately  
✅ **Free resource:** Audit checklist provides value  
✅ **Preview next email:** Keeps engagement high  

---

## Nurture Email Best Practices

### Content Mix (80/20 Rule)

**80% Value:**
- How-to tutorials
- Case studies
- Industry insights
- Stories/lessons
- Research findings

**20% Promotion:**
- Product mentions
- Case for paid offering
- Limited-time offers

**Every nurture email should provide value even if they never buy.**

---

### Frequency Guidelines

**Weekly (Recommended):**
- Builds habit without overwhelming
- Sustainable for content creation
- Best for most audiences

**Bi-Weekly:**
- Good for busy audiences (executives, founders)
- Requires higher-quality content per email
- Risk: They forget who you are

**2x/Week:**
- Best for highly engaged audiences
- Requires consistent, high-value content
- Risk: Unsubscribes if quality drops

**Daily:**
- Only for personality-driven brands
- Must be short and valuable
- High risk / high reward

---

### Structure Template

Every nurture email should follow this structure:

1. **Hook (1 sentence):** Grab attention immediately
2. **Context (1 paragraph):** Why this topic matters
3. **Main Content (2-4 paragraphs):** The valuable insight/lesson
4. **Actionable Takeaway (bullets/steps):** What they can do now
5. **CTA (1 link/button):** Next step (resource, content, soft offer)
6. **Preview (P.S.):** What's coming next to maintain engagement

**Length:** 250-400 words (3-5 minute read)

---

### Subject Line Formulas for Nurture

**Educational:**
- "How to [achieve outcome] in [timeframe]"
- "The [number] biggest mistakes I see [audience] make"
- "What I learned from [experience/research]"

**Story-driven:**
- "The day I [learned important lesson]"
- "Why I [controversial opinion]"
- "What [number] years of [experience] taught me"

**Curiosity:**
- "You're probably doing this wrong"
- "The [adjective] truth about [topic]"
- "What nobody tells you about [topic]"

**Personal:**
- "{{ subscriber.first_name }}, quick question"
- "This reminded me of you"
- "I need your advice"

---

## Measuring Success

**Key Metrics:**

- **Open Rate:** 25-35% (nurture average)
- **Click Rate:** 3-6%
- **Reply Rate:** 1-3% (high engagement)
- **Unsubscribe Rate:** <0.5% per email
- **Conversion to SQL:** 10-20% (over full sequence)

**A/B Test:**
- Subject lines (always)
- Story vs. tactical content
- Length (short vs. long)
- CTA placement and wording
- Personal stories vs. case studies

---

## Common Mistakes to Avoid

❌ **Being too salesy:** Nurture = build trust, not push product  
❌ **Generic advice:** "Work hard" isn't valuable  
❌ **No clear takeaway:** Every email should teach something  
❌ **Too infrequent:** They forget who you are  
❌ **Too frequent:** Inbox fatigue  
❌ **No variety:** Same format every time = boring  

---

**Remember: Nurture emails build the relationship that makes the sale possible later. Focus on value first, always.**

---

**Version 1.0.0** | Last Updated: 2026-02-17
