---
name: ket-exam-prep-app
description: Guides development of KET (A2 Key for Schools) exam preparation and English learning applications. Supports both English beginners (Pre-A1, A1) and KET prep learners. Use when building listening, speaking, reading, or writing features, Cambridge A2 learning apps, or beginner-friendly English practice.
---

# KET 备考与英语学习应用开发指南

本 Skill 指导开发面向**英语初学者**和**KET 备考**的应用：既支持 Pre-A1 / A1 零基础学习，也支持 A2 Key for Schools 考试准备。

## 考试结构概览

| 模块 | 时长 | 占比 | 说明 |
|------|------|------|------|
| Reading and Writing | 60 分钟 | 50% | 阅读 Part 1–5 + 写作 Part 6–7 |
| Listening | 30 分钟（含 6 分钟誊写） | 25% | 每段录音播放两遍 |
| Speaking | 8–10 分钟/对 | 25% | 面对面，1–2 位考生，2 位考官 |

---

## 英语初学者支持（Pre-A1 / A1）

应用应支持零基础或初级用户，提供从入门到 KET 的渐进路径。

### 等级与能力对应

| 等级 | 词汇量约 | 能力概述 |
|------|----------|----------|
| Pre-A1 | ~300 | 认识字母、数字、基础词汇；听懂简单指令；说单词或极短句 |
| A1 | ~600 | 自我介绍、日常寒暄；理解简单短句；写单词或短句 |
| A2 (KET) | ~1500 | 日常场景沟通；阅读短文；写便条、邮件、简单故事 |

### 初学者学习路径设计

**1. Pre-A1 起步**
- **听**：单词发音、简单指令（stand up, sit down）、数字/颜色/动物
- **说**：跟读单词、简单短语（Hello, My name is...）
- **读**：字母、单词认读、图词配对
- **写**：字母书写、抄写单词
- **题型**：看图选词、听音选图、拖拽配对、跟读录音

**2. A1 进阶**
- **听**：短对话、简单问题（What's your name? How old are you?）
- **说**：自我介绍、回答个人问题、简单喜好（I like...）
- **读**：短句、简单告示、图配句
- **写**：填空单词、短句、简单邮件（10–15 词）
- **题型**：单选、填空、配对；逐步引入 KET Part 1 简化版

**3. A2 备考衔接**
- 从 A1 练习过渡到 KET 题型
- 词汇与语法按 A2 大纲扩展
- 题型难度阶梯：先 Part 1 简化 → 完整 Part 1 → 其他 Part

### 初学者词汇主题（Pre-A1 / A1）

- 字母、数字、颜色、形状
- 动物、身体部位、家庭成员
- 食物饮料、衣服、房间与家具
- 学校物品、日常动词（go, have, like, play）
- 天气、星期、月份、基础形容词

### 初学者语法重点

- be 动词（am, is, are）
- 一般疑问句（Do you...? Is it...?）
- 简单时态：一般现在时、一般过去时（was/were, 规则动词 -ed）
- 冠词 a/an/the、人称代词、物主代词
- 基础介词（in, on, at, under）

### 初学者功能设计要点

- **难度可选**：首次使用或设置中可选择「初学者 / 备考 KET」
- **无门槛入口**：不强制要求词汇量，从字母/数字/基础词开始
- **图片优先**：大量配图，降低纯文字门槛
- **即时发音**：单词/句子可点击播放，支持跟读
- **鼓励式反馈**：答错给出提示而非惩罚，强化正确示范
- **进度可视化**：显示当前等级、解锁进度，增强成就感

---

## Reading 阅读模块（Part 1–5，32 题）

### Part 1 - 多项选择
- **题型**：6 段短文本（告示、标语等）→ 选主要信息
- **应用实现**：短文本 + 3 选项，点击选择

### Part 2 - 配对
- **题型**：7 个问题 + 3 篇同主题短文 → 匹配对应文本
- **应用实现**：拖拽匹配或下拉选择

### Part 3 - 阅读理解
- **题型**：1 篇长文，5 道 3 选 1
- **应用实现**：文章展示 + 题目列表，支持高亮定位

### Part 4 - 选词填空（Multiple-choice cloze）
- **题型**：说明文/事实文本，6 个空，每空 4 选 1（词汇为主）
- **应用实现**：下拉或点击选词填空

### Part 5 - 开放式填空（Open cloze）
- **题型**：邮件/短信，6 个空，每空填 1 个词（语法为主）
- **应用实现**：输入框填空，需支持拼写检查

### A2 阅读词汇重点
- 日常场景：购物、交通、学校、家庭、爱好
- 常见词性：名词、动词、形容词、副词、介词
- 需掌握：基本连词（and, but, or, because）、时态（一般现在/过去/将来）

---

## Writing 写作模块（Part 6–7）

### Part 6 -  guided writing
- **要求**：写邮件或便条，**不少于 25 词**
- **题目**：给出 3 个要点，必须全部回应
- **应用实现**：显示要点、字数统计、拼写检查；可提供范文对比

### Part 7 - 看图写故事
- **要求**：根据 3 张图片写故事，**不少于 35 词**
- **应用实现**：展示 3 图顺序、字数统计；可提供结构提示（beginning/middle/end）

### 写作评分要点
- 内容完整性（是否回应所有要点）
- 语言准确性（语法、拼写）
- 词汇与句式多样性
- 连贯性（连接词、顺序）

---

## Listening 听力模块（5 parts，25 题）

### Part 1 - 多项选择
- **题型**：5 段短对话，选正确图片
- **应用实现**：音频播放 + 3 张图选项；需控制播放次数（模拟仅 2 遍）

### Part 2 - 填空
- **题型**：独白，在便签/笔记上填 5 个空（姓名、数字、日期等）
- **应用实现**：音频 + 填空表单；支持数字、日期、拼写输入

### Part 3 - 多项选择（对话）
- **题型**：1 段对话，5 道 3 选 1
- **应用实现**：音频 + 题目列表

### Part 4 - 多项选择（主旨）
- **题型**：5 段短独白/对话，选主旨/大意/话题
- **应用实现**：每题单独音频或连续播放

### Part 5 - 配对
- **题型**：1 段对话，5 项配对（如人物与活动）
- **应用实现**：拖拽或下拉配对

### 听力语速与难度
- 语速：较慢、清晰
- 场景：日常、学校、购物、旅行、活动安排
- 需识别：数字、日期、时间、人名、地点、简单指令

---

## Speaking 口语模块（2 parts）

### Part 1 - 面试（3–4 分钟）
- **内容**：回答个人问题（姓名、学校、爱好、日常生活等）
- **应用实现**：
  - 题库：常见 personal questions
  - 语音输入 + AI 评估或录音回放
  - 可提供参考答案和句型模板

### Part 2 - 讨论（5–6 分钟）
- **内容**：讨论喜好、给出理由；与搭档互动
- **应用实现**：
  - 话题卡：hobbies, food, sports, places, activities
  - 单人模式：AI 扮演搭档提问
  - 双人模式：配对练习，轮流提问与回答
  - 提供 "I like... because..." 等句型支架

### 口语评分要点
- 词汇与语法
- 发音与流利度
- 互动能力（提问、回应）
- 内容相关性与完整性

---

## 应用功能设计建议

### 通用特性
- **进度追踪**：按模块/题型记录完成度与正确率；初学者模式显示等级进度
- **错题本**：收集错题，支持重复练习
- **难度分级**：初学者按 Pre-A1 → A1 进阶；备考从 Part 1 起逐步增加难度
- **计时器**：备考模式可模拟真实考试时长；初学者模式可关闭或设为宽松

### 儿童友好设计
- 界面简洁、色彩温和
- 即时反馈（✓/✗）与鼓励语
- 成就/徽章系统
- 每日目标与打卡

### 内容生成提示
- **A2 备考**：阅读/听力文本控制在 A2 词汇，句子简短
- **初学者**：Pre-A1/A1 内容用图多、词少、句短；避免生僻词
- 写作题目：贴近学生生活（朋友、周末、旅行、爱好）
- 口语话题：school, family, hobbies, food, sports, holidays

### 初学者与备考模式切换
- 应用应能识别用户等级或让用户选择模式（初学者 / 备考）
- 初学者模式：展示 Pre-A1 → A1 渐进练习，不强调 KET 题型
- 备考模式：展示 KET 题型结构，可含 A1 复习入口
- 可选：根据完成情况自动推荐「升级到备考模式」

---

## 开发检查清单

### 初学者支持
- [ ] 等级选择或首次使用引导（初学者 / 备考）
- [ ] Pre-A1 练习：字母、数字、基础词汇、图词配对、听音选图
- [ ] A1 练习：短句理解、填空、简单对话、自我介绍
- [ ] 词汇分级：Pre-A1 / A1 / A2 词表，生词标注与复习
- [ ] 图片优先、即时发音、鼓励式反馈

### KET 备考
- [ ] Reading：5 种题型均可练习，含答案解析
- [ ] Writing：Part 6 要点检查、Part 7 图片顺序，字数统计
- [ ] Listening：音频播放、进度条、可重复播放
- [ ] Speaking：题库、录音/语音识别、基础评估或反馈
- [ ] 进度：模块完成度、正确率、错题记录
