#!/bin/bash
# Setup stealth browser tools in pybox
# Usage: bash scripts/setup.sh

set -e

echo "🥷 Setting up stealth browser tools in pybox..."

# Check if distrobox is available
if ! command -v distrobox &> /dev/null; then
    echo "❌ Error: distrobox not found. Install it first."
    exit 1
fi

# Check if pybox exists
if ! distrobox list | grep -q "pybox"; then
    echo "❌ Error: pybox container not found."
    echo "   Create it with: distrobox create --name pybox --image fedora:latest"
    exit 1
fi

echo "📦 Installing Python packages..."
distrobox-enter pybox -- pip install --upgrade pip
distrobox-enter pybox -- pip install camoufox curl_cffi

echo "🦊 Installing Camoufox browser..."
distrobox-enter pybox -- python -c "import camoufox; camoufox.install()"

echo "🔧 Installing system dependencies for headed mode..."
distrobox-enter pybox -- sudo dnf install -y gtk3 libXt nss at-spi2-atk cups-libs libdrm mesa-libgbm 2>/dev/null || true

echo ""
echo "✅ Setup complete!"
echo ""
echo "Test with:"
echo "  distrobox-enter pybox -- python scripts/nodriver-fetch.py https://bot.sannysoft.com --screenshot test.png"
echo ""
echo "Or for maximum stealth:"
echo "  distrobox-enter pybox -- python scripts/camoufox-fetch.py https://nowsecure.nl --screenshot test.png"
