# Stealth Browser Skill 🥷

Anti-bot browser automation that bypasses Cloudflare Turnstile, Datadome, and aggressive fingerprinting on sites like Airbnb and Yelp.

[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](LICENSE)

## Why This Exists

Standard Playwright/Selenium gets blocked by modern anti-bot systems. This skill provides battle-tested tools:

| Tool | Best For |
|------|----------|
| **Camoufox** | All protected sites - Cloudflare, Datadome, Yelp, Airbnb |
| **curl_cffi** | API scraping with TLS fingerprint spoofing |

## Quick Start

```bash
# Install
openclaw skill install stealth-browser

# Setup (first time)
bash scripts/setup.sh

# Fetch a protected page
distrobox-enter pybox -- python scripts/nodriver-fetch.py "https://example.com"

# Maximum stealth
distrobox-enter pybox -- python scripts/camoufox-fetch.py "https://yelp.com/biz/example"
```

## Requirements

- `distrobox` with a `pybox` container
- Residential proxy for Airbnb/Yelp (datacenter IPs are blocked)

## Tools

### Camoufox
Custom Firefox build with C++ level stealth patches. Maximum evasion.
```bash
distrobox-enter pybox -- python scripts/camoufox-fetch.py "https://example.com" \
  --headless --wait 8 --output page.html
```

### curl_cffi
TLS fingerprint spoofing for API endpoints. No browser overhead.
```bash
distrobox-enter pybox -- python scripts/curl-api.py "https://api.example.com" \
  --impersonate chrome120
```

## Documentation

- [SKILL.md](SKILL.md) — Full usage guide
- [references/proxy-setup.md](references/proxy-setup.md) — Proxy configuration
- [references/fingerprint-checks.md](references/fingerprint-checks.md) — What anti-bot checks

## License

Apache 2.0 — See [LICENSE](LICENSE)

---

Made with 🥷 by [Kessler.io](https://kessler.io)
