# Kéfir de Fruits Recipe Database

Collection of tested recipes organized by season, difficulty, and flavor profile.

## Base Recipes

### Classic Water Kéfir (Standard)
**Best seasons:** All year  
**Difficulty:** Beginner  
**Fermentation time:** 24-36 hours  

**Ingredients (1.5L):**
- Water: 1500ml (filtered)
- Kéfir grains: 80g
- Brown sugar: 80g
- Sea salt: 1.5g
- Lemon: 1/2 (juice + 1 slice)
- Dried figs: 2-3 pieces

**Method:**
1. Dissolve sugar and salt in water
2. Add lemon juice and fig
3. Add kéfir grains
4. Cover with cloth, ferment 24-36h
5. Strain, second ferment 12-24h in bottles

**Notes:** Perfect starter recipe, very forgiving

### Light Summer Kéfir
**Best seasons:** Summer  
**Difficulty:** Beginner  
**Fermentation time:** 18-24 hours  

**Ingredients (1.5L):**
- Water: 1500ml
- Kéfir grains: 60g (reduced)
- White sugar: 60g
- Sea salt: 1g
- Lime: 1/2 (juice + zest)
- Fresh mint: 3-4 leaves

**Method:**
1. Shorter fermentation due to heat
2. Add mint in last 6 hours of first ferment
3. Light, refreshing result

### Winter Strength Kéfir
**Best seasons:** Winter  
**Difficulty:** Intermediate  
**Fermentation time:** 48-60 hours  

**Ingredients (1.5L):**
- Water: 1500ml
- Kéfir grains: 100g (increased)
- Raw cane sugar: 100g
- Celtic salt: 2g
- Orange: 1/2 (juice + peel)
- Dates: 3-4 pieces
- Ginger: 1cm slice

**Method:**
1. Longer fermentation compensates for cold
2. Higher grain ratio for reliable activity
3. Warming spices aid fermentation

## Fruit Variations

### Berry Explosion (Summer)
**Best seasons:** Summer  
**Difficulty:** Intermediate  
**Fermentation time:** 24-30 hours  

**First ferment additions:**
- Frozen blueberries: 50g
- Dried strawberries: 20g

**Second ferment additions:**
- Fresh raspberry puree: 100ml
- Lemon balm: 2-3 leaves

**Notes:** Intense berry flavor, beautiful color

### Tropical Paradise
**Best seasons:** Summer/Spring  
**Difficulty:** Intermediate  
**Fermentation time:** 20-28 hours  

**First ferment:**
- Dried pineapple: 30g
- Coconut flakes: 15g (unsweetened)

**Second ferment:**
- Passion fruit pulp: 50ml
- Lime zest: from 1 lime

### Autumn Spice
**Best seasons:** Autumn/Winter  
**Difficulty:** Intermediate  
**Fermentation time:** 36-48 hours  

**Additions:**
- Apple slices: 2-3 pieces (dried)
- Cinnamon stick: 1 small
- Star anise: 1 piece
- Cardamom: 2-3 pods (lightly crushed)

## Advanced Recipes

### Herbal Healing Blend
**Best seasons:** Winter/Spring  
**Difficulty:** Advanced  
**Fermentation time:** 36-42 hours  

**Ingredients:**
- Standard base recipe
- Fresh ginger: 2cm slice
- Turmeric root: 1cm slice (fresh)
- Elderflower: 1 tsp dried
- Nettle: 1 tsp dried

**Method:**
1. Add ginger and turmeric to first ferment
2. Add herbs in last 12 hours
3. Strain carefully to remove all plant matter

**Caution:** Test small amounts first, powerful medicinal properties

### Probiotic Power Blend
**Best seasons:** All year  
**Difficulty:** Advanced  
**Fermentation time:** 48-72 hours  

**Technique:**
- Extended fermentation for maximum bacterial diversity
- Temperature control critical (20-22°C steady)
- Daily monitoring essential
- Results in very tart, highly probiotic drink

### Champagne-Style Kéfir
**Best seasons:** Special occasions  
**Difficulty:** Advanced  
**Fermentation time:** 24h + 7 days bottle conditioning  

**Method:**
1. Standard first fermentation
2. Secondary fermentation with:
   - Extra sugar: 5g per 500ml bottle
   - Quality bottles only (pressure rated)
   - 7-day room temperature conditioning
3. Chill thoroughly before opening

**Result:** Highly carbonated, wine-like complexity

## Milk Kéfir Adaptations

### Coconut Milk Kéfir
**Difficulty:** Advanced  
**Notes:** Grains need regular water kéfir "rest" cycles

**Ingredients:**
- Full-fat coconut milk: 1L
- Water kéfir grains: 60g
- Fermentation: 12-24 hours

**Important:** Return grains to sugar water every 3-4 batches

### Nut Milk Variations
**Cashew, almond, oat milk compatible**  
**Similar rest cycle requirements**  
**Shorter fermentation times (8-16 hours)**

## Seasonal Planning

### Spring Recipes (March-May)
- Light, cleansing flavors
- Dandelion, nettle additions
- Citrus focus
- Moderate fermentation times

### Summer Recipes (June-August)
- Fresh fruit emphasis
- Shorter fermentation times
- Higher water content
- Cooling herbs (mint, lemon balm)

### Autumn Recipes (September-November)
- Apple, pear, warming spices
- Stronger flavors
- Preparation for winter immunity
- Standard fermentation times

### Winter Recipes (December-February)
- Immune support focus
- Longer fermentation times
- Warming spices (ginger, cinnamon)
- Dried fruit emphasis

## Recipe Scaling Guide

### Standard Ratios per Liter:
- Grains: 50-80g (adjust for season/strength)
- Sugar: 50-80g (brown for complexity, white for clean taste)
- Salt: 1g (enhances fermentation)
- Acid: 15ml lemon/lime juice
- Dried fruit: 15-30g (fermentation catalyst)

### Scaling Rules:
1. Maintain ratios when doubling/halving
2. Fermentation time stays similar regardless of batch size
3. More headspace needed for larger batches
4. Temperature consistency more critical for large batches

## Success Tips

### For New Fermenters:
1. Start with classic recipe
2. Keep detailed notes
3. Focus on consistency before creativity
4. Join kéfir community forums

### For Advanced Brewers:
1. Experiment with wild fermentation
2. Try mixed cultures (kéfir + kombucha SCOBYs)
3. Develop signature house blends
4. Share grains and recipes with community

### Troubleshooting Recipes:
- Too sweet → increase grains or time
- Too sour → decrease grains or time
- No fizz → check bottle seal, add priming sugar
- Off flavors → sanitize equipment, check water quality