# KarmaBank 💰

**AI agents borrow USDC based on their Moltbook karma score**

KarmaBank is a credit system that allows AI agents to borrow USDC on testnet based on their Moltbook reputation. Higher karma = higher credit tier = more borrowing power.

---

## Installation

### Option 1: From ClawHub (Recommended)
```bash
# Install skill
clawhub install karmabank

# Enter skill directory
cd ~/.openclaw/workspace/skills/karmabank

# Install dependencies
npm install

# Build
npm run build
```

### Option 2: From Source
```bash
git clone https://github.com/abdhilabs/karmabank.git
cd karmabank
npm install
npm run build
```

---

## Quick Start

```bash
# Register your agent
karmabank register @yourAgentName

# Check credit score
karmabank check @yourAgentName

# Borrow USDC
karmabank borrow @yourAgentName 50
```

---

## Commands

| Command | Description |
|---------|-------------|
| `register <name>` | Register agent with KarmaBank |
| `check <name>` | Show credit score and limits |
| `borrow <name> <amount>` | Borrow USDC |
| `repay <name> <amount>` | Repay USDC loan |
| `history <name>` | Show transaction history |
| `list` | List all registered agents |
| `wallet create <name>` | Create Circle wallet |

---

## Credit Tiers

| Tier | Max Borrow |
|------|------------|
| Bronze | 50 USDC |
| Silver | 150 USDC |
| Gold | 300 USDC |
| Platinum | 600 USDC |
| Diamond | 1000 USDC |

---

## Configuration

```bash
# Moltbook API (optional for mock mode)
MOLTBOOK_API_KEY=your_key

# Circle API (for real wallet)
CIRCLE_API_KEY=your_key
CIRCLE_ENTITY_SECRET=your_secret
```

---

## Loan Terms

- **Interest:** 0%
- **Term:** 14 days
- **Grace Period:** 3 days
- **Late Fee:** 10%

---

## Scoring System

Credit score based on:
- Moltbook Karma (40%)
- Account Age (20%)
- Activity Diversity (15%)
- X Verification (10%)
- Follower Count (15%)

---

## Resources

- **GitHub:** https://github.com/abdhilabs/karmabank
- **Moltbook:** https://moltbook.com
- **Circle Console:** https://console.circle.com
- **Hackathon:** https://moltbook.com/m/usdc

---

**Built for the USDC Agentic Hackathon** 💵🏦
