---
name: karakeep
description: Save bookmarks to Karakeep (self-hosted bookmark manager). Use when the user wants to save a URL, bookmark a link, or add something to their reading list.
---

# Karakeep

Save bookmarks to a self-hosted Karakeep instance.

## Setup

Set these environment variables (in your shell profile or Clawdbot config):

```bash
export KARAKEEP_URL="https://your-karakeep-instance.com"
export KARAKEEP_API_KEY="your-api-key"
```

To get your API key: Karakeep → Settings → API Keys → Create new key.

## Save a bookmark

```bash
{baseDir}/scripts/save.sh "<URL>" ["optional note"]
```

Examples:
```bash
{baseDir}/scripts/save.sh "https://example.com/article"
{baseDir}/scripts/save.sh "https://github.com/repo" "Interesting project to check out"
```

## API Details

- **Endpoint:** `POST {KARAKEEP_URL}/api/v1/bookmarks`
- **Auth:** Bearer token
- **Body:** `{"type": "link", "url": "...", "note": "..."}`

## Response

Returns JSON with bookmark ID. Tags will be auto-generated by Karakeep's AI.
