#!/bin/bash
# Check Kameo credit balance

API_KEY="${KAMEO_API_KEY:-}"
if [ -z "$API_KEY" ] && [ -f ~/.config/kameo/credentials.json ]; then
    API_KEY=$(jq -r '.api_key' ~/.config/kameo/credentials.json)
fi

if [ -z "$API_KEY" ]; then
    echo "❌ KAMEO_API_KEY not set"
    exit 1
fi

echo "💰 Checking Kameo credits..."

RESPONSE=$(curl -s -H "X-API-Key: $API_KEY" \
  https://api.kameo.chat/api/public/credits)

echo "$RESPONSE" | jq .

TOTAL=$(echo "$RESPONSE" | jq -r '.total_available // 0')
echo ""
echo "📊 Total available: $TOTAL credits"
echo "   (3 credits per 5-second video)"
echo "   Can generate: $((TOTAL / 3)) videos"
