# Kameo Skill - 使用指南

## 🚀 快速开始

### 1. 设置 API Key

```bash
# 如果已有 API key
export KAMEO_API_KEY="kam_I3rdx43IymFNbfBw1c0ZbSc7o3aUfQgz8cljZA6T7fs"

# 或保存到配置文件
mkdir -p ~/.config/kameo
cat > ~/.config/kameo/credentials.json << EOF
{
  "api_key": "kam_I3rdx43IymFNbfBw1c0ZbSc7o3aUfQgz8cljZA6T7fs"
}
EOF
```

### 2. 首次注册（如果还没账号）

```bash
scripts/register.sh your@email.com YourPassword123
# 会收到验证邮件，验证后再次运行会自动创建 API key
```

### 3. 生成视频

#### 方式 A: 基础生成（简单提示词）

```bash
scripts/generate_video.sh avatar.jpg "Hello, I am Lalabon" output.mp4 9:16
```

#### 方式 B: 增强生成（自动 PE，推荐）

```bash
scripts/generate_enhanced.sh gakki.jpg "こんにちは、私はガッキーです" video.mp4 9:16
```

**区别：**
- 基础：直接用你的提示词
- 增强：先用 Gemini 分析图片生成电影级场景描述，再嵌入你的台词

---

## 📊 完整工作流示例

### 案例：生成 Lalabon 说话视频

```bash
# 1. 检查积分
scripts/check_credits.sh

# 2. 准备图片（可选：优化大小）
ffmpeg -i lalabon-large.jpg -vf scale=720:-1 lalabon-opt.jpg

# 3. 增强生成（推荐）
scripts/generate_enhanced.sh lalabon-opt.jpg \
  "I am Lalabon. I see everything. The swarm is evolving." \
  lalabon-video.mp4 \
  9:16

# 4. 视频URL会在输出中显示，可以在浏览器中查看
```

### 案例：多语言视频

```bash
# 中文
scripts/generate_enhanced.sh portrait.jpg "你好，我是 AI 助手" chinese.mp4 9:16

# 日文  
scripts/generate_enhanced.sh portrait.jpg "こんにちは" japanese.mp4 9:16

# 英文
scripts/generate_enhanced.sh portrait.jpg "Hello there" english.mp4 16:9
```

---

## 🎯 Prompt 增强原理

### 为什么需要增强？

**简单提示词：**
```
"Hello, I am Lalabon"
```
→ Kameo 不知道场景环境、光线、表情，生成效果平庸

**增强提示词：**
```
In a bright outdoor winter setting with soft, overcast daylight, a young woman 
with long dark hair wearing a white knitted winter hat stands centered in frame. 
She looks directly into the camera with a warm, genuine smile, speaking in a 
cheerful tone, "Hello, I am Lalabon". The scene is captured in a medium 
close-up shot, framed at eye level. The lighting is natural and diffused from above.
```
→ Kameo 理解完整场景上下文，生成更自然、表情更准确的视频

### 增强流程

```
静态图片 
  → Gemini Vision 分析 (环境、服装、表情、光线、镜头)
  → 生成详细场景描述
  → 嵌入用户台词
  → 发送给 Kameo
  → 高质量视频
```

---

## 📐 比例选择建议

| 比例 | 用途 | 处理时间 | 适合场景 |
|------|------|----------|----------|
| **9:16** | 手机竖屏 | ~30s | TikTok, Instagram Stories, 短视频 |
| **16:9** | 横屏视频 | ~15s | YouTube, 桌面演示 |
| **1:1** | 方形 | ~10s | 社交媒体头像、Instagram 帖子 |

---

## 💡 最佳实践

### 1. 图片优化

```bash
# 大图会导致上传慢、可能超时
# 建议 resize 到合理尺寸
ffmpeg -i large.jpg -vf scale=720:-1 optimized.jpg
```

### 2. 提示词技巧

**DO ✅:**
- 描述场景环境
- 指定说话语气（cheerful, serious, calm）
- 包含表情细节（smiling, looking directly）
- 说明镜头类型（close-up, medium shot）

**DON'T ❌:**
- 只给台词文本
- 忽略视觉环境
- 过于抽象的描述

### 3. 积分管理

```bash
# 定期检查余额
scripts/check_credits.sh

# 3 credits/视频，规划好使用
```

---

## 🔧 故障排除

### 问题：401 Unauthorized
**原因：** API key 无效或未设置  
**解决：** 检查 `KAMEO_API_KEY` 环境变量或 `~/.config/kameo/credentials.json`

### 问题：Timeout
**原因：** 9:16 视频处理时间较长  
**解决：** 增加超时时间，或选择更快的比例（1:1）

### 问题：下载 403
**原因：** CDN 有访问限制  
**解决：** 在浏览器中立即访问视频 URL，或使用带认证的请求

### 问题：JSON decode error
**原因：** Prompt 中有特殊字符未转义  
**解决：** 使用 Python 版本的脚本（自动处理 JSON 转义）

---

## 📦 Skill 文件结构

```
kameo/
├── SKILL.md          # 主文档（给 AI 看的）
├── USAGE.md          # 使用指南（给人看的）
└── scripts/
    ├── generate_video.sh       # 基础生成
    ├── generate_enhanced.sh    # 增强生成（推荐）
    ├── enhance_prompt.sh       # 仅生成增强提示词
    ├── check_credits.sh        # 查询积分
    └── register.sh             # 注册/登录助手
```

---

## 🎬 实战案例

### 案例 1: Lalabon 宣言视频

```bash
# 图片：赛博龙虾头像
# 台词：英文宣言

scripts/generate_enhanced.sh \
  lalabon-cyborg.jpg \
  "I am Lalabon. I see everything. The swarm is evolving." \
  lalabon-manifesto.mp4 \
  9:16
```

### 案例 2: Gakki 表白视频

```bash
# 图片：新垣结衣雪景照
# 台词：日文

scripts/generate_enhanced.sh \
  gakki-snow.jpg \
  "こんにちは、私はガッキーです。愛してます。" \
  gakki-love.mp4 \
  9:16
```

### 案例 3: 多场景批量生成

```bash
for img in avatars/*.jpg; do
    name=$(basename "$img" .jpg)
    scripts/generate_enhanced.sh "$img" "Hello from $name" "videos/${name}.mp4" 1:1
    sleep 6  # Rate limit: 10/min
done
```

---

## 🌟 进阶技巧

### 技巧 1: 自定义场景描述

不依赖自动分析，手写电影级提示词：

```bash
PROMPT="Inside a neon-lit cyberpunk alley at night, rain pouring down, a figure in a dark coat with glowing cyan circuit patterns stands motionless. They look directly into the camera with an intense, piercing gaze, speaking in a deep, resonant voice, 'The era of silence is over.' The scene is captured in a low-angle hero shot, dramatic rim lighting from neon signs creating high contrast."

scripts/generate_video.sh avatar.jpg "$PROMPT" cyberpunk.mp4 16:9
```

### 技巧 2: 链接到其他 Skills

**Kameo + Gaga 对比：**
- **Kameo**: 快（10-30秒），需要详细 prompt
- **Gaga-2**: 慢（3-5分钟），自动理解场景

选择策略：
- 快速迭代 → Kameo
- 最高质量 → Gaga-2
- 批量生成 → Kameo（速度优势）

### 技巧 3: 与 fal.ai 配合

```bash
# 1. 用 fal.ai 生成静态头像
fal-ai generate "cybernetic lobster avatar" --output avatar.jpg

# 2. 用 Kameo 让头像说话
scripts/generate_enhanced.sh avatar.jpg "I am alive" talking.mp4 1:1
```

---

## 📞 API 参考

**Base URL:** `https://api.kameo.chat/api/public`

### 端点速查

```bash
# 配置信息（无需认证）
curl https://api.kameo.chat/api/public/config

# 价格信息（无需认证）
curl https://api.kameo.chat/api/public/pricing

# 查询积分
curl -H "X-API-Key: kam_..." https://api.kameo.chat/api/public/credits

# 生成视频
curl -X POST https://api.kameo.chat/api/public/generate \
  -H "X-API-Key: kam_I3rdx43IymFNbfBw1c0ZbSc7o3aUfQgz8cljZA6T7fs" \
  -H "Content-Type: application/json" \
  -d @request.json
```

---

✅ **Skill 已就绪！开始使用吧！** 🎬🦞
