# Kalshi API Reference

Base URL: `https://api.elections.kalshi.com/trade-api/v2`

## Public Endpoints (No Auth)

### Markets

```
GET /markets
  ?status=open|closed|all
  &series_ticker=SERIES
  &event_ticker=EVENT
  &limit=100
  &cursor=CURSOR
```

```
GET /markets/{ticker}
```

```
GET /markets/{ticker}/orderbook
  ?depth=10
```

### Events

```
GET /events
  ?status=open|closed|all
  &limit=100
  &cursor=CURSOR
```

```
GET /events/{event_ticker}
```

### Series

```
GET /series/{series_ticker}
```

## Authenticated Endpoints

Require API key + private key authentication.

### Account

```
GET /portfolio/balance
```

```
GET /portfolio/positions
  ?limit=100
  &cursor=CURSOR
```

```
GET /portfolio/fills
  ?ticker=TICKER
  &limit=100
  &cursor=CURSOR
```

### Orders (Read-Only for this skill)

```
GET /portfolio/orders
  ?ticker=TICKER
  &status=resting|pending|all
```

## Response Formats

### Market Object
```json
{
  "ticker": "KXBTC-26FEB01-B100000",
  "title": "Bitcoin above $100,000?",
  "subtitle": "On February 1, 2026",
  "status": "open",
  "yes_ask": 65,
  "yes_bid": 63,
  "no_ask": 37,
  "no_bid": 35,
  "last_price": 64,
  "volume": 15420,
  "open_interest": 8500,
  "close_time": "2026-02-01T23:59:59Z"
}
```

### Position Object
```json
{
  "ticker": "KXBTC-26FEB01-B100000",
  "position": 100,
  "average_cost": 62,
  "market_price": 65
}
```

### Orderbook Object
```json
{
  "orderbook": {
    "yes": [[65, 500], [64, 1200], [63, 800]],
    "no": [[37, 400], [36, 900]]
  }
}
```

## Price Semantics

- All prices in **cents** (1-99)
- YES + NO prices ≈ 100¢ (minus spread)
- Price = implied probability (65¢ YES ≈ 65% probability)
- Settlement: winning side pays 100¢, losing side pays 0¢

## Rate Limits

- Public endpoints: 10 req/sec
- Authenticated: 100 req/sec
- WebSocket: Recommended for real-time data

## Python SDK

```python
from kalshi_python import Configuration, KalshiClient

config = Configuration(
    host="https://api.elections.kalshi.com/trade-api/v2"
)

# For auth
config.api_key_id = "your-key"
config.private_key_pem = open("key.pem").read()

client = KalshiClient(config)
```
