---
name: kalshi
description: Trade on Kalshi prediction markets (CFTC-regulated prediction market exchange). Check portfolio, search markets, analyze orderbooks, place/cancel orders. Use when working with Kalshi API, trading binary contracts, checking market prices, managing positions, or researching prediction markets on politics, economics, crypto, weather, sports, technology events.
homepage: https://kalshi.com/docs/api
metadata:
  {
    "openclaw":
      {
        "emoji": "📈",
        "requires": { "bins": ["node"], "env": ["KALSHI_API_KEY_ID", "KALSHI_PRIVATE_KEY_PATH"] },
        "primaryEnv": "KALSHI_API_KEY_ID",
      },
  }
---

# Kalshi

Trade on Kalshi prediction markets via a self-contained CLI script. Supports market search, portfolio tracking, and full order lifecycle (place/cancel/monitor).

## Quick Start

All commands route through a single script. Output is JSON.

## CLI

**Primary script:**

```bash
{baseDir}/scripts/kalshi-cli.mjs <command> [args...]
```

**Helper script:**

```bash
{baseDir}/scripts/quick-analysis.mjs <ticker>
```

Combines market details + orderbook in a single call for fast analysis.

## Commands

| Command                                   | Description                                      |
| ----------------------------------------- | ------------------------------------------------ |
| `balance`                                 | Get account balance (cash + portfolio value)     |
| `portfolio`                               | Get balance + all open positions                 |
| `trending`                                | Top markets by 24h volume                        |
| `search <query>`                          | Search markets by keyword                        |
| `market <ticker>`                         | Get details for a single market                  |
| `orderbook <ticker>`                      | Get bid/ask levels for a market                  |
| `buy <ticker> <yes\|no> <count> <price>`  | Place a buy order (price in cents 1-99)          |
| `sell <ticker> <yes\|no> <count> <price>` | Place a sell order (price in cents 1-99)         |
| `cancel <orderId>`                        | Cancel a resting order                           |
| `orders [resting\|canceled\|executed]`    | List orders, optionally filtered by status       |
| `fills [ticker]`                          | List recent fills, optionally filtered by ticker |

## Examples

```bash
# Check balance
{baseDir}/scripts/kalshi-cli.mjs balance

# See what's trending
{baseDir}/scripts/kalshi-cli.mjs trending

# Search for markets about bitcoin
{baseDir}/scripts/kalshi-cli.mjs search "bitcoin"

# Get details on a specific market
{baseDir}/scripts/kalshi-cli.mjs market KXBTCD-26FEB14-B55500

# Check orderbook
{baseDir}/scripts/kalshi-cli.mjs orderbook KXBTCD-26FEB14-B55500

# Buy 5 YES contracts at 65 cents
{baseDir}/scripts/kalshi-cli.mjs buy KXBTCD-26FEB14-B55500 yes 5 65

# Sell 5 YES contracts at 70 cents
{baseDir}/scripts/kalshi-cli.mjs sell KXBTCD-26FEB14-B55500 yes 5 70

# Check open orders
{baseDir}/scripts/kalshi-cli.mjs orders resting

# Check recent fills
{baseDir}/scripts/kalshi-cli.mjs fills
```

## Output

All commands output JSON to stdout. Parse the result to present it to the user.

## Trading Rules

**Critical:** ALWAYS confirm with the user before placing any buy or sell order.

Before executing a trade, show the user:

- Ticker
- Side (YES or NO)
- Count (number of contracts)
- Price (in cents)
- Total cost = count × price cents = $X.XX

**Price format:**

- Prices are in cents (1-99)
- 65 cents = $0.65 per contract
- Minimum: 1 cent, Maximum: 99 cents

**Payouts:**

- All contracts pay $1.00 (100 cents) if correct, $0 if wrong
- YES at 65¢: costs 65¢, pays $1.00 if YES wins → 35¢ profit per contract
- NO at 35¢: costs 35¢, pays $1.00 if NO wins → 65¢ profit per contract
- YES price + NO price ≈ 100¢ (spreads cause small deviations)

**Before selling:** Verify the user holds the position by checking portfolio first

## Reference Documentation

- **[setup-guide.md](references/setup-guide.md)** - Getting API credentials, configuration, troubleshooting
- **[trading-guide.md](references/trading-guide.md)** - Market mechanics, strategy tips, risk management
- **[api-notes.md](references/api-notes.md)** - Technical API details, data formats, common patterns

## Environment Variables

Required:

- `KALSHI_API_KEY_ID` — your Kalshi API key UUID
- `KALSHI_PRIVATE_KEY_PATH` — absolute path to your RSA private key PEM file

See [setup-guide.md](references/setup-guide.md) for detailed configuration instructions.
